/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.core.ecl.context.internal.viewer;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.jface.text.source.CompositeRuler;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.IVerticalRulerColumn;
import org.eclipse.jface.text.source.LineNumberRulerColumn;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.rcptt.core.ecl.context.EclContext;
import org.eclipse.rcptt.core.model.ModelException;
import org.eclipse.rcptt.ecl.core.CoreFactory;
import org.eclipse.rcptt.ecl.core.Script;
import org.eclipse.rcptt.internal.ui.Q7UIPlugin;
import org.eclipse.rcptt.ui.context.BaseContextEditor;
import org.eclipse.rcptt.ui.controls.SectionWithComposite;
import org.eclipse.rcptt.ui.editors.EditorHeader;
import org.eclipse.rcptt.ui.editors.ecl.EclSourceViewer;
import org.eclipse.rcptt.ui.editors.ecl.EclSourceViewerConfiguration;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class EclContextEditor
extends BaseContextEditor {
    private static final String EMPTY_SCRIPT = "";
    private EclSourceViewer viewer;

    public EclContext getContextElement() {
        try {
            return (EclContext)super.getElement().getNamedElement();
        }
        catch (ModelException e) {
            Q7UIPlugin.log((Throwable)e);
            return null;
        }
    }

    public Control create(Composite parent, FormToolkit toolkit, IWorkbenchSite site, EditorHeader header) {
        Section section = new SectionWithComposite("Script", 322).create(parent, toolkit);
        Composite composite = (Composite)section.getClient();
        CompositeRuler ruler = new CompositeRuler();
        LineNumberRulerColumn column = new LineNumberRulerColumn(){

            public int getWidth() {
                return super.getWidth() + 10;
            }
        };
        Font font = JFaceResources.getTextFont();
        column.setFont(font);
        column.setForeground(parent.getDisplay().getSystemColor(16));
        ruler.addDecorator(0, (IVerticalRulerColumn)column);
        this.viewer = new EclSourceViewer(composite, (IVerticalRuler)ruler, null, false, 2818);
        this.viewer.setEditable(true);
        this.viewer.setDocument((IDocument)new Document(this.getScript()));
        this.viewer.addTextListener(new ITextListener(){

            public void textChanged(TextEvent event) {
                if (!event.getText().equals(event.getReplacedText())) {
                    EclContextEditor.this.setScript(EclContextEditor.this.viewer.getDocument().get());
                }
            }
        });
        toolkit.adapt(this.viewer.getControl());
        this.viewer.configure((SourceViewerConfiguration)new EclSourceViewerConfiguration());
        this.viewer.getTextWidget().setFont(font);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.viewer.getControl());
        return section;
    }

    private String getScript() {
        Script script = this.getContextElement().getScript();
        if (script == null) {
            return EMPTY_SCRIPT;
        }
        String text = script.getContent();
        if (text != null) {
            return text;
        }
        return EMPTY_SCRIPT;
    }

    private void setScript(String content) {
        if (this.getContextElement().getScript() == null) {
            this.getContextElement().setScript(CoreFactory.eINSTANCE.createScript());
        }
        this.getContextElement().getScript().setContent(content);
    }
}

