/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.packageview;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.packageview.ClassPathContainer;
import org.eclipse.jdt.internal.ui.packageview.LibraryContainer;
import org.eclipse.jdt.internal.ui.packageview.PackageFragmentRootContainer;
import org.eclipse.jdt.internal.ui.packageview.PackagesMessages;
import org.eclipse.jdt.internal.ui.workingsets.WorkingSetModel;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jdt.ui.StandardJavaElementContentProvider;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.progress.UIJob;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PackageExplorerContentProvider
extends StandardJavaElementContentProvider
implements IElementChangedListener,
IPropertyChangeListener {
    protected static final int ORIGINAL = 0;
    protected static final int PARENT = 1;
    protected static final int GRANT_PARENT = 2;
    protected static final int PROJECT = 4;
    private TreeViewer fViewer;
    private Object fInput;
    private boolean fIsFlatLayout = false;
    private boolean fShowLibrariesNode = false;
    private boolean fFoldPackages = this.arePackagesFoldedInHierarchicalLayout();
    private Collection<Runnable> fPendingUpdates = null;
    private UIJob fUpdateJob;

    public PackageExplorerContentProvider(boolean provideMembers) {
        super(provideMembers);
        JavaPlugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
        this.fUpdateJob = null;
    }

    private boolean arePackagesFoldedInHierarchicalLayout() {
        return PreferenceConstants.getPreferenceStore().getBoolean("org.eclipse.jdt.ui.flatPackagesInPackageExplorer");
    }

    protected Object getViewerInput() {
        return this.fInput;
    }

    public void elementChanged(ElementChangedEvent event) {
        ArrayList<Runnable> runnables = new ArrayList<Runnable>();
        try {
            if (this.inputDeleted(runnables)) {
                return;
            }
            try {
                this.processDelta(event.getDelta(), runnables);
            }
            catch (JavaModelException e) {
                JavaPlugin.log(e);
            }
        }
        finally {
            this.executeRunnables(runnables);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void executeRunnables(Collection<Runnable> runnables) {
        Control ctrl = this.fViewer.getControl();
        if (ctrl != null && !ctrl.isDisposed()) {
            boolean hasPendingUpdates;
            PackageExplorerContentProvider packageExplorerContentProvider = this;
            synchronized (packageExplorerContentProvider) {
                hasPendingUpdates = this.fPendingUpdates != null && !this.fPendingUpdates.isEmpty();
            }
            if (!hasPendingUpdates && ctrl.getDisplay().getThread() == Thread.currentThread() && !this.fViewer.isBusy()) {
                this.runUpdates(runnables);
            } else {
                packageExplorerContentProvider = this;
                synchronized (packageExplorerContentProvider) {
                    if (this.fPendingUpdates == null) {
                        this.fPendingUpdates = runnables;
                    } else {
                        this.fPendingUpdates.addAll(runnables);
                    }
                }
                this.postAsyncUpdate(ctrl.getDisplay());
            }
        }
    }

    private void postAsyncUpdate(Display display) {
        if (this.fUpdateJob == null) {
            this.fUpdateJob = new UIJob(display, PackagesMessages.PackageExplorerContentProvider_update_job_description){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    TreeViewer viewer = PackageExplorerContentProvider.this.fViewer;
                    if (viewer != null && viewer.isBusy()) {
                        this.schedule(100L);
                    } else {
                        PackageExplorerContentProvider.this.runPendingUpdates();
                    }
                    return Status.OK_STATUS;
                }
            };
            this.fUpdateJob.setSystem(true);
        }
        this.fUpdateJob.schedule();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runPendingUpdates() {
        Control control;
        Collection<Runnable> pendingUpdates;
        PackageExplorerContentProvider packageExplorerContentProvider = this;
        synchronized (packageExplorerContentProvider) {
            pendingUpdates = this.fPendingUpdates;
            this.fPendingUpdates = null;
        }
        if (pendingUpdates != null && this.fViewer != null && (control = this.fViewer.getControl()) != null && !control.isDisposed()) {
            this.runUpdates(pendingUpdates);
        }
    }

    private void runUpdates(Collection<Runnable> runnables) {
        Iterator<Runnable> runnableIterator = runnables.iterator();
        while (runnableIterator.hasNext()) {
            runnableIterator.next().run();
        }
    }

    private boolean inputDeleted(Collection<Runnable> runnables) {
        if (this.fInput == null) {
            return false;
        }
        if (this.fInput instanceof IJavaElement && ((IJavaElement)this.fInput).exists()) {
            return false;
        }
        if (this.fInput instanceof IResource && ((IResource)this.fInput).exists()) {
            return false;
        }
        if (this.fInput instanceof WorkingSetModel) {
            return false;
        }
        if (this.fInput instanceof IWorkingSet) {
            return false;
        }
        this.postRefresh(this.fInput, 0, this.fInput, runnables);
        return true;
    }

    @Override
    public void dispose() {
        super.dispose();
        JavaCore.removeElementChangedListener((IElementChangedListener)this);
        JavaPlugin.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
    }

    @Override
    protected Object[] getPackageFragmentRootContent(IPackageFragmentRoot root) throws JavaModelException {
        if (this.fIsFlatLayout) {
            return super.getPackageFragmentRootContent(root);
        }
        ArrayList<Object> result = new ArrayList<Object>();
        this.getHierarchicalPackageChildren(root, null, result);
        if (!this.isProjectPackageFragmentRoot(root)) {
            Object[] nonJavaResources = root.getNonJavaResources();
            int i = 0;
            while (i < nonJavaResources.length) {
                result.add(nonJavaResources[i]);
                ++i;
            }
        }
        return result.toArray();
    }

    @Override
    protected Object[] getPackageContent(IPackageFragment fragment) throws JavaModelException {
        if (this.fIsFlatLayout) {
            return super.getPackageContent(fragment);
        }
        ArrayList<Object> result = new ArrayList<Object>();
        this.getHierarchicalPackageChildren((IPackageFragmentRoot)fragment.getParent(), fragment, result);
        Object[] nonPackages = super.getPackageContent(fragment);
        if (result.isEmpty()) {
            return nonPackages;
        }
        int i = 0;
        while (i < nonPackages.length) {
            result.add(nonPackages[i]);
            ++i;
        }
        return result.toArray();
    }

    @Override
    protected Object[] getFolderContent(IFolder folder) throws CoreException {
        if (this.fIsFlatLayout) {
            return super.getFolderContent(folder);
        }
        ArrayList<Object> result = new ArrayList<Object>();
        this.getHierarchicalPackagesInFolder(folder, result);
        Object[] others = super.getFolderContent(folder);
        if (result.isEmpty()) {
            return others;
        }
        int i = 0;
        while (i < others.length) {
            result.add(others[i]);
            ++i;
        }
        return result.toArray();
    }

    @Override
    public Object[] getChildren(Object parentElement) {
        try {
            if (parentElement instanceof IJavaModel) {
                return PackageExplorerContentProvider.concatenate(this.getJavaProjects((IJavaModel)parentElement), this.getNonJavaProjects((IJavaModel)parentElement));
            }
            if (parentElement instanceof PackageFragmentRootContainer) {
                return this.getContainerPackageFragmentRoots((PackageFragmentRootContainer)parentElement);
            }
            if (parentElement instanceof IProject) {
                IProject project = (IProject)parentElement;
                if (project.isAccessible()) {
                    return project.members();
                }
                return NO_CHILDREN;
            }
            return super.getChildren(parentElement);
        }
        catch (CoreException coreException) {
            return NO_CHILDREN;
        }
    }

    @Override
    protected Object[] getPackageFragmentRoots(IJavaProject project) throws JavaModelException {
        IClasspathEntry classpathEntry;
        if (!project.getProject().isOpen()) {
            return NO_CHILDREN;
        }
        ArrayList<Object> result = new ArrayList<Object>();
        IPackageFragmentRoot[] roots = project.getPackageFragmentRoots();
        int i = 0;
        while (i < roots.length) {
            IPackageFragmentRoot root = roots[i];
            classpathEntry = root.getRawClasspathEntry();
            int entryKind = classpathEntry.getEntryKind();
            if (entryKind != 5) {
                if (this.fShowLibrariesNode && (entryKind == 1 || entryKind == 4)) {
                    IResource resource = root.getResource();
                    if (resource != null && project.getResource().equals((Object)resource.getParent())) {
                        result.add(resource);
                    }
                } else if (this.isProjectPackageFragmentRoot(root)) {
                    Object[] fragments = this.getPackageFragmentRootContent(root);
                    int j = 0;
                    while (j < fragments.length) {
                        result.add(fragments[j]);
                        ++j;
                    }
                } else {
                    result.add(root);
                }
            }
            ++i;
        }
        if (this.fShowLibrariesNode) {
            result.add(new LibraryContainer(project));
        }
        IClasspathEntry[] rawClasspath = project.getRawClasspath();
        int i2 = 0;
        while (i2 < rawClasspath.length) {
            classpathEntry = rawClasspath[i2];
            if (classpathEntry.getEntryKind() == 5) {
                result.add(new ClassPathContainer(project, classpathEntry));
            }
            ++i2;
        }
        Object[] resources = project.getNonJavaResources();
        int i3 = 0;
        while (i3 < resources.length) {
            result.add(resources[i3]);
            ++i3;
        }
        return result.toArray();
    }

    private Object[] getContainerPackageFragmentRoots(PackageFragmentRootContainer container) {
        return container.getChildren();
    }

    private Object[] getNonJavaProjects(IJavaModel model) throws JavaModelException {
        return model.getNonJavaResources();
    }

    @Override
    protected Object internalGetParent(Object element) {
        if (!this.fIsFlatLayout && element instanceof IPackageFragment) {
            return this.getHierarchicalPackageParent((IPackageFragment)element);
        }
        if (element instanceof IPackageFragmentRoot) {
            IPackageFragmentRoot root = (IPackageFragmentRoot)element;
            try {
                IClasspathEntry entry = root.getRawClasspathEntry();
                int entryKind = entry.getEntryKind();
                if (entryKind == 5) {
                    return new ClassPathContainer(root.getJavaProject(), entry);
                }
                if (this.fShowLibrariesNode && (entryKind == 1 || entryKind == 4)) {
                    return new LibraryContainer(root.getJavaProject());
                }
            }
            catch (JavaModelException javaModelException) {}
        } else if (element instanceof PackageFragmentRootContainer) {
            return ((PackageFragmentRootContainer)element).getJavaProject();
        }
        return super.internalGetParent(element);
    }

    @Override
    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        super.inputChanged(viewer, oldInput, newInput);
        this.fViewer = (TreeViewer)viewer;
        if (oldInput == null && newInput != null) {
            JavaCore.addElementChangedListener((IElementChangedListener)this);
        } else if (oldInput != null && newInput == null) {
            JavaCore.removeElementChangedListener((IElementChangedListener)this);
        }
        this.fInput = newInput;
    }

    private void getHierarchicalPackageChildren(IPackageFragmentRoot parent, IPackageFragment fragment, Collection<Object> result) throws JavaModelException {
        IJavaElement[] children = parent.getChildren();
        String prefix = fragment != null ? String.valueOf(fragment.getElementName()) + '.' : "";
        int prefixLen = prefix.length();
        int i = 0;
        while (i < children.length) {
            IPackageFragment curr = (IPackageFragment)children[i];
            String name = curr.getElementName();
            if (name.startsWith(prefix) && name.length() > prefixLen && name.indexOf(46, prefixLen) == -1) {
                if (this.fFoldPackages) {
                    curr = PackageExplorerContentProvider.getFolded(children, curr);
                }
                result.add(curr);
            } else if (fragment == null && curr.isDefaultPackage()) {
                result.add(curr);
            }
            ++i;
        }
    }

    private void getHierarchicalPackagesInFolder(IFolder folder, Collection<Object> result) throws CoreException {
        IResource[] resources = folder.members();
        int i = 0;
        while (i < resources.length) {
            IFolder curr;
            IJavaElement element;
            IResource resource = resources[i];
            if (resource instanceof IFolder && (element = JavaCore.create((IFolder)(curr = (IFolder)resource))) instanceof IPackageFragment) {
                if (this.fFoldPackages) {
                    IPackageFragment fragment = (IPackageFragment)element;
                    IPackageFragmentRoot root = (IPackageFragmentRoot)fragment.getParent();
                    element = PackageExplorerContentProvider.getFolded(root.getChildren(), fragment);
                }
                result.add(element);
            }
            ++i;
        }
    }

    public Object getHierarchicalPackageParent(IPackageFragment child) {
        String name = child.getElementName();
        IPackageFragmentRoot parent = (IPackageFragmentRoot)child.getParent();
        int index = name.lastIndexOf(46);
        if (index != -1) {
            String realParentName = name.substring(0, index);
            IPackageFragment element = parent.getPackageFragment(realParentName);
            if (element.exists()) {
                try {
                    if (this.fFoldPackages && PackageExplorerContentProvider.isEmpty(element) && PackageExplorerContentProvider.findSinglePackageChild(element, parent.getChildren()) != null) {
                        return this.getHierarchicalPackageParent(element);
                    }
                }
                catch (JavaModelException javaModelException) {}
                return element;
            }
            IResource resource = element.getResource();
            if (resource != null) {
                return resource;
            }
        }
        if (parent.getResource() instanceof IProject) {
            return parent.getJavaProject();
        }
        return parent;
    }

    private static IPackageFragment getFolded(IJavaElement[] children, IPackageFragment pack) throws JavaModelException {
        while (PackageExplorerContentProvider.isEmpty(pack)) {
            IPackageFragment collapsed = PackageExplorerContentProvider.findSinglePackageChild(pack, children);
            if (collapsed == null) {
                return pack;
            }
            pack = collapsed;
        }
        return pack;
    }

    private static boolean isEmpty(IPackageFragment fragment) throws JavaModelException {
        return !fragment.containsJavaResources() && fragment.getNonJavaResources().length == 0;
    }

    private static IPackageFragment findSinglePackageChild(IPackageFragment fragment, IJavaElement[] children) {
        String prefix = String.valueOf(fragment.getElementName()) + '.';
        int prefixLen = prefix.length();
        IPackageFragment found = null;
        int i = 0;
        while (i < children.length) {
            IJavaElement element = children[i];
            String name = element.getElementName();
            if (name.startsWith(prefix) && name.length() > prefixLen && name.indexOf(46, prefixLen) == -1) {
                if (found == null) {
                    found = (IPackageFragment)element;
                } else {
                    return null;
                }
            }
            ++i;
        }
        return found;
    }

    private boolean processDelta(IJavaElementDelta delta, Collection<Runnable> runnables) throws JavaModelException {
        Object parent;
        IJavaProject proj;
        int kind = delta.getKind();
        int flags = delta.getFlags();
        IJavaElement element = delta.getElement();
        int elementType = element.getElementType();
        if (!(elementType == 1 || elementType == 2 || (proj = element.getJavaProject()) != null && proj.getProject().isOpen())) {
            return false;
        }
        if (elementType == 4) {
            if ((flags & 9) == 1) {
                if (!this.fIsFlatLayout && !((parent = this.getHierarchicalPackageParent((IPackageFragment)element)) instanceof IPackageFragmentRoot)) {
                    this.postRefresh(this.internalGetParent(parent), 2, element, runnables);
                    return true;
                }
                this.postRefresh(this.internalGetParent(element), 1, element, runnables);
                return true;
            }
            if (!this.fIsFlatLayout) {
                if (kind == 2) {
                    parent = this.getHierarchicalPackageParent((IPackageFragment)element);
                    if (parent instanceof IPackageFragmentRoot) {
                        this.postRemove(element, runnables);
                        return false;
                    }
                    this.postRefresh(this.internalGetParent(parent), 2, element, runnables);
                    return true;
                }
                if (kind == 1) {
                    parent = this.getHierarchicalPackageParent((IPackageFragment)element);
                    if (parent instanceof IPackageFragmentRoot) {
                        if (this.fFoldPackages) {
                            this.postRefresh(parent, 1, element, runnables);
                            return true;
                        }
                        this.postAdd(parent, element, runnables);
                        return false;
                    }
                    this.postRefresh(this.internalGetParent(parent), 2, element, runnables);
                    return true;
                }
                this.handleAffectedChildren(delta, element, runnables);
                return false;
            }
        }
        if (elementType == 5) {
            ICompilationUnit cu = (ICompilationUnit)element;
            if (!JavaModelUtil.isPrimary(cu)) {
                return false;
            }
            if (!this.getProvideMembers() && cu.isWorkingCopy() && kind == 4) {
                return false;
            }
            if (kind == 4 && !PackageExplorerContentProvider.isStructuralCUChange(flags)) {
                return false;
            }
            if (!this.isOnClassPath(cu)) {
                return false;
            }
        }
        if (elementType == 2) {
            if ((flags & 0x600) != 0) {
                this.postRefresh(element, 0, element, runnables);
                return false;
            }
            if ((flags & 0x200000) != 0) {
                this.postRefresh(element, 0, element, runnables);
                return false;
            }
            if (kind == 1) {
                this.postRemove(element.getResource(), runnables);
                this.postAdd(element.getParent(), element, runnables);
                return false;
            }
        }
        if (kind == 2) {
            IResource resource;
            parent = this.internalGetParent(element);
            if (element instanceof IPackageFragment) {
                if (this.fViewer.testFindItem(parent) != null) {
                    this.postRefresh(parent, 1, element, runnables);
                }
                return true;
            }
            if (element instanceof IPackageFragmentRoot && (resource = element.getResource()) != null && !resource.exists()) {
                this.postRemove(resource, runnables);
            }
            this.postRemove(element, runnables);
            if (parent instanceof IPackageFragment) {
                this.postUpdateIcon((IJavaElement)((IPackageFragment)parent), runnables);
            }
            if (this.isPackageFragmentEmpty(element.getParent())) {
                if (this.fViewer.testFindItem(parent) != null) {
                    this.postRefresh(this.internalGetParent(parent), 2, element, runnables);
                }
                return true;
            }
            return false;
        }
        if (kind == 1) {
            Object resourceParent;
            IResource resource;
            parent = this.internalGetParent(element);
            if (parent instanceof IPackageFragment) {
                Object grandparent = this.internalGetParent(parent);
                if (parent.equals(this.fInput)) {
                    this.postRefresh(parent, 1, element, runnables);
                } else if (this.fViewer.testFindItem(parent) == null) {
                    this.postRefresh(grandparent, 2, element, runnables);
                } else {
                    this.postRefresh(parent, 1, element, runnables);
                }
                return true;
            }
            if (element instanceof IPackageFragmentRoot && ((IPackageFragmentRoot)element).getKind() != 1 && (resource = element.getResource()) != null && (resourceParent = super.internalGetParent(resource)) != null) {
                IJavaProject proj2 = element.getJavaProject();
                if (this.fShowLibrariesNode || !resourceParent.equals(proj2)) {
                    this.postAdd(resourceParent, resource, runnables);
                }
            }
            this.postAdd(parent, element, runnables);
        }
        if (elementType == 5 || elementType == 6) {
            if (kind == 4) {
                this.postRefresh(element, 0, element, runnables);
            }
            return false;
        }
        if (elementType == 3) {
            if ((flags & 0x8000) != 0) {
                this.postRefresh(element, 0, element, runnables);
                return false;
            }
            if ((flags & 9) == 1) {
                this.postRefresh(this.internalGetParent(element), 1, element, runnables);
                return true;
            }
            if ((flags & 0x3000) != 0) {
                this.postUpdateIcon(element, runnables);
            }
            if (this.isClassPathChange(delta)) {
                this.postRefresh(element.getJavaProject(), 4, element, runnables);
                return true;
            }
        }
        this.handleAffectedChildren(delta, element, runnables);
        return false;
    }

    private static boolean isStructuralCUChange(int flags) {
        return (flags & 8) != 0 || (flags & 0x4001) == 1;
    }

    void handleAffectedChildren(IJavaElementDelta delta, IJavaElement element, Collection<Runnable> runnables) throws JavaModelException {
        int count = 0;
        IResourceDelta[] resourceDeltas = delta.getResourceDeltas();
        if (resourceDeltas != null) {
            int i = 0;
            while (i < resourceDeltas.length) {
                int kind = resourceDeltas[i].getKind();
                if (kind == 1 || kind == 2) {
                    ++count;
                }
                ++i;
            }
        }
        IJavaElementDelta[] affectedChildren = delta.getAffectedChildren();
        int i = 0;
        while (i < affectedChildren.length) {
            int kind = affectedChildren[i].getKind();
            if (kind == 1 || kind == 2) {
                ++count;
            }
            ++i;
        }
        if (count > 1) {
            if (element instanceof IPackageFragment) {
                IJavaElement parent = (IJavaElement)this.internalGetParent(element);
                if (element.equals(this.fInput)) {
                    this.postRefresh(element, 0, element, runnables);
                } else {
                    this.postRefresh(parent, 1, element, runnables);
                }
            } else if (element instanceof IPackageFragmentRoot) {
                Object toRefresh = this.internalGetParent(element);
                this.postRefresh(toRefresh, 0, toRefresh, runnables);
            } else {
                this.postRefresh(element, 0, element, runnables);
            }
            return;
        }
        if (resourceDeltas != null) {
            i = 0;
            while (i < resourceDeltas.length) {
                if (this.processResourceDelta(resourceDeltas[i], element, runnables)) {
                    return;
                }
                ++i;
            }
        }
        i = 0;
        while (i < affectedChildren.length) {
            if (this.processDelta(affectedChildren[i], runnables)) {
                return;
            }
            ++i;
        }
    }

    protected void processAffectedChildren(IJavaElementDelta[] affectedChildren, Collection<Runnable> runnables) throws JavaModelException {
        int i = 0;
        while (i < affectedChildren.length) {
            this.processDelta(affectedChildren[i], runnables);
            ++i;
        }
    }

    private boolean isOnClassPath(ICompilationUnit element) {
        IJavaProject project = element.getJavaProject();
        if (project == null || !project.exists()) {
            return false;
        }
        return project.isOnClasspath((IJavaElement)element);
    }

    private void postUpdateIcon(final IJavaElement element, Collection<Runnable> runnables) {
        runnables.add(new Runnable(){

            public void run() {
                PackageExplorerContentProvider.this.fViewer.update((Object)element, new String[]{"org.eclipse.jface.image"});
            }
        });
    }

    private boolean processResourceDelta(IResourceDelta delta, Object parent, Collection<Runnable> runnables) {
        int status = delta.getKind();
        int flags = delta.getFlags();
        IResource resource = delta.getResource();
        if (resource == null) {
            return false;
        }
        if ((status & 2) != 0) {
            if (parent instanceof IPackageFragment) {
                this.postRefresh(this.internalGetParent(parent), 1, parent, runnables);
                return true;
            }
            this.postRemove(resource, runnables);
            return false;
        }
        if ((status & 1) != 0) {
            if (parent instanceof IPackageFragment) {
                this.postRefresh(this.internalGetParent(parent), 1, parent, runnables);
                return true;
            }
            this.postAdd(parent, resource, runnables);
            return false;
        }
        if ((status & 4) != 0 && (flags & 0x8000) != 0) {
            this.postRefresh(parent, 1, resource, runnables);
            return true;
        }
        if ((flags & 0x4000) != 0) {
            this.postProjectStateChanged(this.internalGetParent(parent), runnables);
            return true;
        }
        IResourceDelta[] resourceDeltas = delta.getAffectedChildren();
        int count = 0;
        int i = 0;
        while (i < resourceDeltas.length) {
            int kind = resourceDeltas[i].getKind();
            if ((kind == 1 || kind == 2) && ++count > 1) {
                this.postRefresh(parent, 1, resource, runnables);
                return true;
            }
            ++i;
        }
        i = 0;
        while (i < resourceDeltas.length) {
            if (this.processResourceDelta(resourceDeltas[i], resource, runnables)) {
                return false;
            }
            ++i;
        }
        return false;
    }

    public void setIsFlatLayout(boolean state) {
        this.fIsFlatLayout = state;
    }

    public void setShowLibrariesNode(boolean state) {
        this.fShowLibrariesNode = state;
    }

    private void postRefresh(Object root, int relation, Object affectedElement, Collection<Runnable> runnables) {
        if (this.isParent(root, this.fInput) || root instanceof IJavaModel) {
            root = this.fInput;
        }
        ArrayList<Object> toRefresh = new ArrayList<Object>(1);
        toRefresh.add(root);
        this.augmentElementToRefresh(toRefresh, relation, affectedElement);
        this.postRefresh(toRefresh, true, runnables);
    }

    protected void augmentElementToRefresh(List<Object> toRefresh, int relation, Object affectedElement) {
    }

    private boolean isParent(Object root, Object child) {
        Object parent = this.getParent(child);
        if (parent == null) {
            return false;
        }
        if (parent.equals(root)) {
            return true;
        }
        return this.isParent(root, parent);
    }

    protected void postRefresh(final List<Object> toRefresh, final boolean updateLabels, Collection<Runnable> runnables) {
        runnables.add(new Runnable(){

            public void run() {
                Object[] elements = toRefresh.toArray();
                int i = 0;
                while (i < elements.length) {
                    Object element = elements[i];
                    if (element == null || PackageExplorerContentProvider.this.fViewer.testFindItems(element).length > 0) {
                        PackageExplorerContentProvider.this.fViewer.refresh(element, updateLabels);
                    }
                    ++i;
                }
            }
        });
    }

    protected void postAdd(final Object parent, final Object element, Collection<Runnable> runnables) {
        runnables.add(new Runnable(){

            public void run() {
                Widget[] items = PackageExplorerContentProvider.this.fViewer.testFindItems(element);
                int i = 0;
                while (i < items.length) {
                    TreeItem parentItem;
                    Widget item = items[i];
                    if (item instanceof TreeItem && !item.isDisposed() && (parentItem = ((TreeItem)item).getParentItem()) != null && !parentItem.isDisposed() && parent.equals(parentItem.getData())) {
                        return;
                    }
                    ++i;
                }
                PackageExplorerContentProvider.this.fViewer.add(parent, element);
            }
        });
    }

    protected void postRemove(final Object element, Collection<Runnable> runnables) {
        runnables.add(new Runnable(){

            public void run() {
                if (PackageExplorerContentProvider.this.fViewer.testFindItems(element).length > 0) {
                    PackageExplorerContentProvider.this.fViewer.remove(element);
                }
            }
        });
    }

    protected void postProjectStateChanged(final Object root, Collection<Runnable> runnables) {
        runnables.add(new Runnable(){

            public void run() {
                PackageExplorerContentProvider.this.fViewer.refresh(root, true);
                PackageExplorerContentProvider.this.fViewer.setSelection(PackageExplorerContentProvider.this.fViewer.getSelection());
            }
        });
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (this.arePackagesFoldedInHierarchicalLayout() != this.fFoldPackages) {
            this.fFoldPackages = this.arePackagesFoldedInHierarchicalLayout();
            if (this.fViewer != null && !this.fViewer.getControl().isDisposed()) {
                this.fViewer.getControl().setRedraw(false);
                Object[] expandedObjects = this.fViewer.getExpandedElements();
                this.fViewer.refresh();
                this.fViewer.setExpandedElements(expandedObjects);
                this.fViewer.getControl().setRedraw(true);
            }
        }
    }
}

