/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.core;

import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.internal.wikitext.core.Messages;
import org.eclipse.mylyn.internal.wikitext.core.util.EclipseServiceLocator;
import org.eclipse.mylyn.internal.wikitext.core.validation.ValidationRules;
import org.eclipse.mylyn.wikitext.core.parser.markup.MarkupLanguage;
import org.eclipse.mylyn.wikitext.core.util.ServiceLocator;
import org.eclipse.mylyn.wikitext.core.validation.MarkupValidator;
import org.eclipse.mylyn.wikitext.core.validation.ValidationRule;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WikiTextPlugin
extends Plugin {
    private static final String EXTENSION_MARKUP_LANGUAGE = "markupLanguage";
    private static final String EXTENSION_VALIDATION_RULES = "markupValidationRule";
    private static WikiTextPlugin plugin;
    private SortedMap<String, Class<? extends MarkupLanguage>> languageByName;
    private Map<String, Class<? extends MarkupLanguage>> languageByFileExtension;
    private Map<Class<? extends MarkupLanguage>, String> languageNameByLanguage;
    private Map<String, String> languageExtensionByLanguage;
    private Map<String, ValidationRules> validationRulesByLanguageName;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        ServiceLocator.setImplementation(EclipseServiceLocator.class);
        plugin = this;
    }

    public void stop(BundleContext context) throws Exception {
        if (plugin == this) {
            plugin = null;
        }
        super.stop(context);
    }

    public static WikiTextPlugin getDefault() {
        return plugin;
    }

    public MarkupLanguage getMarkupLanguage(String name) {
        Class<? extends MarkupLanguage> languageClass;
        if (this.languageByName == null) {
            this.initializeMarkupLanguages();
        }
        if ((languageClass = (Class<? extends MarkupLanguage>)this.languageByName.get(name)) == null) {
            for (Class<? extends MarkupLanguage> clazz : this.languageByName.values()) {
                if (!clazz.getName().equals(name)) continue;
                languageClass = clazz;
                break;
            }
        }
        if (languageClass != null) {
            return this.instantiateMarkupLanguage(name, languageClass);
        }
        return null;
    }

    private MarkupLanguage instantiateMarkupLanguage(String name, Class<? extends MarkupLanguage> languageClass) {
        try {
            MarkupLanguage language = languageClass.newInstance();
            language.setName(name);
            language.setExtendsLanguage(this.languageExtensionByLanguage.get(name));
            return language;
        }
        catch (Exception e) {
            this.log(4, MessageFormat.format(Messages.getString("WikiTextPlugin.2"), name, languageClass.getName(), e.getMessage()), e);
            return null;
        }
    }

    public String getMarkupLanguageNameForFilename(String name) {
        int lastIndexOfDot;
        String extension;
        Class<? extends MarkupLanguage> languageClass;
        if (this.languageByFileExtension == null) {
            this.initializeMarkupLanguages();
        }
        if ((languageClass = this.languageByFileExtension.get(extension = (lastIndexOfDot = name.lastIndexOf(46)) == -1 ? name : name.substring(lastIndexOfDot + 1))) != null) {
            return this.languageNameByLanguage.get(languageClass);
        }
        return null;
    }

    public Set<String> getMarkupFileExtensions() {
        if (this.languageByFileExtension == null) {
            this.initializeMarkupLanguages();
        }
        return Collections.unmodifiableSet(this.languageByFileExtension.keySet());
    }

    public MarkupLanguage getMarkupLanguageForFilename(String name) {
        int lastIndexOfDot;
        String extension;
        Class<? extends MarkupLanguage> languageClass;
        if (this.languageByFileExtension == null) {
            this.initializeMarkupLanguages();
        }
        if ((languageClass = this.languageByFileExtension.get(extension = (lastIndexOfDot = name.lastIndexOf(46)) == -1 ? name : name.substring(lastIndexOfDot + 1))) != null) {
            String languageName = null;
            for (Map.Entry<String, Class<? extends MarkupLanguage>> ent : this.languageByName.entrySet()) {
                if (ent.getValue() != languageClass) continue;
                languageName = ent.getKey();
                break;
            }
            return this.instantiateMarkupLanguage(languageName, languageClass);
        }
        return null;
    }

    public Set<String> getMarkupLanguageNames() {
        if (this.languageByName == null) {
            this.initializeMarkupLanguages();
        }
        return this.languageByName.keySet();
    }

    public MarkupValidator getMarkupValidator(String name) {
        ValidationRules rules;
        MarkupValidator markupValidator = new MarkupValidator();
        if (this.validationRulesByLanguageName == null) {
            this.initializeValidationRules();
        }
        if ((rules = this.validationRulesByLanguageName.get(name)) != null) {
            markupValidator.getRules().addAll(rules.getRules());
        }
        return markupValidator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeValidationRules() {
        this.initializeMarkupLanguages();
        WikiTextPlugin wikiTextPlugin = this;
        synchronized (wikiTextPlugin) {
            if (this.validationRulesByLanguageName == null) {
                HashMap<String, ValidationRules> validationRulesByLanguageName = new HashMap<String, ValidationRules>();
                IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(this.getPluginId(), EXTENSION_VALIDATION_RULES);
                if (extensionPoint != null) {
                    IConfigurationElement[] configurationElements;
                    IConfigurationElement[] iConfigurationElementArray = configurationElements = extensionPoint.getConfigurationElements();
                    int n = configurationElements.length;
                    int n2 = 0;
                    while (n2 < n) {
                        block16: {
                            IConfigurationElement element = iConfigurationElementArray[n2];
                            try {
                                Object extension;
                                String markupLanguage = element.getAttribute(EXTENSION_MARKUP_LANGUAGE);
                                if (markupLanguage == null || markupLanguage.length() == 0) {
                                    throw new Exception(Messages.getString("WikiTextPlugin.4"));
                                }
                                if (!this.languageByName.containsKey(markupLanguage)) {
                                    throw new Exception(MessageFormat.format(Messages.getString("WikiTextPlugin.5"), this.languageByName));
                                }
                                try {
                                    extension = element.createExecutableExtension("class");
                                }
                                catch (CoreException e) {
                                    this.getLog().log(e.getStatus());
                                    break block16;
                                }
                                if (!(extension instanceof ValidationRule)) {
                                    throw new Exception(MessageFormat.format(Messages.getString("WikiTextPlugin.7"), extension.getClass().getName()));
                                }
                                ValidationRules rules = (ValidationRules)validationRulesByLanguageName.get(markupLanguage);
                                if (rules == null) {
                                    rules = new ValidationRules();
                                    validationRulesByLanguageName.put(markupLanguage, rules);
                                }
                                rules.addValidationRule((ValidationRule)extension);
                            }
                            catch (Exception e) {
                                this.log(4, MessageFormat.format(Messages.getString("WikiTextPlugin.8"), element.getDeclaringExtension().getContributor().getName(), EXTENSION_VALIDATION_RULES, e.getMessage()), e);
                            }
                        }
                        ++n2;
                    }
                }
                Set<String> languageNames = WikiTextPlugin.getDefault().getMarkupLanguageNames();
                for (String languageName : languageNames) {
                    ValidationRules rules = (ValidationRules)validationRulesByLanguageName.get(languageName);
                    if (rules != null) continue;
                    rules = new ValidationRules();
                    validationRulesByLanguageName.put(languageName, rules);
                }
                for (String languageName : languageNames) {
                    MarkupLanguage markupLanguage = WikiTextPlugin.getDefault().getMarkupLanguage(languageName);
                    if (markupLanguage == null || markupLanguage.getExtendsLanguage() == null) continue;
                    ValidationRules languageRules = (ValidationRules)validationRulesByLanguageName.get(languageName);
                    ValidationRules parentLanguageRules = (ValidationRules)validationRulesByLanguageName.get(markupLanguage.getExtendsLanguage());
                    languageRules.setParent(parentLanguageRules);
                }
                this.validationRulesByLanguageName = validationRulesByLanguageName;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeMarkupLanguages() {
        WikiTextPlugin wikiTextPlugin = this;
        synchronized (wikiTextPlugin) {
            if (this.languageByName == null) {
                TreeMap<String, Class<? extends MarkupLanguage>> markupLanguageByName = new TreeMap<String, Class<? extends MarkupLanguage>>();
                HashMap<String, Class<? extends MarkupLanguage>> languageByFileExtension = new HashMap<String, Class<? extends MarkupLanguage>>();
                HashMap<String, String> languageExtensionByLanguage = new HashMap<String, String>();
                HashMap<Class<? extends MarkupLanguage>, String> languageNameByLanguage = new HashMap<Class<? extends MarkupLanguage>, String>();
                IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(this.getPluginId(), EXTENSION_MARKUP_LANGUAGE);
                if (extensionPoint != null) {
                    IConfigurationElement[] configurationElements;
                    IConfigurationElement[] iConfigurationElementArray = configurationElements = extensionPoint.getConfigurationElements();
                    int n = configurationElements.length;
                    int n2 = 0;
                    while (n2 < n) {
                        block18: {
                            IConfigurationElement element = iConfigurationElementArray[n2];
                            String name = element.getAttribute("name");
                            if (name == null || name.length() == 0) {
                                this.log(4, MessageFormat.format(EXTENSION_MARKUP_LANGUAGE + Messages.getString("WikiTextPlugin.10"), element.getDeclaringExtension().getContributor().getName()));
                            } else {
                                Object markupLanguage;
                                String extendsLanguage = element.getAttribute("extends");
                                try {
                                    markupLanguage = element.createExecutableExtension("class");
                                }
                                catch (CoreException e) {
                                    this.getLog().log(e.getStatus());
                                    break block18;
                                }
                                if (!(markupLanguage instanceof MarkupLanguage)) {
                                    this.log(4, MessageFormat.format(Messages.getString("WikiTextPlugin.13"), markupLanguage.getClass().getName()));
                                } else {
                                    MarkupLanguage d = (MarkupLanguage)markupLanguage;
                                    Class<?> previous = markupLanguageByName.put(name, d.getClass());
                                    if (previous != null) {
                                        this.log(4, MessageFormat.format(EXTENSION_MARKUP_LANGUAGE + Messages.getString("WikiTextPlugin.14"), name, element.getDeclaringExtension().getContributor().getName(), name));
                                        markupLanguageByName.put(name, previous);
                                    } else {
                                        String fileExtensions;
                                        languageNameByLanguage.put(d.getClass(), name);
                                        if (extendsLanguage != null) {
                                            languageExtensionByLanguage.put(name, extendsLanguage);
                                        }
                                        if ((fileExtensions = element.getAttribute("fileExtensions")) != null) {
                                            String[] parts;
                                            String[] stringArray = parts = fileExtensions.split("\\s*,\\s*");
                                            int n3 = parts.length;
                                            int n4 = 0;
                                            while (n4 < n3) {
                                                Class<?> previous2;
                                                String part = stringArray[n4];
                                                if (part.length() != 0 && (previous2 = languageByFileExtension.put(part, d.getClass())) != null) {
                                                    this.log(4, MessageFormat.format(EXTENSION_MARKUP_LANGUAGE + Messages.getString("WikiTextPlugin.17"), part, element.getDeclaringExtension().getContributor().getName(), part));
                                                    languageByFileExtension.put(part, previous2);
                                                }
                                                ++n4;
                                            }
                                        }
                                    }
                                }
                            }
                        }
                        ++n2;
                    }
                }
                this.languageByFileExtension = languageByFileExtension;
                this.languageByName = markupLanguageByName;
                this.languageExtensionByLanguage = languageExtensionByLanguage;
                this.languageNameByLanguage = languageNameByLanguage;
            }
        }
    }

    public void log(int severity, String message) {
        this.log(severity, message, null);
    }

    public void log(int severity, String message, Throwable t) {
        this.getLog().log((IStatus)new Status(severity, this.getPluginId(), message, t));
    }

    public String getPluginId() {
        return this.getBundle().getSymbolicName();
    }
}

