/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.core.util.css;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.mylyn.internal.wikitext.core.util.css.AnySelector;
import org.eclipse.mylyn.internal.wikitext.core.util.css.Block;
import org.eclipse.mylyn.internal.wikitext.core.util.css.CompositeSelector;
import org.eclipse.mylyn.internal.wikitext.core.util.css.CssClassSelector;
import org.eclipse.mylyn.internal.wikitext.core.util.css.CssRule;
import org.eclipse.mylyn.internal.wikitext.core.util.css.DescendantSelector;
import org.eclipse.mylyn.internal.wikitext.core.util.css.IdSelector;
import org.eclipse.mylyn.internal.wikitext.core.util.css.NameSelector;
import org.eclipse.mylyn.internal.wikitext.core.util.css.Selector;
import org.eclipse.mylyn.internal.wikitext.core.util.css.SparseCharSequence;
import org.eclipse.mylyn.internal.wikitext.core.util.css.Stylesheet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CssParser {
    private static final Pattern CSS_COMMENT_PATTERN = Pattern.compile("/\\*.*?(\\*/|\\z)", 40);
    private static Pattern CSS_BLOCK_PATTERN = Pattern.compile("(?:$|^)([^{]+)\\{([^\\}]*)\\}", 40);
    static final Pattern CSS_RULE_PATTERN = Pattern.compile("(?:^|\\s?)([\\w-]+)\\s*:\\s*([^;]+)(;|$)", 40);
    private static final String elemNamePatternPart = "(\\*|[a-zA-Z][a-zA-Z0-9]*)";
    private static final String elemQualifierPatternPart = "(?:(\\.|\\#)([a-zA-Z0-9]+))";
    private static final String elemPseudoClassPatternPart = "(?:\\:([a-zA-Z]+))";
    private static final String fullElementPatternPart = "(?:(?:(\\*|[a-zA-Z][a-zA-Z0-9]*)|(?:(\\.|\\#)([a-zA-Z0-9]+))|(?:\\:([a-zA-Z]+))){1,3})";
    private static Pattern CSS_SELECTOR_PATTERN = Pattern.compile("(?:(?:(\\*|[a-zA-Z][a-zA-Z0-9]*)|(?:(\\.|\\#)([a-zA-Z0-9]+))|(?:\\:([a-zA-Z]+))){1,3})(?:\\s*?(\\s|\\>|\\+)\\s*(?:(?:(\\*|[a-zA-Z][a-zA-Z0-9]*)|(?:(\\.|\\#)([a-zA-Z0-9]+))|(?:\\:([a-zA-Z]+))){1,3}))?");

    public List<CssRule> parseBlockContent(String content) {
        return this.parseBlock(content, 0);
    }

    public Iterator<CssRule> createRuleIterator(String content) {
        return this.createRuleIterator(content, 0);
    }

    public Stylesheet parse(Reader reader) {
        try {
            int i;
            reader = new BufferedReader(reader);
            StringWriter writer = new StringWriter();
            while ((i = reader.read()) != -1) {
                writer.write(i);
            }
            return this.parse(writer.toString());
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public Stylesheet parse(String cssContent) {
        Stylesheet stylesheet = new Stylesheet();
        SparseCharSequence charSequence = new SparseCharSequence(cssContent, CSS_COMMENT_PATTERN);
        Matcher matcher = CSS_BLOCK_PATTERN.matcher(charSequence);
        while (matcher.find()) {
            Selector selector;
            String selectorText = matcher.group(1);
            String blockContent = matcher.group(2);
            if (selectorText == null || blockContent == null || (selector = this.parseSelector(selectorText)) == null) continue;
            int offset = matcher.start(2);
            offset = charSequence.originalOffsetOf(offset);
            List<CssRule> rules = this.parseBlock(blockContent, offset);
            Block block = new Block(selector, rules);
            stylesheet.add(block);
        }
        return stylesheet;
    }

    private List<CssRule> parseBlock(String content, int blockOffset) {
        ArrayList<CssRule> rules = new ArrayList<CssRule>();
        Iterator<CssRule> it = this.createRuleIterator(content, blockOffset);
        while (it.hasNext()) {
            rules.add(it.next());
        }
        return rules;
    }

    private Iterator<CssRule> createRuleIterator(String content, int blockOffset) {
        return new CssRuleIterator(content, blockOffset);
    }

    public Selector parseSelector(String selectorText) {
        String[] cssSelectorParts = selectorText.split(",");
        ArrayList<Selector> parts = new ArrayList<Selector>();
        String[] stringArray = cssSelectorParts;
        int n = cssSelectorParts.length;
        int n2 = 0;
        while (n2 < n) {
            String part = stringArray[n2];
            Selector selector = this.parseSelectorPart(part);
            if (selector != null) {
                parts.add(selector);
            }
            ++n2;
        }
        if (parts.isEmpty()) {
            return null;
        }
        if (parts.size() == 1) {
            return (Selector)parts.get(0);
        }
        return new CompositeSelector(false, parts);
    }

    private Selector parseSelectorPart(String part) {
        ArrayList<Selector> parts = new ArrayList<Selector>();
        Matcher matcher = CSS_SELECTOR_PATTERN.matcher(part);
        while (matcher.find()) {
            String elemSelector = matcher.group(1);
            String elemSelectorQualifierType = matcher.group(2);
            String elemSelectorQualifier = matcher.group(3);
            String elemSelectorPseudoClass = matcher.group(4);
            String join = matcher.group(5);
            String elemSelector2 = matcher.group(6);
            String elemSelector2QualifierType = matcher.group(7);
            String elemSelector2Qualifier = matcher.group(8);
            String elemSelector2PseudoClass = matcher.group(9);
            if (elemSelectorPseudoClass != null || elemSelector2PseudoClass != null) continue;
            Selector firstElementSelector = this.buildElementSelector(elemSelector, elemSelectorQualifierType, elemSelectorQualifier, elemSelectorPseudoClass);
            if (join != null && elemSelector2 != null) {
                if (join.trim().length() != 0) continue;
                parts.add(new DescendantSelector(firstElementSelector));
                parts.add(this.buildElementSelector(elemSelector2, elemSelector2QualifierType, elemSelector2Qualifier, elemSelector2PseudoClass));
                continue;
            }
            parts.add(firstElementSelector);
        }
        if (parts.isEmpty()) {
            return null;
        }
        if (parts.size() == 1) {
            return (Selector)parts.get(0);
        }
        return new CompositeSelector(true, parts);
    }

    private Selector buildElementSelector(String elemSelector, String elemSelectorQualifierType, String elemSelectorQualifier, String elemSelectorPseudoClass) {
        ArrayList<Selector> parts = new ArrayList<Selector>();
        if (elemSelector != null) {
            if ("*".equals(elemSelector)) {
                parts.add(new AnySelector());
            } else {
                parts.add(new NameSelector(elemSelector));
            }
        }
        if (elemSelectorQualifierType != null && elemSelectorQualifier != null) {
            if (".".equals(elemSelectorQualifierType)) {
                parts.add(new CssClassSelector(elemSelectorQualifier));
            } else if ("#".equals(elemSelectorQualifierType)) {
                parts.add(new IdSelector(elemSelectorQualifier));
            }
        }
        return parts.size() == 1 ? (Selector)parts.get(0) : new CompositeSelector(true, parts);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CssRuleIterator
    implements Iterator<CssRule> {
        private final Matcher matcher;
        private boolean hasNext;
        private final int blockOffset;

        public CssRuleIterator(String cssStyles, int blockOffset) {
            this.blockOffset = blockOffset;
            this.matcher = CSS_RULE_PATTERN.matcher(cssStyles);
            this.hasNext = this.matcher.find();
        }

        @Override
        public boolean hasNext() {
            return this.hasNext;
        }

        @Override
        public CssRule next() {
            if (!this.hasNext) {
                throw new NoSuchElementException();
            }
            int offset = this.matcher.start();
            int length = this.matcher.end() - offset;
            String ruleName = this.matcher.group(1);
            int nameOffset = this.matcher.start(1);
            String ruleValue = this.matcher.group(2).trim();
            int valueOffset = this.matcher.start(2);
            this.hasNext = this.matcher.find();
            return new CssRule(ruleName, ruleValue, offset + this.blockOffset, length, nameOffset + this.blockOffset, valueOffset + this.blockOffset);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

