/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.browser;

import java.net.URL;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.internal.browser.InternalBrowserInstance;
import org.eclipse.ui.internal.browser.Trace;
import org.eclipse.ui.internal.browser.WebBrowserUIPlugin;
import org.eclipse.ui.internal.browser.WebBrowserUtil;
import org.eclipse.ui.internal.browser.WebBrowserView;

public class InternalBrowserViewInstance
extends InternalBrowserInstance {
    public InternalBrowserViewInstance(String id, int style, String name, String tooltip) {
        super(WebBrowserUtil.encodeStyle(id, style), style, name, tooltip);
    }

    public void openURL(URL url) throws PartInitException {
        IWorkbenchWindow workbenchWindow = WebBrowserUIPlugin.getInstance().getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage page = workbenchWindow.getActivePage();
        WebBrowserView view = (WebBrowserView)this.part;
        if (view == null) {
            try {
                view = (WebBrowserView)page.showView("org.eclipse.ui.browser.view", this.getId(), 3);
                if (this.tooltip != null && this.tooltip.length() > 0) {
                    view.setBrowserViewTooltip(this.tooltip);
                }
                if (this.name != null && this.name.length() > 0) {
                    view.setBrowserViewName(this.name);
                }
                this.hookPart(page, (IWorkbenchPart)view);
            }
            catch (Exception e) {
                Trace.trace(Trace.SEVERE, "Error opening Web browser", e);
            }
        }
        if (view != null) {
            page.bringToTop((IWorkbenchPart)view);
            view.setURL(url.toExternalForm());
        }
    }

    public boolean close() {
        return ((WebBrowserView)this.part).close();
    }
}

