/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.core.refactoring;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.ltk.core.refactoring.IRefactoringStatusEntryComparator;
import org.eclipse.ltk.core.refactoring.RefactoringStatusContext;
import org.eclipse.ltk.core.refactoring.RefactoringStatusEntry;

public class RefactoringStatus {
    public static final int OK = 0;
    public static final int INFO = 1;
    public static final int WARNING = 2;
    public static final int ERROR = 3;
    public static final int FATAL = 4;
    private List fEntries = new ArrayList(0);
    private int fSeverity = 0;

    public int getSeverity() {
        return this.fSeverity;
    }

    public RefactoringStatusEntry[] getEntries() {
        return this.fEntries.toArray(new RefactoringStatusEntry[this.fEntries.size()]);
    }

    public RefactoringStatusEntry[] getEntries(IRefactoringStatusEntryComparator comparator, RefactoringStatusEntry entry) {
        ArrayList<RefactoringStatusEntry> matches = new ArrayList<RefactoringStatusEntry>(this.fEntries.size());
        RefactoringStatusEntry current = null;
        Iterator iterator = this.fEntries.iterator();
        while (iterator.hasNext()) {
            current = (RefactoringStatusEntry)iterator.next();
            if (comparator.compare(current, entry) != 0) continue;
            matches.add(current);
        }
        return matches.toArray(new RefactoringStatusEntry[matches.size()]);
    }

    public boolean hasEntries() {
        return !this.fEntries.isEmpty();
    }

    public RefactoringStatusEntry getEntryAt(int index) {
        return (RefactoringStatusEntry)this.fEntries.get(index);
    }

    public RefactoringStatusEntry getEntryMatchingCode(String pluginId, int code) {
        Assert.isTrue((pluginId != null ? 1 : 0) != 0);
        Iterator iter = this.fEntries.iterator();
        while (iter.hasNext()) {
            RefactoringStatusEntry entry = (RefactoringStatusEntry)iter.next();
            if (!pluginId.equals(entry.getPluginId()) || entry.getCode() != code) continue;
            return entry;
        }
        return null;
    }

    public RefactoringStatusEntry getEntryMatchingSeverity(int severity) {
        Assert.isTrue((severity >= 0 && severity <= 4 ? 1 : 0) != 0);
        if (severity > this.fSeverity) {
            return null;
        }
        Iterator iter = this.fEntries.iterator();
        while (iter.hasNext()) {
            RefactoringStatusEntry entry = (RefactoringStatusEntry)iter.next();
            if (entry.getSeverity() < severity) continue;
            return entry;
        }
        return null;
    }

    public RefactoringStatusEntry getEntryWithHighestSeverity() {
        if (this.fEntries == null || this.fEntries.size() == 0) {
            return null;
        }
        RefactoringStatusEntry result = (RefactoringStatusEntry)this.fEntries.get(0);
        int i = 1;
        while (i < this.fEntries.size()) {
            RefactoringStatusEntry entry = (RefactoringStatusEntry)this.fEntries.get(i);
            if (result.getSeverity() < entry.getSeverity()) {
                result = entry;
            }
            ++i;
        }
        return result;
    }

    public String getMessageMatchingSeverity(int severity) {
        RefactoringStatusEntry entry = this.getEntryMatchingSeverity(severity);
        if (entry == null) {
            return null;
        }
        return entry.getMessage();
    }

    public static RefactoringStatus createStatus(int severity, String msg, RefactoringStatusContext context, String pluginId, int code, Object data) {
        RefactoringStatus result = new RefactoringStatus();
        result.fEntries.add(new RefactoringStatusEntry(severity, msg, context, pluginId, code, data));
        result.fSeverity = severity;
        return result;
    }

    public static RefactoringStatus createInfoStatus(String msg) {
        return RefactoringStatus.createStatus(1, msg, null, null, -1, null);
    }

    public static RefactoringStatus createInfoStatus(String msg, RefactoringStatusContext context) {
        return RefactoringStatus.createStatus(1, msg, context, null, -1, null);
    }

    public static RefactoringStatus createWarningStatus(String msg) {
        return RefactoringStatus.createStatus(2, msg, null, null, -1, null);
    }

    public static RefactoringStatus createWarningStatus(String msg, RefactoringStatusContext context) {
        return RefactoringStatus.createStatus(2, msg, context, null, -1, null);
    }

    public static RefactoringStatus createErrorStatus(String msg) {
        return RefactoringStatus.createStatus(3, msg, null, null, -1, null);
    }

    public static RefactoringStatus createErrorStatus(String msg, RefactoringStatusContext context) {
        return RefactoringStatus.createStatus(3, msg, context, null, -1, null);
    }

    public static RefactoringStatus createFatalErrorStatus(String msg) {
        return RefactoringStatus.createStatus(4, msg, null, null, -1, null);
    }

    public static RefactoringStatus createFatalErrorStatus(String msg, RefactoringStatusContext context) {
        return RefactoringStatus.createStatus(4, msg, context, null, -1, null);
    }

    public static RefactoringStatus create(IStatus status) {
        if (status.isOK()) {
            return new RefactoringStatus();
        }
        if (!status.isMultiStatus()) {
            switch (status.getSeverity()) {
                case 0: {
                    return new RefactoringStatus();
                }
                case 1: {
                    return RefactoringStatus.createWarningStatus(status.getMessage());
                }
                case 2: {
                    return RefactoringStatus.createErrorStatus(status.getMessage());
                }
                case 4: {
                    return RefactoringStatus.createFatalErrorStatus(status.getMessage());
                }
                case 8: {
                    return RefactoringStatus.createFatalErrorStatus(status.getMessage());
                }
            }
            return RefactoringStatus.createFatalErrorStatus(status.getMessage());
        }
        IStatus[] children = status.getChildren();
        RefactoringStatus result = new RefactoringStatus();
        int i = 0;
        while (i < children.length) {
            result.merge(RefactoringStatus.create(children[i]));
            ++i;
        }
        return result;
    }

    public void merge(RefactoringStatus other) {
        if (other == null) {
            return;
        }
        this.fEntries.addAll(other.fEntries);
        this.fSeverity = Math.max(this.fSeverity, other.getSeverity());
    }

    public void addInfo(String msg) {
        this.addInfo(msg, null);
    }

    public void addInfo(String msg, RefactoringStatusContext context) {
        this.fEntries.add(new RefactoringStatusEntry(1, msg, context));
        this.fSeverity = Math.max(this.fSeverity, 1);
    }

    public void addWarning(String msg) {
        this.addWarning(msg, null);
    }

    public void addWarning(String msg, RefactoringStatusContext context) {
        this.fEntries.add(new RefactoringStatusEntry(2, msg, context));
        this.fSeverity = Math.max(this.fSeverity, 2);
    }

    public void addError(String msg) {
        this.addError(msg, null);
    }

    public void addError(String msg, RefactoringStatusContext context) {
        this.fEntries.add(new RefactoringStatusEntry(3, msg, context));
        this.fSeverity = Math.max(this.fSeverity, 3);
    }

    public void addFatalError(String msg) {
        this.addFatalError(msg, null);
    }

    public void addFatalError(String msg, RefactoringStatusContext context) {
        this.fEntries.add(new RefactoringStatusEntry(4, msg, context));
        this.fSeverity = Math.max(this.fSeverity, 4);
    }

    public void addEntry(int severity, String msg, RefactoringStatusContext context, String pluginId, int code) {
        this.fEntries.add(new RefactoringStatusEntry(severity, msg, context, pluginId, code));
        this.fSeverity = Math.max(this.fSeverity, severity);
    }

    public void addEntry(int severity, String msg, RefactoringStatusContext context, String pluginId, int code, Object data) {
        this.fEntries.add(new RefactoringStatusEntry(severity, msg, context, pluginId, code, data));
        this.fSeverity = Math.max(this.fSeverity, severity);
    }

    public void addEntry(RefactoringStatusEntry entry) {
        Assert.isNotNull((Object)entry);
        this.fEntries.add(entry);
        this.fSeverity = Math.max(this.fSeverity, entry.getSeverity());
    }

    public boolean isOK() {
        return this.fSeverity == 0;
    }

    public boolean hasFatalError() {
        return this.fSeverity == 4;
    }

    public boolean hasError() {
        return this.fSeverity == 4 || this.fSeverity == 3;
    }

    public boolean hasWarning() {
        return this.fSeverity == 4 || this.fSeverity == 3 || this.fSeverity == 2;
    }

    public boolean hasInfo() {
        return this.fSeverity == 4 || this.fSeverity == 3 || this.fSeverity == 2 || this.fSeverity == 1;
    }

    public String toString() {
        StringBuffer buff = new StringBuffer();
        buff.append("<").append(RefactoringStatus.getSeverityString(this.fSeverity)).append("\n");
        if (!this.isOK()) {
            Iterator iter = this.fEntries.iterator();
            while (iter.hasNext()) {
                buff.append("\t").append(iter.next()).append("\n");
            }
        }
        buff.append(">");
        return buff.toString();
    }

    static String getSeverityString(int severity) {
        Assert.isTrue((severity >= 0 && severity <= 4 ? 1 : 0) != 0);
        if (severity == 0) {
            return "OK";
        }
        if (severity == 1) {
            return "INFO";
        }
        if (severity == 2) {
            return "WARNING";
        }
        if (severity == 3) {
            return "ERROR";
        }
        if (severity == 4) {
            return "FATALERROR";
        }
        return null;
    }
}

