/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.pull;

import org.eclipse.egit.ui.UIText;
import org.eclipse.egit.ui.UIUtils;
import org.eclipse.egit.ui.internal.fetch.FetchResultDialog;
import org.eclipse.egit.ui.internal.merge.MergeResultDialog;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jgit.api.MergeResult;
import org.eclipse.jgit.api.PullResult;
import org.eclipse.jgit.api.RebaseResult;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.FetchResult;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class PullResultDialog
extends Dialog {
    private final Repository repo;
    private final PullResult result;
    private final boolean hasUpdates;

    public PullResultDialog(Shell shell, Repository repo, PullResult result) {
        super(shell);
        this.setShellStyle(this.getShellStyle() & 0xFFFEFFFF | 0x4F0);
        this.setBlockOnOpen(false);
        this.repo = repo;
        this.result = result;
        this.hasUpdates = this.hasFetchResults() || this.hasMergeResults() || this.hasRebaseResults();
    }

    private boolean hasFetchResults() {
        FetchResult fetchResult = this.result.getFetchResult();
        return fetchResult != null && !fetchResult.getTrackingRefUpdates().isEmpty();
    }

    private boolean hasMergeResults() {
        MergeResult mergeResult = this.result.getMergeResult();
        return mergeResult != null && mergeResult.getMergeStatus() != MergeResult.MergeStatus.ALREADY_UP_TO_DATE;
    }

    private boolean hasRebaseResults() {
        RebaseResult rebaseResult = this.result.getRebaseResult();
        return rebaseResult != null && rebaseResult.getStatus() != RebaseResult.Status.UP_TO_DATE;
    }

    protected Control createDialogArea(Composite parent) {
        Composite main = new Composite(parent, 0);
        GridLayoutFactory.swtDefaults().applyTo(main);
        GridDataFactory.fillDefaults().indent(0, 0).grab(true, true).applyTo((Control)main);
        Group fetchResultGroup = new Group(main, 16);
        fetchResultGroup.setText(UIText.PullResultDialog_FetchResultGroupHeader);
        GridLayoutFactory.fillDefaults().applyTo((Composite)fetchResultGroup);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)fetchResultGroup);
        FetchResult fRes = this.result.getFetchResult();
        if (this.hasFetchResults()) {
            GridLayoutFactory.fillDefaults().applyTo((Composite)fetchResultGroup);
            FetchResultDialog dlg = new FetchResultDialog(this.getParentShell(), this.repo, fRes, this.result.getFetchedFrom());
            Control fresult = dlg.createFetchResultTable((Composite)fetchResultGroup);
            Object layoutData = fresult.getLayoutData();
            if (layoutData instanceof GridData) {
                GridDataFactory.createFrom((GridData)((GridData)layoutData)).hint(-1, 130).applyTo(fresult);
            }
        } else {
            GridLayoutFactory.swtDefaults().applyTo((Composite)fetchResultGroup);
            Label noResult = new Label((Composite)fetchResultGroup, 0);
            if (this.result.getFetchedFrom().equals(".")) {
                noResult.setText(UIText.PullResultDialog_NothingToFetchFromLocal);
            } else {
                noResult.setText(NLS.bind((String)UIText.FetchResultDialog_labelEmptyResult, (Object)this.result.getFetchedFrom()));
            }
        }
        Group mergeResultGroup = new Group(main, 16);
        mergeResultGroup.setText(UIText.PullResultDialog_MergeResultGroupHeader);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)mergeResultGroup);
        if (this.hasMergeResults()) {
            GridLayoutFactory.fillDefaults().applyTo((Composite)mergeResultGroup);
            MergeResultDialog dlg = new MergeResultDialog(this.getParentShell(), this.repo, this.result.getMergeResult());
            dlg.createDialogArea((Composite)mergeResultGroup);
        } else if (this.hasRebaseResults()) {
            RebaseResult.Status status = this.result.getRebaseResult().getStatus();
            GridLayoutFactory.fillDefaults().applyTo((Composite)mergeResultGroup);
            switch (status) {
                case OK: 
                case ABORTED: 
                case FAILED: 
                case UP_TO_DATE: 
                case FAST_FORWARD: {
                    break;
                }
                case STOPPED: {
                    Label errorLabel = new Label((Composite)mergeResultGroup, 0);
                    errorLabel.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_ERROR_TSK"));
                    Text errorText = new Text((Composite)mergeResultGroup, 8);
                    errorText.setText(UIText.PullResultDialog_RebaseStoppedMessage);
                }
            }
            Label statusLabel = new Label((Composite)mergeResultGroup, 0);
            statusLabel.setText(UIText.PullResultDialog_RebaseStatusLabel);
            Text statusText = new Text((Composite)mergeResultGroup, 8);
            statusText.setText(status.name());
        } else {
            GridLayoutFactory.swtDefaults().applyTo((Composite)mergeResultGroup);
            Label noResult = new Label((Composite)mergeResultGroup, 0);
            noResult.setText(UIText.PullResultDialog_MergeAlreadyUpToDateMessage);
        }
        return main;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(UIText.PullResultDialog_DialogTitle);
    }

    protected IDialogSettings getDialogBoundsSettings() {
        return this.hasUpdates ? UIUtils.getDialogBoundSettings(((Object)((Object)this)).getClass()) : null;
    }
}

