/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.repository.tree.command;

import java.io.File;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.egit.ui.internal.clone.GitCreateProjectViaWizardWizard;
import org.eclipse.egit.ui.internal.repository.tree.FolderNode;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryTreeNode;
import org.eclipse.egit.ui.internal.repository.tree.command.RepositoriesViewCommandHandler;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportProjectsCommand
extends RepositoriesViewCommandHandler<RepositoryTreeNode> {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        String path;
        RepositoryTreeNode node = (RepositoryTreeNode)this.getSelectedNodes(event).get(0);
        switch (node.getType()) {
            case REPO: 
            case WORKINGDIR: {
                path = node.getRepository().getWorkTree().toString();
                break;
            }
            case FOLDER: {
                path = ((File)((FolderNode)node).getObject()).getPath().toString();
                break;
            }
            default: {
                return null;
            }
        }
        WizardDialog dlg = new WizardDialog(this.getShell(event), (IWizard)new GitCreateProjectViaWizardWizard(node.getRepository(), path));
        dlg.setHelpAvailable(false);
        dlg.open();
        return null;
    }
}

