/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.viewers.model.provisional;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.ui.IElementFactory;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class PresentationContext
implements IPresentationContext {
    private static final String PRESENTATION_CONTEXT_PROPERTIES = "PRESENTATION_CONTEXT_PROPERTIES";
    private static final String BOOLEAN = "BOOLEAN";
    private static final String STRING = "STRING";
    private static final String INTEGER = "INTEGER";
    private static final String PERSISTABLE = "PERSISTABLE";
    private final String fId;
    private final ListenerList fListeners = new ListenerList();
    private final Map fProperties = new HashMap();
    private IWorkbenchWindow fWindow;
    private IWorkbenchPart fPart;

    public PresentationContext(String id) {
        this(id, null, null);
    }

    public PresentationContext(String id, IWorkbenchWindow window) {
        this(id, window, null);
    }

    public PresentationContext(String id, IWorkbenchPart part) {
        this(id, part == null ? null : part.getSite().getWorkbenchWindow(), part);
    }

    public PresentationContext(IWorkbenchPart part) {
        this(part.getSite().getId(), part.getSite().getWorkbenchWindow(), part);
    }

    private PresentationContext(String id, IWorkbenchWindow window, IWorkbenchPart part) {
        this.fId = id;
        this.fWindow = window;
        this.fPart = part;
    }

    public String[] getColumns() {
        return (String[])this.getProperty("PROPERTY_COLUMNS");
    }

    protected void firePropertyChange(String property, Object oldValue, Object newValue) {
        if (!this.fListeners.isEmpty()) {
            final PropertyChangeEvent event = new PropertyChangeEvent((Object)this, property, oldValue, newValue);
            Object[] listeners = this.fListeners.getListeners();
            int i = 0;
            while (i < listeners.length) {
                final IPropertyChangeListener listener = (IPropertyChangeListener)listeners[i];
                SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                    public void run() throws Exception {
                        listener.propertyChange(event);
                    }
                });
                ++i;
            }
        }
    }

    public void setColumns(String[] ids) {
        this.setProperty("PROPERTY_COLUMNS", ids);
    }

    public void dispose() {
        this.fProperties.clear();
        this.setProperty("PROPERTY_DISPOSED", Boolean.TRUE);
        this.fListeners.clear();
        this.fWindow = null;
        this.fPart = null;
    }

    public void addPropertyChangeListener(IPropertyChangeListener listener) {
        this.fListeners.add((Object)listener);
    }

    public void removePropertyChangeListener(IPropertyChangeListener listener) {
        this.fListeners.remove((Object)listener);
    }

    public String getId() {
        return this.fId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getProperty(String property) {
        Map map = this.fProperties;
        synchronized (map) {
            return this.fProperties.get(property);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProperty(String property, Object value) {
        Object oldValue = null;
        boolean propertySet = false;
        Map map = this.fProperties;
        synchronized (map) {
            oldValue = this.fProperties.get(property);
            if (!this.isEqual(oldValue, value)) {
                propertySet = true;
                this.fProperties.put(property, value);
            }
        }
        if (propertySet) {
            this.firePropertyChange(property, oldValue, value);
        }
    }

    public void initProperties(IMemento memento) {
        IMemento presentationMemento = null;
        IMemento[] mementos = memento.getChildren(PRESENTATION_CONTEXT_PROPERTIES);
        int i = 0;
        while (i < mementos.length) {
            if (this.getId().equals(mementos[i].getID())) {
                presentationMemento = mementos[i];
                break;
            }
            ++i;
        }
        if (presentationMemento != null) {
            IMemento[] stringProperties = presentationMemento.getChildren(STRING);
            int i2 = 0;
            while (i2 < stringProperties.length) {
                this.fProperties.put(stringProperties[i2].getID(), stringProperties[i2].getString(STRING));
                ++i2;
            }
            IMemento[] integerMementos = presentationMemento.getChildren(INTEGER);
            int i3 = 0;
            while (i3 < integerMementos.length) {
                this.fProperties.put(integerMementos[i3].getID(), integerMementos[i3].getInteger(INTEGER));
                ++i3;
            }
            IMemento[] booleanMementos = presentationMemento.getChildren(BOOLEAN);
            int i4 = 0;
            while (i4 < booleanMementos.length) {
                this.fProperties.put(booleanMementos[i4].getID(), booleanMementos[i4].getBoolean(BOOLEAN));
                ++i4;
            }
            IMemento[] persistableMementos = presentationMemento.getChildren(PERSISTABLE);
            int i5 = 0;
            while (i5 < persistableMementos.length) {
                IAdaptable element;
                IElementFactory factory;
                String factoryID = persistableMementos[i5].getString(PERSISTABLE);
                if (factoryID != null && (factory = PlatformUI.getWorkbench().getElementFactory(factoryID)) != null && (element = factory.createElement(persistableMementos[i5])) != null) {
                    this.fProperties.put(persistableMementos[i5].getID(), element);
                }
                ++i5;
            }
        }
    }

    public void saveProperites(IMemento memento) {
        if (this.fProperties.size() == 0) {
            return;
        }
        IMemento properties = memento.createChild(PRESENTATION_CONTEXT_PROPERTIES, this.getId());
        Iterator iterator = this.fProperties.entrySet().iterator();
        while (iterator.hasNext()) {
            IMemento value;
            Map.Entry entry = iterator.next();
            if (entry.getValue() instanceof String) {
                value = properties.createChild(STRING, (String)entry.getKey());
                value.putString(STRING, (String)entry.getValue());
                continue;
            }
            if (entry.getValue() instanceof Integer) {
                value = properties.createChild(INTEGER, (String)entry.getKey());
                value.putInteger(INTEGER, ((Integer)entry.getValue()).intValue());
                continue;
            }
            if (entry.getValue() instanceof Boolean) {
                value = properties.createChild(BOOLEAN, (String)entry.getKey());
                value.putBoolean(BOOLEAN, ((Boolean)entry.getValue()).booleanValue());
                continue;
            }
            if (!(entry.getValue() instanceof IPersistableElement)) continue;
            IPersistableElement persistable = (IPersistableElement)entry.getValue();
            IMemento value2 = properties.createChild(PERSISTABLE, (String)entry.getKey());
            value2.putString(PERSISTABLE, persistable.getFactoryId());
            persistable.saveState(value2);
        }
    }

    private boolean isEqual(Object a, Object b) {
        if (a == null) {
            return b == null;
        }
        return a.equals(b);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getProperties() {
        Map map = this.fProperties;
        synchronized (map) {
            Set keys = this.fProperties.keySet();
            return keys.toArray(new String[keys.size()]);
        }
    }

    public IWorkbenchPart getPart() {
        return this.fPart;
    }

    public IWorkbenchWindow getWindow() {
        return this.fWindow;
    }
}

