/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.report.internal;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import java.util.Arrays;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.rcptt.core.model.IQ7NamedElement;
import org.eclipse.rcptt.core.model.search.Q7SearchCore;
import org.eclipse.rcptt.ecl.core.ProcessStatus;
import org.eclipse.rcptt.internal.ui.Images;
import org.eclipse.rcptt.reporting.core.Q7ReportIterator;
import org.eclipse.rcptt.reporting.core.SimpleSeverity;
import org.eclipse.rcptt.reporting.core.TimeFormatHelper;
import org.eclipse.rcptt.ui.actions.AbstractRunAction;
import org.eclipse.rcptt.ui.actions.AbstractRunFailedAction;
import org.eclipse.rcptt.ui.controls.AbstractEmbeddedComposite;
import org.eclipse.rcptt.ui.launching.LaunchUtils;
import org.eclipse.rcptt.ui.report.internal.ReportEntry;
import org.eclipse.rcptt.ui.report.internal.ReportEntryContentProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.BaseSelectionListenerAction;

public class TestCasesComposite
extends AbstractEmbeddedComposite {
    private Composite control;
    private static final Function<ReportEntry, String> toId = new Function<ReportEntry, String>(){

        public String apply(ReportEntry input) {
            return input.id;
        }
    };
    private static final Function<ReportEntry, Integer> reportToStatus = new Function<ReportEntry, Integer>(){

        public Integer apply(ReportEntry input) {
            return input.status.getSeverity();
        }
    };
    private static final Function<String, IQ7NamedElement> elementById = new Function<String, IQ7NamedElement>(){

        public IQ7NamedElement apply(String input) {
            return Q7SearchCore.findById((String)input);
        }
    };
    private static final Function<IQ7NamedElement, IResource> resourceFromElement = new Function<IQ7NamedElement, IResource>(){

        public IResource apply(IQ7NamedElement input) {
            return input.getResource();
        }
    };
    private final BaseSelectionListenerAction runAction = new AbstractRunAction(){

        public void run() {
            Iterable reports = Iterables.filter((Iterable)Iterables.filter((Iterable)this.getStructuredSelection().toList(), ReportEntry.class), (Predicate)Predicates.notNull());
            Iterable ids = Iterables.filter((Iterable)Iterables.transform((Iterable)reports, (Function)toId), (Predicate)Predicates.notNull());
            Iterable elements = Iterables.filter((Iterable)Iterables.transform((Iterable)ids, (Function)elementById), (Predicate)Predicates.notNull());
            Iterable resources = Iterables.transform((Iterable)elements, (Function)resourceFromElement);
            LaunchUtils.launchContext((IResource[])((IResource[])Iterables.toArray((Iterable)resources, IResource.class)), (String)"run");
        }
    };
    private final BaseSelectionListenerAction runFailedAction = new AbstractRunFailedAction(){

        public void run() {
            Object[] data = ((IStructuredContentProvider)TestCasesComposite.this.viewer.getContentProvider()).getElements(TestCasesComposite.this.viewer.getInput());
            Iterable reports = Iterables.filter((Iterable)Iterables.filter(Arrays.asList(data), ReportEntry.class), (Predicate)Predicates.and((Predicate)Predicates.notNull(), (Predicate)Predicates.compose(TestCasesComposite.this.matches(4), (Function)reportToStatus)));
            Iterable ids = Iterables.filter((Iterable)Iterables.transform((Iterable)reports, (Function)toId), (Predicate)Predicates.notNull());
            Iterable elements = Iterables.filter((Iterable)Iterables.transform((Iterable)ids, (Function)elementById), (Predicate)Predicates.notNull());
            Iterable resources = Iterables.transform((Iterable)elements, (Function)resourceFromElement);
            LaunchUtils.launchContext((IResource[])((IResource[])Iterables.toArray((Iterable)resources, IResource.class)), (String)"run");
        }
    };
    private TableViewer viewer;

    Predicate<Integer> matches(final int mask) {
        return new Predicate<Integer>(){

            public boolean apply(Integer input) {
                return (input & mask) != 0;
            }
        };
    }

    protected void fillActions(IToolBarManager manager) {
        manager.add((IAction)this.runAction);
        manager.add((IAction)this.runFailedAction);
    }

    public String getName() {
        return "Test cases";
    }

    public Image getImage() {
        return Images.getImage((String)"icons/file.gif");
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.control = new Composite(parent, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.control);
        GridLayoutFactory.swtDefaults().numColumns(2).equalWidth(false).applyTo(this.control);
        this.viewer = new TableViewer(this.control, 536939264);
        Table table = this.viewer.getTable();
        table.setHeaderVisible(true);
        GridDataFactory.fillDefaults().grab(true, true).hint(-1, 100).applyTo(this.viewer.getControl());
        TableColumn testcaseColumn = new TableColumn(table, 0);
        testcaseColumn.setText("Test case");
        testcaseColumn.setWidth(400);
        TableColumn statusColumn = new TableColumn(table, 0);
        statusColumn.setText("Status");
        statusColumn.setWidth(60);
        TableColumn timeColumn = new TableColumn(table, 0);
        timeColumn.setText("Time");
        timeColumn.setWidth(80);
        TableColumn detColumn = new TableColumn(table, 0);
        detColumn.setText("Details");
        detColumn.setWidth(20);
        this.viewer.setLabelProvider((IBaseLabelProvider)new ReportEntryLabelProvider());
        this.viewer.setContentProvider((IContentProvider)new ReportEntryContentProvider());
        this.viewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                ReportEntry element = (ReportEntry)selection.getFirstElement();
                if (element != null) {
                    TestCasesComposite.this.doOpen(element.id, element.name);
                }
            }
        });
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                ReportEntry element = (ReportEntry)selection.getFirstElement();
                if (element != null) {
                    TestCasesComposite.this.doSelection(element.id, element.name, element.getMessage());
                }
            }
        });
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)this.runAction);
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)this.runFailedAction);
    }

    protected void doSelection(String id, String name, String msg) {
    }

    protected void doOpen(String id, String title) {
    }

    public Control getControl() {
        return this.control;
    }

    public void setReports(final Q7ReportIterator iterator) {
        if (this.viewer.getControl().isDisposed()) {
            return;
        }
        this.viewer.getControl().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                TestCasesComposite.this.viewer.setInput((Object)iterator);
            }
        });
    }

    private class ReportEntryLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private ReportEntryLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            ReportEntry entry = (ReportEntry)element;
            if (columnIndex == 0) {
                if (entry.status.getSeverity() == 0) {
                    return Images.getImage((String)"icons/launching/testok.gif");
                }
                if ((entry.status.getSeverity() & 8) != 0) {
                    return Images.getImage((String)"icons/scenario.gif");
                }
                return Images.getImage((String)"icons/launching/testerr.gif");
            }
            if (columnIndex == 3 && (entry.status.getSeverity() & 2) != 0) {
                return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_WARN_TSK");
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            ReportEntry entry = (ReportEntry)element;
            switch (columnIndex) {
                case 0: {
                    return entry.name;
                }
                case 1: {
                    return SimpleSeverity.create((ProcessStatus)entry.status).name();
                }
                case 2: {
                    return TimeFormatHelper.format((long)entry.time);
                }
            }
            return "";
        }
    }
}

