/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.http.jetty;

import java.security.Permission;
import java.util.Dictionary;
import org.eclipse.equinox.http.jetty.internal.Activator;
import org.osgi.service.cm.ConfigurationPermission;

public class JettyConfigurator {
    private static final String PID_PREFIX = "org.eclipse.equinox.http.jetty.JettyConfigurator.";
    private static Permission configurationPermission = new ConfigurationPermission("*", "configure");

    public static void startServer(String id, Dictionary settings) throws Exception {
        JettyConfigurator.checkConfigurationPermission();
        String pid = PID_PREFIX + id;
        settings.put("service.pid", pid);
        Activator.startServer(pid, settings);
    }

    public static void stopServer(String id) throws Exception {
        JettyConfigurator.checkConfigurationPermission();
        Activator.stopServer(PID_PREFIX + id);
    }

    private static void checkConfigurationPermission() throws SecurityException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(configurationPermission);
        }
    }
}

