/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.commit;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.UIText;
import org.eclipse.egit.ui.internal.commit.CommitEditorInput;
import org.eclipse.egit.ui.internal.commit.CommitEditorPage;
import org.eclipse.egit.ui.internal.commit.DiffEditorPage;
import org.eclipse.egit.ui.internal.commit.HeaderText;
import org.eclipse.egit.ui.internal.commit.NotesEditorPage;
import org.eclipse.egit.ui.internal.commit.RepositoryCommit;
import org.eclipse.egit.ui.internal.repository.RepositoriesView;
import org.eclipse.jface.action.ContributionManager;
import org.eclipse.jface.action.ControlContribution;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jgit.events.ListenerHandle;
import org.eclipse.jgit.events.RefsChangedEvent;
import org.eclipse.jgit.events.RefsChangedListener;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.forms.editor.SharedHeaderFormEditor;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.menus.CommandContributionItem;
import org.eclipse.ui.menus.CommandContributionItemParameter;
import org.eclipse.ui.menus.IMenuService;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.services.IServiceLocator;

public class CommitEditor
extends SharedHeaderFormEditor
implements RefsChangedListener {
    public static final String ID = "org.eclipse.egit.ui.commitEditor";
    private static final String TOOLBAR_HEADER_ID = "org.eclipse.egit.ui.commitEditor.header.toolbar";
    private CommitEditorPage commitPage;
    private DiffEditorPage diffPage;
    private NotesEditorPage notePage;
    private ListenerHandle refListenerHandle;

    public static final IEditorPart open(RepositoryCommit commit) throws PartInitException {
        CommitEditorInput input = new CommitEditorInput(commit);
        return IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IEditorInput)input, (String)ID);
    }

    public static final IEditorPart openQuiet(RepositoryCommit commit) {
        try {
            return CommitEditor.open(commit);
        }
        catch (PartInitException e) {
            Activator.logError(e.getMessage(), e);
            return null;
        }
    }

    protected void addPages() {
        try {
            this.commitPage = new CommitEditorPage((FormEditor)this);
            this.addPage((IFormPage)this.commitPage);
            if (this.getCommit().getRevCommit().getParentCount() <= 1) {
                this.diffPage = new DiffEditorPage((FormEditor)this);
                this.addPage((IFormPage)this.diffPage);
            }
            if (this.getCommit().getNotes().length > 0) {
                this.notePage = new NotesEditorPage((FormEditor)this);
                this.addPage((IFormPage)this.notePage);
            }
        }
        catch (PartInitException e) {
            Activator.error("Error adding page", e);
        }
        this.refListenerHandle = Repository.getGlobalListenerList().addRefsChangedListener((RefsChangedListener)this);
    }

    private CommandContributionItem createCommandContributionItem(String commandId) {
        CommandContributionItemParameter parameter = new CommandContributionItemParameter((IServiceLocator)this.getSite(), commandId, commandId, 8);
        return new CommandContributionItem(parameter);
    }

    protected void createHeaderContents(IManagedForm headerForm) {
        RepositoryCommit commit = this.getCommit();
        ScrolledForm form = headerForm.getForm();
        new HeaderText(form.getForm(), commit.getRevCommit().name());
        form.setToolTipText(commit.getRevCommit().name());
        this.getToolkit().decorateFormHeading(form.getForm());
        IToolBarManager toolbar = form.getToolBarManager();
        ControlContribution repositoryLabelControl = new ControlContribution("repositoryLabel"){

            protected Control createControl(Composite parent) {
                FormToolkit toolkit = CommitEditor.this.getHeaderForm().getToolkit();
                Composite composite = toolkit.createComposite(parent);
                RowLayout layout = new RowLayout();
                composite.setLayout((Layout)layout);
                composite.setBackground(null);
                String label = CommitEditor.this.getCommit().getRepositoryName();
                ImageHyperlink link = new ImageHyperlink(composite, 0);
                link.setText(label);
                link.setFont(JFaceResources.getBannerFont());
                link.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
                link.setToolTipText(UIText.CommitEditor_showGitRepo);
                link.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                    public void linkActivated(HyperlinkEvent event) {
                        try {
                            RepositoriesView view = (RepositoriesView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.eclipse.egit.ui.RepositoriesView");
                            view.showRepository(CommitEditor.this.getCommit().getRepository());
                        }
                        catch (PartInitException e) {
                            Activator.handleError(UIText.CommitEditor_couldNotShowRepository, e, false);
                        }
                    }
                });
                return composite;
            }
        };
        toolbar.add((IContributionItem)repositoryLabelControl);
        toolbar.add((IContributionItem)this.createCommandContributionItem("org.eclipse.egit.ui.commit.CreateTag"));
        toolbar.add((IContributionItem)this.createCommandContributionItem("org.eclipse.egit.ui.commit.CreateBranch"));
        toolbar.add((IContributionItem)this.createCommandContributionItem("org.eclipse.egit.ui.commit.Checkout"));
        toolbar.add((IContributionItem)this.createCommandContributionItem("org.eclipse.egit.ui.commit.CherryPick"));
        this.addContributions(toolbar);
        toolbar.update(true);
        this.getSite().setSelectionProvider(new ISelectionProvider(){

            public void setSelection(ISelection selection) {
            }

            public void removeSelectionChangedListener(ISelectionChangedListener listener) {
            }

            public ISelection getSelection() {
                return new StructuredSelection((Object)CommitEditor.this.getCommit());
            }

            public void addSelectionChangedListener(ISelectionChangedListener listener) {
            }
        });
    }

    private void addContributions(IToolBarManager toolBarManager) {
        IMenuService menuService = (IMenuService)this.getSite().getService(IMenuService.class);
        if (menuService != null && toolBarManager instanceof ContributionManager) {
            ContributionManager contributionManager = (ContributionManager)toolBarManager;
            String toolbarUri = "toolbar:org.eclipse.egit.ui.commitEditor.header.toolbar";
            menuService.populateContributionManager(contributionManager, toolbarUri);
        }
    }

    private RepositoryCommit getCommit() {
        return (RepositoryCommit)((Object)this.getAdapter(RepositoryCommit.class));
    }

    public Object getAdapter(Class adapter) {
        if (RepositoryCommit.class == adapter) {
            return this.getEditorInput().getAdapter(adapter);
        }
        return super.getAdapter(adapter);
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        if (input.getAdapter(RepositoryCommit.class) == null) {
            throw new PartInitException("Input could not be adapted to commit object");
        }
        super.init(site, input);
        this.setPartName(input.getName());
        this.setTitleToolTip(input.getToolTipText());
    }

    public void dispose() {
        this.refListenerHandle.remove();
        super.dispose();
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void onRefsChanged(RefsChangedEvent event) {
        if (this.getCommit().getRepository().getDirectory().equals(event.getRepository().getDirectory())) {
            UIJob job = new UIJob("Refreshing editor"){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    if (!CommitEditor.this.getContainer().isDisposed()) {
                        CommitEditor.this.commitPage.refresh();
                    }
                    return Status.OK_STATUS;
                }
            };
            job.schedule();
        }
    }
}

