/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.search;

import java.text.DateFormat;
import java.text.MessageFormat;
import org.eclipse.egit.ui.UIText;
import org.eclipse.egit.ui.internal.commit.RepositoryCommit;
import org.eclipse.egit.ui.internal.search.RepositoryMatch;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class CommitResultLabelProvider
extends WorkbenchLabelProvider
implements DelegatingStyledCellLabelProvider.IStyledLabelProvider {
    private DateFormat dateFormat = DateFormat.getDateTimeInstance(2, 3);
    private int layout;

    public CommitResultLabelProvider(int layout) {
        this.layout = layout;
    }

    public StyledString getStyledText(Object element) {
        StyledString styled = new StyledString();
        if (element instanceof RepositoryCommit) {
            RepositoryCommit commit = (RepositoryCommit)((Object)element);
            RevCommit revCommit = commit.getRevCommit();
            styled.append(MessageFormat.format(UIText.CommitResultLabelProvider_SectionMessage, commit.abbreviate(), revCommit.getShortMessage()));
            PersonIdent author = revCommit.getAuthorIdent();
            if (author != null) {
                styled.append(MessageFormat.format(UIText.CommitResultLabelProvider_SectionAuthor, author.getName(), this.dateFormat.format(author.getWhen())), StyledString.QUALIFIER_STYLER);
            }
            if (this.layout == 1) {
                styled.append(MessageFormat.format(UIText.CommitResultLabelProvider_SectionRepository, commit.getRepositoryName()), StyledString.DECORATIONS_STYLER);
            }
        } else if (element instanceof RepositoryMatch) {
            RepositoryMatch repository = (RepositoryMatch)((Object)element);
            styled.append(repository.getLabel((Object)repository));
            styled.append(" - ", StyledString.QUALIFIER_STYLER);
            styled.append(repository.getRepository().getDirectory().getAbsolutePath(), StyledString.QUALIFIER_STYLER);
            styled.append(MessageFormat.format(" ({0})", repository.getMatchCount()), StyledString.COUNTER_STYLER);
        }
        return styled;
    }
}

