/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.nls;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.internal.corext.refactoring.nls.AccessorClassReference;
import org.eclipse.jface.text.Region;

public class NLSElement {
    public static final String TAG_PREFIX = "//$NON-NLS-";
    public static final int TAG_PREFIX_LENGTH = "//$NON-NLS-".length();
    public static final String TAG_POSTFIX = "$";
    public static final int TAG_POSTFIX_LENGTH = "$".length();
    private String fValue;
    private Region fPosition;
    private Region fTagPosition;
    private int fIndex;
    private boolean fIsEclipseNLS;
    private AccessorClassReference fAccessorClassReference;

    public NLSElement(String value, int start, int length, int index, boolean isEclipseNLS) {
        this.fValue = value;
        this.fIndex = index;
        Assert.isNotNull((Object)this.fValue);
        this.fPosition = new Region(start, length);
        this.fIsEclipseNLS = isEclipseNLS;
    }

    public Region getPosition() {
        return this.fPosition;
    }

    public String getValue() {
        return this.fValue;
    }

    public void setValue(String value) {
        this.fValue = value;
    }

    public void setTagPosition(int start, int length) {
        this.fTagPosition = new Region(start, length);
    }

    public Region getTagPosition() {
        return this.fTagPosition;
    }

    public boolean hasTag() {
        return this.fTagPosition != null && this.fTagPosition.getLength() > 0;
    }

    public static String createTagText(int index) {
        return TAG_PREFIX + index + TAG_POSTFIX;
    }

    public String getTagText() {
        return TAG_PREFIX + (this.fIndex + 1) + TAG_POSTFIX;
    }

    public String toString() {
        return this.fPosition + ": " + this.fValue + "    Tag position: " + (this.hasTag() ? this.fTagPosition.toString() : "no tag found");
    }

    public boolean isEclipseNLS() {
        return this.fIsEclipseNLS;
    }

    public void setAccessorClassReference(AccessorClassReference accessorClassRef) {
        Assert.isTrue((boolean)this.fIsEclipseNLS);
        this.fAccessorClassReference = accessorClassRef;
    }

    public AccessorClassReference getAccessorClassReference() {
        Assert.isTrue((boolean)this.fIsEclipseNLS);
        return this.fAccessorClassReference;
    }
}

