/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.spelling;

import org.eclipse.jdt.core.compiler.CategorizedProblem;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;

public class CoreSpellingProblem
extends CategorizedProblem {
    public static final String MARKER_TYPE = "org.eclipse.jdt.ui.internal.spelling";
    private int fSourceEnd = 0;
    private int fLineNumber = 1;
    private int fSourceStart = 0;
    private String fMessage;
    private String fWord;
    private boolean fMatch;
    private boolean fSentence;
    private IDocument fDocument;
    private String fOrigin;

    public CoreSpellingProblem(int start, int end, int line, String message, String word, boolean match, boolean sentence, IDocument document, String origin) {
        this.fSourceStart = start;
        this.fSourceEnd = end;
        this.fLineNumber = line;
        this.fMessage = message;
        this.fWord = word;
        this.fMatch = match;
        this.fSentence = sentence;
        this.fDocument = document;
        this.fOrigin = origin;
    }

    public String[] getArguments() {
        String prefix = "";
        String postfix = "";
        try {
            IRegion line = this.fDocument.getLineInformationOfOffset(this.fSourceStart);
            prefix = this.fDocument.get(line.getOffset(), this.fSourceStart - line.getOffset());
            int postfixStart = this.fSourceEnd + 1;
            postfix = this.fDocument.get(postfixStart, line.getOffset() + line.getLength() - postfixStart);
        }
        catch (BadLocationException badLocationException) {}
        return new String[]{this.fWord, prefix, postfix, this.fSentence ? Boolean.toString(true) : Boolean.toString(false), this.fMatch ? Boolean.toString(true) : Boolean.toString(false)};
    }

    public int getID() {
        return Integer.MIN_VALUE;
    }

    public String getMessage() {
        return this.fMessage;
    }

    public char[] getOriginatingFileName() {
        return this.fOrigin.toCharArray();
    }

    public int getSourceEnd() {
        return this.fSourceEnd;
    }

    public int getSourceLineNumber() {
        return this.fLineNumber;
    }

    public int getSourceStart() {
        return this.fSourceStart;
    }

    public boolean isError() {
        return false;
    }

    public boolean isWarning() {
        return true;
    }

    public void setSourceStart(int sourceStart) {
        this.fSourceStart = sourceStart;
    }

    public void setSourceEnd(int sourceEnd) {
        this.fSourceEnd = sourceEnd;
    }

    public void setSourceLineNumber(int lineNumber) {
        this.fLineNumber = lineNumber;
    }

    public int getCategoryID() {
        return 70;
    }

    public String getMarkerType() {
        return MARKER_TYPE;
    }
}

