/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.tesla.jface;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.rcptt.tesla.jface.JFaceAspectsActivator;
import org.eclipse.rcptt.tesla.swt.images.ImageDataMapping;
import org.eclipse.rcptt.util.WeakIdentityHashMap;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ImageSources {
    INSTANCE;

    private Map<ImageDescriptor, ImageSource> descriptors = new WeakIdentityHashMap();
    private Map<Object, ImageSource> sources = new WeakIdentityHashMap();

    public ImageSource find(Image image) {
        return this.sources.get(ImageSources.dedup(image));
    }

    private synchronized ImageSource findOrCreate(ImageDescriptor descriptor) {
        ImageSource result = this.descriptors.get(descriptor);
        if (result != null) {
            return result;
        }
        if (descriptor instanceof CompositeImageDescriptor) {
            result = new CompositeSource();
            this.descriptors.put(descriptor, result);
            return result;
        }
        if (ResourceSource.isValidSource(descriptor)) {
            result = new ResourceSource(descriptor);
            this.descriptors.put(descriptor, result);
            return result;
        }
        return null;
    }

    public synchronized void imageDataFromDescriptor(ImageData imageData, ImageDescriptor descriptor) {
        this.imageOrDataFromDescriptor(ImageSources.dedup(imageData), descriptor);
    }

    public synchronized void imageFromDescriptor(Image image, ImageDescriptor descriptor) {
        this.imageOrDataFromDescriptor(ImageSources.dedup(image), descriptor);
    }

    private synchronized void imageOrDataFromDescriptor(Object imageOrData, ImageDescriptor descriptor) {
        ImageSource source = this.findOrCreate(descriptor);
        if (source == null) {
            return;
        }
        this.sources.put(imageOrData, source);
    }

    private static Object dedup(Object imageOrData) {
        Object source = ImageDataMapping.INSTANCE.getSource(imageOrData);
        return source == null ? imageOrData : source;
    }

    public synchronized void imageDrawn(ImageData data, ImageDescriptor descriptor) {
        ImageSource composite = this.findOrCreate(descriptor);
        ImageSource source = this.sources.get(ImageSources.dedup(data));
        if (source == null) {
            return;
        }
        if (!(composite instanceof CompositeSource)) {
            return;
        }
        ((CompositeSource)composite).addUnique(source);
    }

    public static class CompositeSource
    extends ImageSource {
        public final List<ImageSource> children = new ArrayList<ImageSource>();

        public void addUnique(ImageSource source) {
            for (ImageSource src : this.children) {
                if (!src.equals(source)) continue;
                return;
            }
            this.children.add(source);
        }

        public String toString() {
            return this.children.toString();
        }
    }

    public static class ImageSource {
    }

    public static class ResourceSource
    extends ImageSource {
        private static Pattern bundleUrlDescriptor = Pattern.compile("URLImageDescriptor\\(((bundleentry|bundleresource).*)\\)");
        private static Pattern platformUrlDescriptor = Pattern.compile("URLImageDescriptor\\(platform:/plugin/(.*)\\)");
        private static Pattern fileClassDescriptor = Pattern.compile("FileImageDescriptor\\(location=class (.*), name=(.*)\\)");
        public final String source;

        private static String getInfo(String str) {
            Matcher urlMatcher = bundleUrlDescriptor.matcher(str);
            if (urlMatcher.matches()) {
                String uriStr = urlMatcher.group(1);
                URI bundleUri = null;
                try {
                    bundleUri = new URI(uriStr);
                }
                catch (URISyntaxException uRISyntaxException) {
                    return "InvalidUri(" + uriStr + ")";
                }
                String host = bundleUri.getHost();
                int bundleIdEndIndex = host.indexOf(".fwk");
                if (bundleIdEndIndex == -1) {
                    return "UnknownBundleId(" + uriStr + ")";
                }
                int bundleId = -1;
                try {
                    bundleId = Integer.parseInt(host.substring(0, bundleIdEndIndex));
                }
                catch (NumberFormatException numberFormatException) {
                    return "UnknownBundleId(" + uriStr + ")";
                }
                Bundle imageBundle = JFaceAspectsActivator.getDefault().getBundle().getBundleContext().getBundle((long)bundleId);
                String bundleName = imageBundle == null ? "unknownBundle" : imageBundle.getSymbolicName();
                return String.format("%s%s", bundleName, bundleUri.getPath());
            }
            Matcher platformMatcher = platformUrlDescriptor.matcher(str);
            if (platformMatcher.matches()) {
                return platformMatcher.group(1);
            }
            Matcher fileMatcher = fileClassDescriptor.matcher(str);
            if (fileMatcher.matches()) {
                return String.format("%s%s", fileMatcher.group(1), fileMatcher.group(2));
            }
            return str;
        }

        public static boolean isValidSource(ImageDescriptor source) {
            String str = source.toString();
            Matcher urlMatcher = bundleUrlDescriptor.matcher(str);
            Matcher platformMatcher = platformUrlDescriptor.matcher(str);
            Matcher fileMatcher = fileClassDescriptor.matcher(str);
            return urlMatcher.matches() || platformMatcher.matches() || fileMatcher.matches();
        }

        public ResourceSource(ImageDescriptor source) {
            this.source = ResourceSource.getInfo(source.toString());
        }

        public String toString() {
            return this.source;
        }
    }
}

