/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core;

import java.io.File;
import java.util.Collection;
import java.util.Dictionary;
import java.util.Hashtable;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.egit.core.CoreText;
import org.eclipse.egit.core.GitCorePreferences;
import org.eclipse.egit.core.JobFamilies;
import org.eclipse.egit.core.RepositoryCache;
import org.eclipse.egit.core.RepositoryUtil;
import org.eclipse.egit.core.internal.indexdiff.IndexDiffCache;
import org.eclipse.egit.core.internal.job.JobUtil;
import org.eclipse.egit.core.internal.trace.GitTraceLocation;
import org.eclipse.egit.core.op.ConnectProviderOperation;
import org.eclipse.egit.core.project.GitProjectData;
import org.eclipse.egit.core.project.RepositoryFinder;
import org.eclipse.egit.core.project.RepositoryMapping;
import org.eclipse.egit.core.securestorage.EGitSecureStore;
import org.eclipse.equinox.security.storage.SecurePreferencesFactory;
import org.eclipse.jgit.util.FS;
import org.eclipse.osgi.service.debug.DebugOptions;
import org.eclipse.osgi.service.debug.DebugOptionsListener;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.Team;
import org.osgi.framework.BundleContext;

public class Activator
extends Plugin
implements DebugOptionsListener {
    private static Activator plugin;
    private RepositoryCache repositoryCache;
    private IndexDiffCache indexDiffCache;
    private RepositoryUtil repositoryUtil;
    private EGitSecureStore secureStore;
    private AutoShareProjects shareGitProjectsJob;

    public static Activator getDefault() {
        return plugin;
    }

    public static String getPluginId() {
        return Activator.getDefault().getBundle().getSymbolicName();
    }

    public static IStatus error(String message, Throwable thr) {
        return new Status(4, Activator.getPluginId(), 0, message, thr);
    }

    public static void logError(String message, Throwable thr) {
        Activator.getDefault().getLog().log((IStatus)new Status(4, Activator.getPluginId(), 0, message, thr));
    }

    public Activator() {
        Activator.setActivator(this);
    }

    private static void setActivator(Activator a) {
        plugin = a;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        Hashtable<String, String> props = new Hashtable<String, String>(4);
        ((Dictionary)props).put("listener.symbolic.name", context.getBundle().getSymbolicName());
        context.registerService(DebugOptionsListener.class.getName(), (Object)this, props);
        this.repositoryCache = new RepositoryCache();
        this.indexDiffCache = new IndexDiffCache();
        try {
            GitProjectData.reconfigureWindowCache();
        }
        catch (RuntimeException e) {
            Activator.logError(CoreText.Activator_ReconfigureWindowCacheError, e);
        }
        GitProjectData.attachToWorkspace(true);
        IEclipsePreferences node = new InstanceScope().getNode(Activator.getPluginId());
        String gitPrefix = node.get(GitCorePreferences.core_gitPrefix, null);
        if (gitPrefix != null) {
            FS.DETECTED.setGitPrefix(new File(gitPrefix));
        }
        this.repositoryUtil = new RepositoryUtil();
        this.secureStore = new EGitSecureStore(SecurePreferencesFactory.getDefault());
        this.registerAutoShareProjects();
    }

    public void optionsChanged(DebugOptions options) {
        GitTraceLocation.initializeFromOptions(options, this.isDebugging());
    }

    public RepositoryCache getRepositoryCache() {
        return this.repositoryCache;
    }

    public IndexDiffCache getIndexDiffCache() {
        return this.indexDiffCache;
    }

    public RepositoryUtil getRepositoryUtil() {
        return this.repositoryUtil;
    }

    public EGitSecureStore getSecureStore() {
        return this.secureStore;
    }

    public void stop(BundleContext context) throws Exception {
        GitProjectData.detachFromWorkspace();
        this.repositoryCache = null;
        this.indexDiffCache = null;
        this.repositoryUtil.dispose();
        this.repositoryUtil = null;
        this.secureStore = null;
        super.stop(context);
        plugin = null;
    }

    private void registerAutoShareProjects() {
        this.shareGitProjectsJob = new AutoShareProjects();
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.shareGitProjectsJob, 1);
    }

    private static class AutoShareProjects
    implements IResourceChangeListener {
        private static int INTERESTING_CHANGES = 16385;

        private boolean doAutoShare() {
            IEclipsePreferences d = new DefaultScope().getNode(Activator.getPluginId());
            IEclipsePreferences p = new InstanceScope().getNode(Activator.getPluginId());
            return p.getBoolean("core_autoShareProjects", d.getBoolean("core_autoShareProjects", false));
        }

        public void resourceChanged(IResourceChangeEvent event) {
            try {
                event.getDelta().accept(new IResourceDeltaVisitor(){

                    public boolean visit(IResourceDelta delta) throws CoreException {
                        if (!AutoShareProjects.this.doAutoShare()) {
                            return false;
                        }
                        if (delta.getKind() == 4 && (delta.getFlags() & INTERESTING_CHANGES) == 0) {
                            return true;
                        }
                        IResource resource = delta.getResource();
                        if (!resource.exists() || !resource.isAccessible()) {
                            return false;
                        }
                        if (resource.getType() != 4) {
                            return true;
                        }
                        if (Team.isIgnoredHint((IResource)resource)) {
                            return false;
                        }
                        if (RepositoryMapping.getMapping(resource) != null) {
                            return false;
                        }
                        IProject project = (IProject)resource;
                        RepositoryProvider provider = RepositoryProvider.getProvider((IProject)project);
                        if (provider != null) {
                            return false;
                        }
                        RepositoryFinder f = new RepositoryFinder(project);
                        Collection<RepositoryMapping> mappings = f.find((IProgressMonitor)new NullProgressMonitor());
                        try {
                            if (mappings.size() == 1) {
                                RepositoryMapping m = mappings.iterator().next();
                                File repositoryDir = m.getGitDirAbsolutePath().toFile();
                                ConnectProviderOperation op = new ConnectProviderOperation(project, repositoryDir);
                                JobUtil.scheduleUserJob(op, CoreText.Activator_AutoShareJobName, JobFamilies.AUTO_SHARE);
                                Activator.getDefault().getRepositoryUtil().addConfiguredRepository(repositoryDir);
                            }
                        }
                        catch (IllegalArgumentException e) {
                            Activator.logError(CoreText.Activator_AutoSharingFailed, e);
                        }
                        return false;
                    }
                });
            }
            catch (CoreException e) {
                Activator.logError(e.getMessage(), e);
                return;
            }
        }
    }
}

