/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.op;

import java.io.IOException;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.egit.core.Activator;
import org.eclipse.egit.core.CoreText;
import org.eclipse.egit.core.internal.job.RuleUtil;
import org.eclipse.egit.core.op.IEGitOperation;
import org.eclipse.egit.core.project.GitProjectData;
import org.eclipse.egit.core.project.RepositoryMapping;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.dircache.DirCacheEntry;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssumeUnchangedOperation
implements IEGitOperation {
    private final Collection<? extends IResource> rsrcList;
    private final IdentityHashMap<Repository, DirCache> caches;
    private final IdentityHashMap<RepositoryMapping, Object> mappings;
    private boolean assumeUnchanged;

    public AssumeUnchangedOperation(Collection<? extends IResource> rsrcs, boolean assumeUnchanged) {
        this.rsrcList = rsrcs;
        this.caches = new IdentityHashMap();
        this.mappings = new IdentityHashMap();
        this.assumeUnchanged = assumeUnchanged;
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    @Override
    public void execute(IProgressMonitor m) throws CoreException {
        monitor /* !! */  = m == null ? new NullProgressMonitor() : m;
        this.caches.clear();
        this.mappings.clear();
        monitor /* !! */ .beginTask(CoreText.AssumeUnchangedOperation_adding, this.rsrcList.size() * 200);
        try {
            try {
                for (IResource resource : this.rsrcList) {
                    this.assumeValid(resource);
                    monitor /* !! */ .worked(200);
                }
                for (Map.Entry e : this.caches.entrySet()) {
                    db = (Repository)e.getKey();
                    editor = (DirCache)e.getValue();
                    monitor /* !! */ .setTaskName(NLS.bind((String)CoreText.AssumeUnchangedOperation_writingIndex, (Object)db.getDirectory()));
                    editor.write();
                    editor.commit();
                }
            }
            catch (RuntimeException e) {
                throw new CoreException(Activator.error(CoreText.UntrackOperation_failed, e));
            }
            catch (IOException e) {
                throw new CoreException(Activator.error(CoreText.UntrackOperation_failed, e));
            }
        }
        finally {
            ** for (rm : this.mappings.keySet())
        }
lbl-1000:
        // 1 sources

        {
            rm.fireRepositoryChanged();
            continue;
        }
lbl28:
        // 2 sources

        for (DirCache cache : this.caches.values()) {
            cache.unlock();
        }
        this.caches.clear();
        this.mappings.clear();
        monitor /* !! */ .done();
    }

    @Override
    public ISchedulingRule getSchedulingRule() {
        return RuleUtil.getRuleForRepositories(this.rsrcList.toArray(new IResource[this.rsrcList.size()]));
    }

    private void assumeValid(IResource resource) throws CoreException {
        IProject proj = resource.getProject();
        GitProjectData pd = GitProjectData.get(proj);
        if (pd == null) {
            return;
        }
        RepositoryMapping rm = pd.getRepositoryMapping(resource);
        if (rm == null) {
            return;
        }
        Repository db = rm.getRepository();
        DirCache cache = this.caches.get(db);
        if (cache == null) {
            try {
                cache = db.lockDirCache();
            }
            catch (IOException err) {
                throw new CoreException(Activator.error(CoreText.UntrackOperation_failed, err));
            }
            this.caches.put(db, cache);
            this.mappings.put(rm, rm);
        }
        String path = rm.getRepoRelativePath(resource);
        if (resource instanceof IContainer) {
            DirCacheEntry[] dirCacheEntryArray = cache.getEntriesWithin(path);
            int n = dirCacheEntryArray.length;
            int n2 = 0;
            while (n2 < n) {
                DirCacheEntry ent = dirCacheEntryArray[n2];
                ent.setAssumeValid(this.assumeUnchanged);
                ++n2;
            }
        } else {
            DirCacheEntry ent = cache.getEntry(path);
            if (ent != null) {
                ent.setAssumeValid(this.assumeUnchanged);
            }
        }
    }
}

