/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.synchronize.dto;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.egit.core.RevUtils;
import org.eclipse.egit.core.project.RepositoryMapping;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.ObjectWalk;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.treewalk.filter.PathFilterGroup;
import org.eclipse.jgit.treewalk.filter.TreeFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GitSynchronizeData {
    private static final IWorkspaceRoot ROOT = ResourcesPlugin.getWorkspace().getRoot();
    public static final Pattern BRANCH_NAME_PATTERN = Pattern.compile("^refs/heads/.*?");
    private final boolean includeLocal;
    private final Repository repo;
    private final String srcRemote;
    private final String dstRemote;
    private final String srcMerge;
    private final String dstMerge;
    private RevCommit srcRevCommit;
    private RevCommit dstRevCommit;
    private RevCommit ancestorRevCommit;
    private final Set<IProject> projects;
    private final String repoParentPath;
    private final String srcRev;
    private final String dstRev;
    private TreeFilter pathFilter;
    private Set<IContainer> includedPaths;

    public GitSynchronizeData(Repository repository, String srcRev, String dstRev, boolean includeLocal) throws IOException {
        IProject[] workspaceProjects;
        Assert.isNotNull((Object)repository);
        Assert.isNotNull((Object)srcRev);
        Assert.isNotNull((Object)dstRev);
        this.repo = repository;
        this.srcRev = srcRev;
        this.dstRev = dstRev;
        this.includeLocal = includeLocal;
        RemoteConfig srcRemoteConfig = this.extractRemoteName(srcRev);
        RemoteConfig dstRemoteConfig = this.extractRemoteName(dstRev);
        this.srcRemote = srcRemoteConfig.remote;
        this.srcMerge = srcRemoteConfig.merge;
        this.dstRemote = dstRemoteConfig.remote;
        this.dstMerge = dstRemoteConfig.merge;
        this.repoParentPath = this.repo.getDirectory().getParentFile().getAbsolutePath();
        this.projects = new HashSet<IProject>();
        IProject[] iProjectArray = workspaceProjects = ROOT.getProjects();
        int n = workspaceProjects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            RepositoryMapping mapping = RepositoryMapping.getMapping((IResource)project);
            if (mapping != null && mapping.getRepository() == this.repo) {
                this.projects.add(project);
            }
            ++n2;
        }
        this.updateRevs();
    }

    public void updateRevs() throws IOException {
        ObjectWalk ow = new ObjectWalk(this.repo);
        try {
            this.srcRevCommit = this.getCommit(this.srcRev, ow);
            this.dstRevCommit = this.getCommit(this.dstRev, ow);
        }
        finally {
            ow.release();
        }
        this.ancestorRevCommit = this.dstRevCommit != null || this.srcRevCommit != null ? RevUtils.getCommonAncestor(this.repo, (AnyObjectId)this.srcRevCommit, (AnyObjectId)this.dstRevCommit) : null;
    }

    public Repository getRepository() {
        return this.repo;
    }

    public String getSrcRemoteName() {
        return this.srcRemote;
    }

    public String getDstMerge() {
        return this.dstMerge;
    }

    public String getSrcMerge() {
        return this.srcMerge;
    }

    public String getDstRemoteName() {
        return this.dstRemote;
    }

    public RevCommit getSrcRevCommit() {
        return this.srcRevCommit;
    }

    public RevCommit getDstRevCommit() {
        return this.dstRevCommit;
    }

    public Set<IProject> getProjects() {
        return Collections.unmodifiableSet(this.projects);
    }

    public boolean contains(File file) {
        return file.getAbsoluteFile().toString().startsWith(this.repoParentPath);
    }

    public boolean shouldIncludeLocal() {
        return this.includeLocal;
    }

    public RevCommit getCommonAncestorRev() {
        return this.ancestorRevCommit;
    }

    public void setIncludedPaths(Set<IContainer> includedPaths) {
        this.includedPaths = includedPaths;
        HashSet<String> paths = new HashSet<String>();
        RepositoryMapping rm = RepositoryMapping.findRepositoryMapping(this.repo);
        for (IContainer container : includedPaths) {
            String repoRelativePath = rm.getRepoRelativePath((IResource)container);
            if (repoRelativePath.length() <= 0) continue;
            paths.add(repoRelativePath);
        }
        if (!paths.isEmpty()) {
            this.pathFilter = PathFilterGroup.createFromStrings(paths);
        }
    }

    public Set<IContainer> getIncludedPaths() {
        return this.includedPaths;
    }

    public TreeFilter getPathFilter() {
        return this.pathFilter;
    }

    private RemoteConfig extractRemoteName(String rev) {
        Ref ref;
        if (rev.contains("refs/remotes/")) {
            String remoteWithBranchName = rev.replaceAll("refs/remotes/", "");
            int firstSeparator = remoteWithBranchName.indexOf("/");
            String remote = remoteWithBranchName.substring(0, firstSeparator);
            String name = remoteWithBranchName.substring(firstSeparator + 1, remoteWithBranchName.length());
            return new RemoteConfig(remote, "refs/heads/" + name);
        }
        try {
            ref = this.repo.getRef(rev);
        }
        catch (IOException iOException) {
            ref = null;
        }
        String realName = ref != null && ref.isSymbolic() ? ref.getTarget().getName() : rev;
        String name = BRANCH_NAME_PATTERN.matcher(realName).replaceAll("");
        String remote = this.repo.getConfig().getString("branch", name, "remote");
        String merge = this.repo.getConfig().getString("branch", name, "merge");
        return new RemoteConfig(remote, merge);
    }

    private RevCommit getCommit(String rev, ObjectWalk ow) throws IOException {
        if (rev.length() > 0) {
            ObjectId id = this.repo.resolve(rev);
            return id != null ? ow.parseCommit((AnyObjectId)id) : null;
        }
        return null;
    }

    private static class RemoteConfig {
        final String remote;
        final String merge;

        public RemoteConfig(String remote, String merge) {
            this.remote = remote;
            this.merge = merge;
        }
    }
}

