/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.framelist;

import org.eclipse.jface.action.IAction;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.views.framelist.FrameListMessages;
import org.eclipse.ui.views.framelist.Frame;
import org.eclipse.ui.views.framelist.FrameAction;
import org.eclipse.ui.views.framelist.FrameList;

public class ForwardAction
extends FrameAction {
    public ForwardAction(FrameList frameList) {
        super(frameList);
        this.setText(FrameListMessages.Forward_text);
        ISharedImages images = PlatformUI.getWorkbench().getSharedImages();
        this.setImageDescriptor(images.getImageDescriptor("IMG_TOOL_FORWARD"));
        this.setDisabledImageDescriptor(images.getImageDescriptor("IMG_TOOL_FORWARD_DISABLED"));
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.ui.forward_action_context");
        this.update();
    }

    private Frame getNextFrame() {
        FrameList list = this.getFrameList();
        return list.getFrame(list.getCurrentIndex() + 1);
    }

    private String getToolTipText(Frame nextFrame) {
        String text;
        if (nextFrame != null && (text = nextFrame.getToolTipText()) != null && text.length() > 0) {
            return NLS.bind((String)FrameListMessages.Forward_toolTipOneArg, (Object)text);
        }
        return FrameListMessages.Forward_toolTip;
    }

    public void run() {
        this.getFrameList().forward();
    }

    public void update() {
        super.update();
        Frame nextFrame = this.getNextFrame();
        this.setEnabled(nextFrame != null);
        this.setToolTipText(this.getToolTipText(nextFrame));
    }
}

