/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.sherlock.core.info;

import java.io.File;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IBundleGroup;
import org.eclipse.emf.common.util.EList;
import org.eclipse.rcptt.sherlock.core.info.EclipseInfoProvider;
import org.eclipse.rcptt.sherlock.core.info.JavaInfoProvider;
import org.eclipse.rcptt.sherlock.core.info.SystemInfoProvider;
import org.eclipse.rcptt.sherlock.core.model.sherlock.EclipseFeature;
import org.eclipse.rcptt.sherlock.core.model.sherlock.EclipseInfo;
import org.eclipse.rcptt.sherlock.core.model.sherlock.EclipsePlugin;
import org.eclipse.rcptt.sherlock.core.model.sherlock.EclipsePreference;
import org.eclipse.rcptt.sherlock.core.model.sherlock.JavaInfo;
import org.eclipse.rcptt.sherlock.core.model.sherlock.JavaProperty;
import org.eclipse.rcptt.sherlock.core.model.sherlock.SherlockFactory;
import org.eclipse.rcptt.sherlock.core.model.sherlock.SystemInfo;
import org.eclipse.rcptt.sherlock.core.model.sherlock.SystemVariable;
import org.osgi.framework.Bundle;
import org.osgi.service.prefs.Preferences;

public final class Info {
    public static SystemInfo getSystem() {
        SystemInfo info = SherlockFactory.eINSTANCE.createSystemInfo();
        info.setOsName(SystemInfoProvider.getOSName());
        info.setOsArch(SystemInfoProvider.getOSArch());
        info.setOsVersion(SystemInfoProvider.getOSVersion());
        info.setUsername(SystemInfoProvider.getUsername());
        EList<SystemVariable> vars = info.getVariables();
        for (Map.Entry<String, String> entry : SystemInfoProvider.getVariables().entrySet()) {
            SystemVariable var = SherlockFactory.eINSTANCE.createSystemVariable();
            var.setName(entry.getKey());
            var.setValue(entry.getValue());
            vars.add(var);
        }
        return info;
    }

    public static JavaInfo getJava() {
        JavaInfo info = SherlockFactory.eINSTANCE.createJavaInfo();
        info.setRuntimeName(JavaInfoProvider.getRuntimeName());
        info.setRuntimeVersion(JavaInfoProvider.getRuntimeVersion());
        info.setFreeMemory(JavaInfoProvider.getFreeMemory());
        info.setMaxMemory(JavaInfoProvider.getMaxMemory());
        info.setTotalMemory(JavaInfoProvider.getTotalMemory());
        EList<JavaProperty> props = info.getProperties();
        for (Map.Entry<String, String> entry : JavaInfoProvider.getProperties().entrySet()) {
            JavaProperty prop = SherlockFactory.eINSTANCE.createJavaProperty();
            prop.setName(entry.getKey());
            prop.setValue(entry.getValue());
            props.add(prop);
        }
        return info;
    }

    public static EclipseInfo getEclipse() {
        return Info.getEclipse(EclipseInfoProvider.getFeatures());
    }

    public static EclipseInfo getEclipse(List<IBundleGroup> features) {
        EclipseInfo info = SherlockFactory.eINSTANCE.createEclipseInfo();
        info.setBuildId(EclipseInfoProvider.getBuildId());
        String workspace = EclipseInfoProvider.getWorkspaceLocation();
        info.setWorkspaceLocation(workspace);
        if (workspace != null) {
            try {
                File workspaceDir = new File(workspace);
                info.setWorkspacePartitionTotalDiskspace(workspaceDir.getTotalSpace());
                info.setWorkspacePartitionUsableDiskspace(workspaceDir.getUsableSpace());
                info.setWorkspacePartitionFreeDiskspace(workspaceDir.getFreeSpace());
            }
            catch (Throwable throwable) {}
        }
        info.setUptime(EclipseInfoProvider.getUptime());
        info.setProductId(EclipseInfoProvider.getProductId());
        info.setApplicationId(EclipseInfoProvider.getApplicationId());
        info.getApplicationArgs().addAll(Arrays.asList(EclipseInfoProvider.getApplicationArgs()));
        for (IBundleGroup group : features) {
            EclipseFeature feature = SherlockFactory.eINSTANCE.createEclipseFeature();
            feature.setId(group.getIdentifier());
            feature.setVersion(group.getVersion());
            feature.setProvider(group.getProviderName());
            feature.setName(group.getName());
            info.getFeatures().add((Object)feature);
        }
        for (Bundle bundle : EclipseInfoProvider.getPlugins()) {
            Dictionary headers = bundle.getHeaders();
            EclipsePlugin plugin = SherlockFactory.eINSTANCE.createEclipsePlugin();
            plugin.setName((String)headers.get("Bundle-Name"));
            plugin.setProvider((String)headers.get("Bundle-Vendor"));
            plugin.setId(bundle.getSymbolicName());
            plugin.setVersion((String)headers.get("Bundle-Version"));
            info.getPlugins().add((Object)plugin);
        }
        LinkedList<Preferences> unprocessed = new LinkedList<Preferences>();
        unprocessed.add(EclipseInfoProvider.getPreferencesRoot());
        try {
            while (unprocessed.size() > 0) {
                Preferences p = (Preferences)unprocessed.get(0);
                unprocessed.remove(0);
                String absolutePath = p.absolutePath();
                String[] stringArray = p.childrenNames();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String childName = stringArray[n2];
                    unprocessed.add(0, p.node(childName));
                    ++n2;
                }
                stringArray = p.keys();
                n = stringArray.length;
                n2 = 0;
                while (n2 < n) {
                    String key = stringArray[n2];
                    EclipsePreference pref = SherlockFactory.eINSTANCE.createEclipsePreference();
                    pref.setName(key);
                    pref.setValue(p.get(key, ""));
                    pref.setPath(absolutePath);
                    info.getPreferences().add((Object)pref);
                    ++n2;
                }
            }
        }
        catch (Throwable throwable) {}
        return info;
    }

    private Info() {
    }
}

