/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.tesla.core.protocol;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum DragKind implements Enumerator
{
    START(0, "Start", "Start"),
    END(1, "End", "End"),
    SET_DATA(2, "SetData", "SetData"),
    ACCEPT(3, "Accept", "Accept"),
    DROP(4, "Drop", "Drop"),
    DETECT(5, "Detect", "Detect"),
    OVER(6, "Over", "Over"),
    LEAVE(7, "Leave", "Leave"),
    ENTER(8, "Enter", "Enter");

    public static final int START_VALUE = 0;
    public static final int END_VALUE = 1;
    public static final int SET_DATA_VALUE = 2;
    public static final int ACCEPT_VALUE = 3;
    public static final int DROP_VALUE = 4;
    public static final int DETECT_VALUE = 5;
    public static final int OVER_VALUE = 6;
    public static final int LEAVE_VALUE = 7;
    public static final int ENTER_VALUE = 8;
    private static final DragKind[] VALUES_ARRAY;
    public static final List<DragKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new DragKind[]{START, END, SET_DATA, ACCEPT, DROP, DETECT, OVER, LEAVE, ENTER};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static DragKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            DragKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static DragKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            DragKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static DragKind get(int value) {
        switch (value) {
            case 0: {
                return START;
            }
            case 1: {
                return END;
            }
            case 2: {
                return SET_DATA;
            }
            case 3: {
                return ACCEPT;
            }
            case 4: {
                return DROP;
            }
            case 5: {
                return DETECT;
            }
            case 6: {
                return OVER;
            }
            case 7: {
                return LEAVE;
            }
            case 8: {
                return ENTER;
            }
        }
        return null;
    }

    private DragKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

