/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.actions;

import org.eclipse.jdt.core.ICodeAssist;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.compiler.IScanner;
import org.eclipse.jdt.core.compiler.InvalidInputException;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class StepIntoSelectionUtils {
    public static IJavaElement getJavaElement(IEditorInput input) {
        IJavaElement je = JavaUI.getEditorInputJavaElement((IEditorInput)input);
        if (je != null) {
            return je;
        }
        return JavaUI.getWorkingCopyManager().getWorkingCopy(input);
    }

    public static IMethod getMethod(ITextSelection selection, IJavaElement element) throws JavaModelException {
        if (element != null && element instanceof ICodeAssist) {
            return StepIntoSelectionUtils.resolveMethod(selection.getOffset(), selection.getLength(), (ICodeAssist)element);
        }
        return null;
    }

    private static IMethod resolveMethod(int offset, int length, ICodeAssist codeAssist) throws JavaModelException {
        IJavaElement[] elements = codeAssist.codeSelect(offset, length);
        int i = 0;
        while (i < elements.length) {
            if (elements[i] instanceof IMethod) {
                return (IMethod)elements[i];
            }
            ++i;
        }
        return null;
    }

    public static IMethod getFirstMethodOnLine(int offset, IEditorPart activeEditor, IJavaElement element) throws JavaModelException {
        if (!(activeEditor instanceof ITextEditor) || !(element instanceof ICodeAssist)) {
            return null;
        }
        ITextEditor editor = (ITextEditor)activeEditor;
        IDocumentProvider documentProvider = editor.getDocumentProvider();
        if (documentProvider == null) {
            return null;
        }
        IDocument document = documentProvider.getDocument((Object)editor.getEditorInput());
        if (document == null) {
            return null;
        }
        try {
            IRegion lineInfo = document.getLineInformationOfOffset(offset);
            String line = document.get(lineInfo.getOffset(), lineInfo.getLength());
            IScanner scanner = ToolFactory.createScanner((boolean)false, (boolean)false, (boolean)false, null, (String)"1.5");
            scanner.setSource(line.toCharArray());
            scanner.resetTo(offset - lineInfo.getOffset(), lineInfo.getLength());
            int token = scanner.getNextToken();
            while (token != 158) {
                if (token == 5) {
                    int methodStart = scanner.getCurrentTokenStartPosition();
                    token = scanner.getNextToken();
                    if (token != 7) continue;
                    return StepIntoSelectionUtils.resolveMethod(lineInfo.getOffset() + methodStart, 0, (ICodeAssist)element);
                }
                token = scanner.getNextToken();
            }
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
        catch (InvalidInputException invalidInputException) {
            return null;
        }
        return null;
    }
}

