/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.internal.launching.remote.ui;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.rcptt.internal.launching.remote.ui.AUTArgumentsBlock;
import org.eclipse.rcptt.internal.launching.remote.ui.RemoteTabGroup;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.progress.WorkbenchJob;

public class RemoteAUTMainTab
extends AbstractLaunchConfigurationTab {
    private AUTArgumentsBlock fLocationBlock;
    private Job fRereshJob;
    private Job validateJob;

    public RemoteAUTMainTab(RemoteTabGroup group) {
        this.createLocationBlock();
    }

    protected Job createUpdateJob() {
        return new WorkbenchJob(this.getControl().getDisplay(), "Update LCD"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                if (!RemoteAUTMainTab.this.getControl().isDisposed()) {
                    RemoteAUTMainTab.this.updateLaunchConfigurationDialog();
                }
                return Status.OK_STATUS;
            }

            public boolean shouldRun() {
                return !RemoteAUTMainTab.this.getControl().isDisposed();
            }
        };
    }

    protected long getUpdateJobDelay() {
        return 200L;
    }

    private Job getUpdateJob() {
        if (this.fRereshJob == null) {
            this.fRereshJob = this.createUpdateJob();
            this.fRereshJob.setSystem(true);
        }
        return this.fRereshJob;
    }

    protected void scheduleUpdateJob() {
        Job job = this.getUpdateJob();
        job.cancel();
        job.schedule(this.getUpdateJobDelay());
    }

    protected void updateLaunchConfigurationDialog() {
        this.validateTab();
        super.updateLaunchConfigurationDialog();
    }

    private void createLocationBlock() {
        this.fLocationBlock = new AUTArgumentsBlock(this);
    }

    public void createControl(Composite parent) {
        final ScrolledComposite scrollContainer = new ScrolledComposite(parent, 512);
        scrollContainer.setLayoutData((Object)new GridData(768));
        Composite composite = new Composite((Composite)scrollContainer, 0);
        scrollContainer.setContent((Control)composite);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(768));
        this.fLocationBlock.createControl(composite);
        Listener listener = new Listener(){

            public void handleEvent(Event e) {
                Control child = (Control)e.widget;
                Rectangle bounds = child.getBounds();
                Rectangle area = scrollContainer.getClientArea();
                Point origin = scrollContainer.getOrigin();
                if (origin.x > bounds.x) {
                    origin.x = Math.max(0, bounds.x);
                }
                if (origin.y > bounds.y) {
                    origin.y = Math.max(0, bounds.y);
                }
                if (origin.x + area.width < bounds.x + bounds.width) {
                    origin.x = Math.max(0, bounds.x + bounds.width - area.width);
                }
                if (origin.y + area.height < bounds.y + bounds.height) {
                    origin.y = Math.max(0, bounds.y + bounds.height - area.height);
                }
                scrollContainer.setOrigin(origin);
            }
        };
        Control[] controls = composite.getChildren();
        int i = 0;
        while (i < controls.length) {
            controls[i].addListener(26, listener);
            ++i;
        }
        Dialog.applyDialogFont((Control)composite);
        composite.setSize(composite.computeSize(-1, -1));
        scrollContainer.setExpandHorizontal(true);
        this.setControl((Control)scrollContainer);
    }

    public void initializeFrom(ILaunchConfiguration config) {
        this.fLocationBlock.initializeFrom(config);
    }

    private Job validateJob() {
        if (this.validateJob == null) {
            this.validateJob = new Job("Connection validate job"){

                protected IStatus run(IProgressMonitor monitor) {
                    Control control;
                    RemoteAUTMainTab.this.setErrorMessage(null);
                    RemoteAUTMainTab.this.setMessage(null);
                    String msg = RemoteAUTMainTab.this.fLocationBlock.validate();
                    if (msg != null) {
                        RemoteAUTMainTab.this.setErrorMessage(msg);
                    }
                    if ((control = RemoteAUTMainTab.super.getControl()).isDisposed()) {
                        return Status.OK_STATUS;
                    }
                    control.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            RemoteAUTMainTab.this.updateLaunchConfigurationDialog();
                        }
                    });
                    return Status.OK_STATUS;
                }
            };
            this.validateJob.setSystem(true);
        }
        return this.validateJob;
    }

    public void validateTab() {
        this.validateJob().cancel();
        this.validateJob().schedule(500L);
    }

    public void performApply(ILaunchConfigurationWorkingCopy config) {
        this.fLocationBlock.performApply(config);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy config) {
        this.fLocationBlock.setDefaults(config);
    }

    public String getName() {
        return "Remote AUT Launch configuration";
    }
}

