/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.net;

import org.eclipse.core.internal.net.Messages;
import org.eclipse.core.internal.net.ProxyData;
import org.eclipse.core.internal.net.ProxyManager;
import org.eclipse.core.net.proxy.IProxyData;
import org.eclipse.core.net.proxy.IProxyService;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;

public class ProxySelector {
    private static final String DIRECT_PROVIDER = "Direct";
    private static final String ECLIPSE_PROVIDER = "Manual";
    private static final String NATIVE_PROVIDER = "Native";

    public static String[] getProviders() {
        return new String[]{DIRECT_PROVIDER, ECLIPSE_PROVIDER, NATIVE_PROVIDER};
    }

    public static String unlocalizeProvider(String name) {
        if (Messages.ProxySelector_0.equals(name)) {
            return DIRECT_PROVIDER;
        }
        if (Messages.ProxySelector_1.equals(name)) {
            return ECLIPSE_PROVIDER;
        }
        if (Messages.ProxySelector_2.equals(name)) {
            return NATIVE_PROVIDER;
        }
        Assert.isTrue((boolean)false);
        return null;
    }

    public static String localizeProvider(String name) {
        if (DIRECT_PROVIDER.equals(name)) {
            return Messages.ProxySelector_0;
        }
        if (ECLIPSE_PROVIDER.equals(name)) {
            return Messages.ProxySelector_1;
        }
        if (NATIVE_PROVIDER.equals(name)) {
            return Messages.ProxySelector_2;
        }
        Assert.isTrue((boolean)false);
        return null;
    }

    public static String getDefaultProvider() {
        IProxyService service = ProxyManager.getProxyManager();
        if (!service.isProxiesEnabled()) {
            return DIRECT_PROVIDER;
        }
        if (service.isProxiesEnabled() && !service.isSystemProxiesEnabled()) {
            return ECLIPSE_PROVIDER;
        }
        return NATIVE_PROVIDER;
    }

    public static void setActiveProvider(String provider) {
        IProxyService service = ProxyManager.getProxyManager();
        if (provider.equals(DIRECT_PROVIDER)) {
            service.setProxiesEnabled(false);
            service.setSystemProxiesEnabled(false);
        } else if (provider.equals(ECLIPSE_PROVIDER)) {
            service.setProxiesEnabled(true);
            service.setSystemProxiesEnabled(false);
        } else if (provider.equals(NATIVE_PROVIDER)) {
            service.setProxiesEnabled(true);
            service.setSystemProxiesEnabled(true);
        } else {
            throw new IllegalArgumentException("Provider not supported");
        }
    }

    public static ProxyData[] getProxyData(String provider) {
        ProxyManager manager = (ProxyManager)ProxyManager.getProxyManager();
        if (provider.equals(DIRECT_PROVIDER)) {
            return new ProxyData[0];
        }
        if (provider.equals(ECLIPSE_PROVIDER)) {
            return ProxySelector.castArray(manager.getProxyData());
        }
        if (provider.equals(NATIVE_PROVIDER)) {
            return ProxySelector.castArray(manager.getNativeProxyData());
        }
        throw new IllegalArgumentException("Provider not supported");
    }

    private static ProxyData[] castArray(IProxyData[] data) {
        ProxyData[] ret = new ProxyData[data.length];
        System.arraycopy(data, 0, ret, 0, data.length);
        return ret;
    }

    public static void setProxyData(String provider, ProxyData[] proxies) {
        if (provider.equals(ECLIPSE_PROVIDER)) {
            IProxyService service = ProxyManager.getProxyManager();
            try {
                service.setProxyData(proxies);
            }
            catch (CoreException e) {
                throw new RuntimeException(e);
            }
        } else {
            throw new IllegalArgumentException("Provider does not support setting proxy data");
        }
    }

    public static boolean canSetProxyData(String provider) {
        return provider.equals(ECLIPSE_PROVIDER);
    }

    public static String[] getBypassHosts(String provider) {
        ProxyManager manager = (ProxyManager)ProxyManager.getProxyManager();
        if (provider.equals(DIRECT_PROVIDER)) {
            return new String[0];
        }
        if (provider.equals(ECLIPSE_PROVIDER)) {
            return manager.getNonProxiedHosts();
        }
        if (provider.equals(NATIVE_PROVIDER)) {
            return manager.getNativeNonProxiedHosts();
        }
        throw new IllegalArgumentException("Provider not supported");
    }

    public static void setBypassHosts(String provider, String[] hosts) {
        if (provider.equals(ECLIPSE_PROVIDER)) {
            IProxyService service = ProxyManager.getProxyManager();
            try {
                service.setNonProxiedHosts(hosts);
            }
            catch (CoreException e) {
                throw new RuntimeException(e);
            }
        } else {
            throw new IllegalArgumentException("Provider does not support setting bypass hosts");
        }
    }

    public static boolean canSetBypassHosts(String provider) {
        return provider.equals(ECLIPSE_PROVIDER);
    }
}

