/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.commands.actions;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.IRequest;
import org.eclipse.debug.internal.core.commands.Request;
import org.eclipse.debug.internal.ui.DebugPluginImages;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.actions.ActionMessages;
import org.eclipse.debug.internal.ui.views.DebugUIViewsMessages;
import org.eclipse.debug.ui.actions.DebugCommandAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class TerminateAndRemoveAction
extends DebugCommandAction {
    private boolean fCanTerminate = false;
    private IWorkbenchPart fMyPart = null;
    static /* synthetic */ Class class$0;

    public String getText() {
        return ActionMessages.TerminateAndRemoveAction_0;
    }

    public String getHelpContextId() {
        return "org.eclipse.debug.ui.terminate_and_remove_action_context";
    }

    public String getId() {
        return "org.eclipse.debug.ui.debugview.popupMenu.terminateAndRemove";
    }

    public String getToolTipText() {
        return ActionMessages.TerminateAndRemoveAction_3;
    }

    public ImageDescriptor getDisabledImageDescriptor() {
        return DebugPluginImages.getImageDescriptor("IMG_DLCL_TERMINATE_AND_REMOVE");
    }

    public ImageDescriptor getHoverImageDescriptor() {
        return DebugPluginImages.getImageDescriptor("IMG_ELCL_TERMINATE_AND_REMOVE");
    }

    public ImageDescriptor getImageDescriptor() {
        return DebugPluginImages.getImageDescriptor("IMG_ELCL_TERMINATE_AND_REMOVE");
    }

    protected Class getCommandType() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.debug.core.commands.ITerminateHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }

    protected void postExecute(IRequest request, Object[] targets) {
        IStatus status = request.getStatus();
        if (status == null || status.isOK()) {
            int i = 0;
            while (i < targets.length) {
                ILaunch launch = DebugUIPlugin.getLaunch(targets[i]);
                if (launch != null) {
                    DebugPlugin.getDefault().getLaunchManager().removeLaunch(launch);
                }
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEnabled(boolean enabled) {
        TerminateAndRemoveAction terminateAndRemoveAction = this;
        synchronized (terminateAndRemoveAction) {
            this.fCanTerminate = enabled;
        }
        super.setEnabled(true);
    }

    public void runWithEvent(Event event) {
        if (this.fCanTerminate) {
            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            if (window != null && !MessageDialog.openQuestion((Shell)window.getShell(), (String)DebugUIViewsMessages.LaunchView_Terminate_and_Remove_1, (String)DebugUIViewsMessages.LaunchView_Terminate_and_remove_selected__2)) {
                return;
            }
            super.runWithEvent(event);
        } else {
            ISelection sel = null;
            sel = this.fMyPart != null ? this.getDebugContextService().getActiveContext(this.fMyPart.getSite().getId()) : this.getDebugContextService().getActiveContext();
            if (sel instanceof IStructuredSelection) {
                IStructuredSelection ss = (IStructuredSelection)sel;
                this.postExecute((IRequest)new Request(), ss.toArray());
            }
        }
    }

    public void init(IWorkbenchPart part) {
        super.init(part);
        this.fMyPart = part;
    }
}

