/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.op;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.egit.core.CoreText;
import org.eclipse.egit.core.EclipseGitProgressTransformer;
import org.eclipse.jgit.api.FetchCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.InvalidRemoteException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.FetchResult;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.TagOpt;
import org.eclipse.jgit.transport.URIish;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FetchOperation {
    private final Repository repository;
    private final RemoteConfig rc;
    private final URIish uri;
    private final int timeout;
    private final List<RefSpec> specs;
    private final boolean dryRun;
    private FetchResult operationResult;
    private CredentialsProvider credentialsProvider;
    private TagOpt tagOpt;

    public FetchOperation(Repository repository, URIish uri, List<RefSpec> refSpecs, int timeout, boolean dryRun) {
        this.repository = repository;
        this.timeout = timeout;
        this.dryRun = dryRun;
        this.uri = uri;
        this.specs = refSpecs;
        this.rc = null;
    }

    public FetchOperation(Repository repository, RemoteConfig config, int timeout, boolean dryRun) {
        this.repository = repository;
        this.timeout = timeout;
        this.dryRun = dryRun;
        this.uri = null;
        this.specs = null;
        this.rc = config;
    }

    public void setCredentialsProvider(CredentialsProvider credentialsProvider) {
        this.credentialsProvider = credentialsProvider;
    }

    public void setTagOpt(TagOpt tagOpt) {
        this.tagOpt = tagOpt;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException {
        if (this.operationResult != null) {
            throw new IllegalStateException(CoreText.OperationAlreadyExecuted);
        }
        IProgressMonitor actMonitor = monitor;
        if (actMonitor == null) {
            actMonitor = new NullProgressMonitor();
        }
        EclipseGitProgressTransformer gitMonitor = new EclipseGitProgressTransformer(actMonitor);
        FetchCommand command = this.rc == null ? new Git(this.repository).fetch().setRemote(this.uri.toPrivateString()).setRefSpecs(this.specs) : new Git(this.repository).fetch().setRemote(this.rc.getName());
        ((FetchCommand)((FetchCommand)command.setCredentialsProvider(this.credentialsProvider)).setTimeout(this.timeout)).setDryRun(this.dryRun).setProgressMonitor((ProgressMonitor)gitMonitor);
        if (this.tagOpt != null) {
            command.setTagOpt(this.tagOpt);
        }
        try {
            this.operationResult = command.call();
        }
        catch (JGitInternalException e) {
            throw new InvocationTargetException(e.getCause() != null ? e.getCause() : e);
        }
        catch (InvalidRemoteException e) {
            throw new InvocationTargetException(e);
        }
    }

    public FetchResult getOperationResult() {
        return this.operationResult;
    }
}

