/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.repository.tree.command;

import java.util.List;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.egit.core.op.RenameBranchOperation;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.UIText;
import org.eclipse.egit.ui.internal.ValidationUtils;
import org.eclipse.egit.ui.internal.repository.tree.RefNode;
import org.eclipse.egit.ui.internal.repository.tree.command.RepositoriesViewCommandHandler;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RenameBranchCommand
extends RepositoriesViewCommandHandler<RefNode> {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        String prefix;
        List nodes = this.getSelectedNodes(event);
        RefNode refNode = (RefNode)nodes.get(0);
        Shell shell = this.getShell(event);
        String oldName = ((Ref)refNode.getObject()).getName();
        if (oldName.startsWith("refs/heads/")) {
            prefix = "refs/heads/";
        } else if (oldName.startsWith("refs/remotes/")) {
            prefix = "refs/remotes/";
        } else {
            throw new ExecutionException(NLS.bind((String)UIText.RenameBranchCommand_WrongNameMessage, (Object)oldName));
        }
        Repository db = refNode.getRepository();
        IInputValidator inputValidator = ValidationUtils.getRefNameInputValidator(db, prefix, true);
        String defaultValue = Repository.shortenRefName((String)oldName);
        InputDialog newNameDialog = new InputDialog(shell, UIText.RepositoriesView_RenameBranchTitle, NLS.bind((String)UIText.RepositoriesView_RenameBranchMessage, (Object)defaultValue), defaultValue, inputValidator);
        if (newNameDialog.open() == 0) {
            try {
                String newName = newNameDialog.getValue();
                new RenameBranchOperation(db, (Ref)refNode.getObject(), newName).execute(null);
            }
            catch (CoreException e) {
                Activator.handleError(UIText.RepositoriesView_RenameBranchFailure, e, true);
            }
        }
        return null;
    }
}

