/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui;

import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.AbstractJavaElementLabelDecorator;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IDecoration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildpathIndicatorLabelDecorator
extends AbstractJavaElementLabelDecorator {
    @Override
    public void decorate(Object element, IDecoration decoration) {
        ImageDescriptor overlay = this.getOverlay(element);
        if (overlay != null) {
            decoration.addOverlay(overlay, 2);
        }
    }

    private ImageDescriptor getOverlay(Object element) {
        IJavaProject javaProject;
        IResource resource;
        IProject project;
        if (element instanceof IResource && (project = (resource = (IResource)element).getProject()) != null && (javaProject = JavaCore.create((IProject)project)) != null && javaProject.isOnClasspath(resource)) {
            IJavaElement javaElement = JavaCore.create((IResource)resource, (IJavaProject)javaProject);
            try {
                if (javaElement instanceof IPackageFragmentRoot && ((IPackageFragmentRoot)javaElement).getKind() != 1) {
                    return JavaPluginImages.DESC_OVR_LIBRARY;
                }
            }
            catch (JavaModelException javaModelException) {
                return null;
            }
        }
        return null;
    }

    @Override
    protected void processDelta(IJavaElementDelta delta, List<IJavaElement> result) {
        IJavaElement elem = delta.getElement();
        boolean isChanged = delta.getKind() == 4;
        boolean isRemoved = delta.getKind() == 2;
        int flags = delta.getFlags();
        switch (elem.getElementType()) {
            case 1: {
                this.processChildrenDelta(delta, result);
                return;
            }
            case 2: {
                if (isRemoved || isChanged && (flags & 0x400) != 0) {
                    return;
                }
                this.processChildrenDelta(delta, result);
                return;
            }
            case 3: {
                if (isRemoved) {
                    return;
                }
                try {
                    if (((flags & 0x80) != 0 || (flags & 0x40) != 0) && ((IPackageFragmentRoot)elem).getKind() != 1) {
                        result.add(elem);
                    }
                }
                catch (JavaModelException javaModelException) {}
                return;
            }
        }
    }
}

