/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ua.core.cheatsheet.comp;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.pde.internal.ua.core.cheatsheet.comp.CompCSTaskObject;
import org.eclipse.pde.internal.ua.core.icheatsheet.comp.ICompCSModel;
import org.eclipse.pde.internal.ua.core.icheatsheet.comp.ICompCSModelFactory;
import org.eclipse.pde.internal.ua.core.icheatsheet.comp.ICompCSObject;
import org.eclipse.pde.internal.ua.core.icheatsheet.comp.ICompCSTask;
import org.eclipse.pde.internal.ua.core.icheatsheet.comp.ICompCSTaskGroup;
import org.eclipse.pde.internal.ua.core.icheatsheet.comp.ICompCSTaskObject;
import org.w3c.dom.Element;

public class CompCSTaskGroup
extends CompCSTaskObject
implements ICompCSTaskGroup {
    private ArrayList fFieldTaskObjects;
    private static final long serialVersionUID = 1L;

    public CompCSTaskGroup(ICompCSModel model, ICompCSObject parent) {
        super(model, parent);
        this.reset();
    }

    public List getChildren() {
        ArrayList list = new ArrayList();
        if (this.fFieldTaskObjects.size() > 0) {
            list.addAll(this.fFieldTaskObjects);
        }
        return list;
    }

    public String getName() {
        return this.fFieldName;
    }

    public int getType() {
        return 1;
    }

    public void reset() {
        super.reset();
        this.fFieldTaskObjects = new ArrayList();
    }

    public void addFieldTaskObject(ICompCSTaskObject taskObject) {
        this.fFieldTaskObjects.add(taskObject);
        if (this.isEditable()) {
            this.fireStructureChanged((ICompCSObject)taskObject, 1);
        }
    }

    public void addFieldTaskObject(int index, ICompCSTaskObject taskObject) {
        if (index < 0) {
            return;
        }
        if (index >= this.fFieldTaskObjects.size()) {
            this.fFieldTaskObjects.add(taskObject);
        } else {
            this.fFieldTaskObjects.add(index, taskObject);
        }
        if (this.isEditable()) {
            this.fireStructureChanged((ICompCSObject)taskObject, 1);
        }
    }

    public int getFieldTaskObjectCount() {
        return this.fFieldTaskObjects.size();
    }

    public ICompCSTaskObject[] getFieldTaskObjects() {
        return this.fFieldTaskObjects.toArray(new ICompCSTaskObject[this.fFieldTaskObjects.size()]);
    }

    public boolean hasFieldTaskObjects() {
        return !this.fFieldTaskObjects.isEmpty();
    }

    public int indexOfFieldTaskObject(ICompCSTaskObject taskObject) {
        return this.fFieldTaskObjects.indexOf(taskObject);
    }

    public boolean isFirstFieldTaskObject(ICompCSTaskObject taskObject) {
        int position = this.fFieldTaskObjects.indexOf(taskObject);
        return position == 0;
    }

    public boolean isLastFieldTaskObject(ICompCSTaskObject taskObject) {
        int lastPosition;
        int position = this.fFieldTaskObjects.indexOf(taskObject);
        return position == (lastPosition = this.fFieldTaskObjects.size() - 1);
    }

    public void removeFieldTaskObject(ICompCSTaskObject taskObject) {
        this.fFieldTaskObjects.remove(taskObject);
        if (this.isEditable()) {
            this.fireStructureChanged((ICompCSObject)taskObject, 2);
        }
    }

    public void removeFieldTaskObject(int index) {
        if (index < 0 || index > this.fFieldTaskObjects.size() - 1) {
            return;
        }
        ICompCSTaskObject taskObject = (ICompCSTaskObject)this.fFieldTaskObjects.remove(index);
        if (this.isEditable()) {
            this.fireStructureChanged((ICompCSObject)taskObject, 2);
        }
    }

    protected void parseElement(Element element) {
        super.parseElement(element);
        String name = element.getNodeName();
        ICompCSModelFactory factory = this.getModel().getFactory();
        if (name.equals("task")) {
            ICompCSTask task = factory.createCompCSTask(this);
            this.fFieldTaskObjects.add(task);
            task.parse(element);
        } else if (name.equals("taskGroup")) {
            ICompCSTaskGroup taskGroup = factory.createCompCSTaskGroup(this);
            this.fFieldTaskObjects.add(taskGroup);
            taskGroup.parse(element);
        }
    }

    protected void writeElements(String indent, PrintWriter writer) {
        super.writeElements(indent, writer);
        String newIndent = String.valueOf(indent) + "   ";
        Iterator iterator = this.fFieldTaskObjects.iterator();
        while (iterator.hasNext()) {
            ICompCSTaskObject taskObject = (ICompCSTaskObject)iterator.next();
            taskObject.write(newIndent, writer);
        }
    }

    public String getElement() {
        return "taskGroup";
    }

    public ICompCSTaskObject getNextSibling(ICompCSTaskObject taskObject) {
        int position = this.fFieldTaskObjects.indexOf(taskObject);
        int lastIndex = this.fFieldTaskObjects.size() - 1;
        if (position == -1 || position == lastIndex) {
            return null;
        }
        return (ICompCSTaskObject)this.fFieldTaskObjects.get(position + 1);
    }

    public ICompCSTaskObject getPreviousSibling(ICompCSTaskObject taskObject) {
        int position = this.fFieldTaskObjects.indexOf(taskObject);
        if (position == -1 || position == 0) {
            return null;
        }
        return (ICompCSTaskObject)this.fFieldTaskObjects.get(position - 1);
    }

    public void moveFieldTaskObject(ICompCSTaskObject taskObject, int newRelativeIndex) {
        int currentIndex = this.indexOfFieldTaskObject(taskObject);
        if (currentIndex == -1) {
            return;
        }
        int newIndex = newRelativeIndex + currentIndex;
        if (newIndex < 0 || newIndex >= this.fFieldTaskObjects.size()) {
            return;
        }
        this.fFieldTaskObjects.remove(taskObject);
        this.fFieldTaskObjects.add(newIndex, taskObject);
        if (this.isEditable()) {
            this.fireStructureChanged((ICompCSObject)taskObject, 1);
        }
    }
}

