/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ctx.preferences.ui.wizard;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Collection;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IExportedPreferences;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.rcptt.core.scenario.Context;
import org.eclipse.rcptt.ctx.preferences.ui.PreferencesContextEditor;
import org.eclipse.rcptt.internal.preferences.PrefUtils;
import org.eclipse.rcptt.internal.ui.Q7UIPlugin;
import org.eclipse.rcptt.preferences.PrefNode;
import org.eclipse.rcptt.preferences.PreferencesContext;
import org.eclipse.rcptt.preferences.PreferencesFactory;
import org.eclipse.rcptt.ui.editors.IQ7Editor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class AddWizardPreferencesPage
extends WizardPage
implements Listener {
    private Text addContentField;
    private String currentMessage;

    public AddWizardPreferencesPage() {
        super("preferencesImportPage");
        this.setTitle("Add Preferences");
        this.setDescription("Add preferences.");
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(272));
        this.createDestinationComposite(composite);
        this.updatePageCompletion();
        this.setControl((Control)composite);
        this.addContentField.setFocus();
        Dialog.applyDialogFont((Control)composite);
    }

    private void createDestinationComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        Label dest = new Label(composite, 0);
        dest.setText("Preferences to add:");
        this.addContentField = new Text(composite, 2050);
        this.addContentField.addListener(24, (Listener)this);
        this.addContentField.addListener(13, (Listener)this);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.addContentField);
        Label l = new Label(composite, 64);
        l.setText("Plase use following syntax (same as Eclipse Preferences export format):\n/instance/plugin.name/key=value\n/configuration/plugin.name/L9ServerURL=value");
    }

    public boolean finish(IQ7Editor<Context> contextEditor) {
        IPreferencesService service = Platform.getPreferencesService();
        try {
            String text = this.addContentField.getText();
            if (!text.contains("file_export_version=3.0")) {
                text = String.valueOf(text) + "\n" + "file_export_version=3.0";
            }
            IExportedPreferences prefs = service.readPreferences((InputStream)new ByteArrayInputStream(text.getBytes()));
            PrefNode prefNode = PrefUtils.convertPreferences((Preferences)prefs);
            PreferencesContext context = PreferencesFactory.eINSTANCE.createPreferencesContext();
            if (prefNode != null) {
                context.getContent().addAll((Collection)prefNode.getChilds());
            }
            ((PreferencesContextEditor)contextEditor).addContext(context);
        }
        catch (CoreException e) {
            Q7UIPlugin.log((String)e.getMessage(), (Throwable)e);
        }
        catch (BackingStoreException e) {
            Q7UIPlugin.log((String)e.getMessage(), (Throwable)e);
        }
        return true;
    }

    public void handleEvent(Event e) {
        this.updatePageCompletion();
    }

    private boolean isValidToFinish() {
        return this.addContentField.getText().trim().length() > 0;
    }

    private void updatePageCompletion() {
        boolean pageComplete = this.determinePageCompletion();
        this.setPageComplete(pageComplete);
        if (pageComplete) {
            this.setMessage(null);
        }
    }

    private boolean determinePageCompletion() {
        if (this.isValidToFinish()) {
            this.setErrorMessage(null);
            return true;
        }
        this.setErrorMessage(this.currentMessage);
        return false;
    }
}

