/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.internal.launching;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.rcptt.core.ecl.core.model.ExecutionPhase;
import org.eclipse.rcptt.internal.core.RcpttPlugin;
import org.eclipse.rcptt.internal.launching.Q7LaunchingPlugin;
import org.eclipse.rcptt.internal.launching.aut.ConsoleOutputListener;
import org.eclipse.rcptt.launching.IExecutable;
import org.eclipse.rcptt.sherlock.core.model.sherlock.report.Report;

public abstract class Executable
implements IExecutable {
    protected static final Executable[] EMPTY = new Executable[0];
    private static final IStatus cancelledForPreviousFailures = new Status(8, "org.eclipse.rcptt.launching", "Execution was canceled due to previous failures");
    protected Listener.Composite listeners = new Listener.Composite();
    private final ConsoleOutputListener consoleListener = new ConsoleOutputListener();
    private final boolean debug;
    private final boolean collectLog;
    private volatile IStatus result;
    private IExecutable.State state = IExecutable.State.WAITING;
    private long time;
    private final ExecutionPhase phase;

    public abstract Executable[] getChildren();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setResult(IStatus result) {
        boolean changed = false;
        Executable executable = this;
        synchronized (executable) {
            if (this.result == null) {
                this.result = result;
                changed = true;
                this.state = IExecutable.State.COMPLETED;
            }
        }
        if (changed) {
            this.listeners.onStatusChange(this);
        }
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(Listener listener) {
        this.listeners.remove(listener);
    }

    final void executeAndRememberResult() throws InterruptedException {
        if (this.state != IExecutable.State.WAITING) {
            throw new IllegalStateException("Can't start in " + (Object)((Object)this.state) + " state");
        }
        if (this.collectLog) {
            this.consoleListener.startLogging(this.getAut());
        }
        this.state = IExecutable.State.RUNNING;
        long startTime = System.currentTimeMillis();
        IStatus localResult = null;
        try {
            try {
                this.startLaunching();
                this.listeners.onStatusChange(this);
                localResult = this.execute();
                Preconditions.checkNotNull((Object)localResult);
                Executable[] executableArray = this.getChildren();
                int n = executableArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Executable child = executableArray[n2];
                    if (this.result != null) {
                        localResult = this.result;
                    }
                    if (!localResult.isOK()) {
                        child.cancel(cancelledForPreviousFailures);
                    } else {
                        child.addListener(this.listeners);
                        try {
                            child.executeAndRememberResult();
                            IStatus rv = this.handleChildResult(child.getResultStatus());
                            if (!rv.isOK()) {
                                localResult = rv;
                            }
                        }
                        finally {
                            child.removeListener(this.listeners);
                        }
                    }
                    ++n2;
                }
            }
            catch (InterruptedException e) {
                localResult = RcpttPlugin.createStatus((String)"Execution was unexpectedly terminated", (Throwable)e);
                throw e;
            }
            catch (Throwable e) {
                localResult = Q7LaunchingPlugin.createStatus(e);
                this.time = System.currentTimeMillis() - startTime;
                try {
                    Preconditions.checkNotNull((Object)localResult);
                    try {
                        localResult = this.postExecute(localResult);
                    }
                    catch (Throwable e2) {
                        localResult = Q7LaunchingPlugin.createStatus(e2);
                    }
                }
                finally {
                    this.setResult(localResult);
                }
                this.consoleListener.stopLogging();
            }
        }
        finally {
            this.time = System.currentTimeMillis() - startTime;
            try {
                Preconditions.checkNotNull((Object)localResult);
                try {
                    localResult = this.postExecute(localResult);
                }
                catch (Throwable e) {
                    localResult = Q7LaunchingPlugin.createStatus(e);
                }
            }
            finally {
                this.setResult(localResult);
            }
            this.consoleListener.stopLogging();
        }
    }

    public void cancel(IStatus status) {
        this.setResult(status);
        Executable[] executableArray = this.getChildren();
        int n = executableArray.length;
        int n2 = 0;
        while (n2 < n) {
            Executable child = executableArray[n2];
            child.addListener(this.listeners);
            try {
                child.cancel(status);
            }
            finally {
                child.removeListener(this.listeners);
            }
            ++n2;
        }
    }

    protected IStatus handleChildResult(IStatus resultStatus) {
        return resultStatus;
    }

    protected abstract IStatus execute() throws InterruptedException;

    protected Executable(boolean debug) {
        this(debug, ExecutionPhase.AUTO, false);
    }

    protected Executable(boolean debug, ExecutionPhase phase, boolean collectLog) {
        this.debug = debug;
        this.phase = phase;
        this.collectLog = collectLog;
    }

    @Override
    public boolean isDebug() {
        return this.debug;
    }

    public void dispose() {
        this.cancel((IStatus)new Status(4, "org.eclipse.rcptt.launching", "Disposed"));
        Executable[] childs = this.getChildren();
        if (childs != null) {
            Executable[] executableArray = childs;
            int n = childs.length;
            int n2 = 0;
            while (n2 < n) {
                Executable child = executableArray[n2];
                child.dispose();
                ++n2;
            }
        }
    }

    protected IStatus postExecute(IStatus result) {
        return result;
    }

    @Override
    public Report getResultReport() {
        return null;
    }

    @Override
    public String getId() {
        return null;
    }

    @Override
    public ExecutionPhase getPhase() {
        return this.phase;
    }

    public static IExecutable.State max(IExecutable.State a, IExecutable.State b) {
        return a.ordinal() >= b.ordinal() ? a : b;
    }

    public void startLaunching() {
    }

    @Override
    public final IExecutable.State getStatus() {
        IExecutable.State status = this.state;
        Executable[] executableArray = this.getChildren();
        int n = executableArray.length;
        int n2 = 0;
        while (n2 < n) {
            Executable child = executableArray[n2];
            status = Executable.max(status, child.getStatus());
            ++n2;
        }
        return status;
    }

    @Override
    public final synchronized IStatus getResultStatus() {
        IStatus localResult = this.result;
        Preconditions.checkState((localResult != null || this.state != IExecutable.State.COMPLETED ? 1 : 0) != 0, (Object)"Result should always be set in COMPLETED state");
        if (localResult != null) {
            return localResult;
        }
        return Status.OK_STATUS;
    }

    @Override
    public long getTime() {
        return this.time;
    }

    public String getLog() {
        Preconditions.checkState((boolean)this.collectLog);
        return this.consoleListener.getLog();
    }

    public static interface Listener {
        public void onStatusChange(Executable var1);

        public void updateSessionCounters(Executable var1, IStatus var2);

        public static class Adapter
        implements Listener {
            @Override
            public void onStatusChange(Executable executable) {
            }

            @Override
            public void updateSessionCounters(Executable executable, IStatus status) {
            }
        }

        public static class Composite
        implements Listener {
            private List<Listener> listeners = Collections.synchronizedList(new ArrayList(2));

            public void add(Listener listener) {
                this.listeners.add(listener);
            }

            public void remove(Listener listener) {
                this.listeners.remove(listener);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private Listener[] copy() {
                List<Listener> list = this.listeners;
                synchronized (list) {
                    return (Listener[])Iterables.toArray(this.listeners, Listener.class);
                }
            }

            @Override
            public void onStatusChange(Executable executable) {
                Listener[] listenerArray = this.copy();
                int n = listenerArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Listener listener = listenerArray[n2];
                    listener.onStatusChange(executable);
                    ++n2;
                }
            }

            @Override
            public void updateSessionCounters(Executable executable, IStatus status) {
                Listener[] listenerArray = this.copy();
                int n = listenerArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Listener listener = listenerArray[n2];
                    listener.updateSessionCounters(executable, status);
                    ++n2;
                }
            }
        }
    }
}

