/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.internal.launching;

import com.google.common.base.Preconditions;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.rcptt.internal.launching.Executable;
import org.eclipse.rcptt.internal.launching.PrepareExecutionWrapper;
import org.eclipse.rcptt.internal.launching.Q7LaunchingPlugin;
import org.eclipse.rcptt.internal.launching.Q7TestLaunch;
import org.eclipse.rcptt.internal.launching.TestSuiteExecutable;
import org.eclipse.rcptt.launching.AutLaunch;
import org.eclipse.rcptt.launching.IExecutionSession;
import org.eclipse.rcptt.reporting.internal.Q7ReportingPlugin;
import org.eclipse.rcptt.sherlock.core.streams.SherlockReportSession;

public class ExecutionSession
implements IExecutionSession {
    private final String name;
    private final Executable[] executables;
    private Date startTime;
    private final ListenerList listeners = new ListenerList();
    private Executable executable;
    private int finishedCount;
    private int failedCount;
    private Date endTime;
    private final SherlockReportSession reportSession;
    private Q7TestLaunch launch;
    private final int testCasesCount;
    private AutLaunch aut;
    private volatile IStatus result = null;

    public ExecutionSession(String name, Executable[] executables, AutLaunch aut) {
        Executable[] testCases;
        this.name = name;
        this.executables = executables;
        this.aut = aut;
        String reportID = Q7ReportingPlugin.getID((String)name);
        File reportRoot = Q7LaunchingPlugin.getExecutionSessionRoot(reportID, this);
        this.reportSession = new SherlockReportSession(reportRoot);
        Executable[] executableArray = testCases = this.getTestCases();
        int n = testCases.length;
        int n2 = 0;
        while (n2 < n) {
            Executable executable = executableArray[n2];
            if (executable instanceof PrepareExecutionWrapper) {
                ((PrepareExecutionWrapper)executable).setReportSession(this.reportSession);
            }
            ++n2;
        }
        this.testCasesCount = testCases.length;
    }

    @Override
    public void setLaunch(Q7TestLaunch q7TestLaunch) {
        this.launch = q7TestLaunch;
    }

    @Override
    public Q7TestLaunch getLaunch() {
        return this.launch;
    }

    public SherlockReportSession getReportSession() {
        return this.reportSession;
    }

    public Executable[] getExecutables() {
        return this.executables;
    }

    public Executable[] getTestCases() {
        List<Executable> result = this.internalGetTestCases(this.executables);
        return result.toArray(new Executable[result.size()]);
    }

    private List<Executable> internalGetTestCases(Executable[] parents) {
        ArrayList<Executable> result = new ArrayList<Executable>();
        Executable[] executableArray = parents;
        int n = parents.length;
        int n2 = 0;
        while (n2 < n) {
            Executable executable = executableArray[n2];
            if (executable instanceof PrepareExecutionWrapper) {
                result.add(executable);
            } else if (executable instanceof TestSuiteExecutable) {
                result.addAll(this.internalGetTestCases(((TestSuiteExecutable)executable).getChildren()));
            }
            ++n2;
        }
        return result;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void addListener(IExecutionSession.IExecutionSessionListener listener) {
        this.listeners.add((Object)listener);
    }

    @Override
    public void removeListener(IExecutionSession.IExecutionSessionListener listener) {
        this.listeners.remove((Object)listener);
    }

    public synchronized void setActive(Executable executable) {
        this.executable = executable;
    }

    public synchronized Executable getActive() {
        return this.executable;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    @Override
    public Date getStartTime() {
        return this.startTime;
    }

    @Override
    public boolean isRunning() {
        return this.result == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(IStatus result) {
        Object o;
        Preconditions.checkNotNull((Object)result);
        ExecutionSession executionSession = this;
        synchronized (executionSession) {
            if (this.result == null) {
                this.result = result;
            }
            result = this.result;
        }
        Object[] objectArray = this.executables;
        int n = this.executables.length;
        int n2 = 0;
        while (n2 < n) {
            Executable ex = objectArray[n2];
            ex.cancel(result);
            ++n2;
        }
        objectArray = this.listeners.getListeners();
        n = objectArray.length;
        n2 = 0;
        while (n2 < n) {
            o = objectArray[n2];
            ((IExecutionSession.IExecutionSessionListener)o).executionFinished();
            ++n2;
        }
        if (this.launch != null) {
            this.launch.setSession(null);
        }
        this.aut = null;
        objectArray = this.listeners.getListeners();
        n = objectArray.length;
        n2 = 0;
        while (n2 < n) {
            o = objectArray[n2];
            ((IExecutionSession.IExecutionSessionListener)o).statisticsUpdate();
            ++n2;
        }
    }

    @Override
    public int getFailedCount() {
        return this.failedCount;
    }

    @Override
    public int getStoppedCount() {
        int count = 0;
        Executable[] executableArray = this.executables;
        int n = this.executables.length;
        int n2 = 0;
        while (n2 < n) {
            Executable executable = executableArray[n2];
            if (executable.getResultStatus().matches(8)) {
                ++count;
            }
            ++n2;
        }
        return count;
    }

    @Override
    public int getFinishedCount() {
        return this.finishedCount;
    }

    @Override
    public int getTotalCount() {
        return this.testCasesCount;
    }

    public void resetCounters() {
        this.finishedCount = 0;
        this.failedCount = 0;
        Object[] objectArray = this.listeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            ((IExecutionSession.IExecutionSessionListener)o).statisticsUpdate();
            ++n2;
        }
    }

    public void oneFailed() {
        ++this.finishedCount;
        ++this.failedCount;
        Object[] objectArray = this.listeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            ((IExecutionSession.IExecutionSessionListener)o).statisticsUpdate();
            ++n2;
        }
    }

    public void oneFinished() {
        ++this.finishedCount;
        Object[] objectArray = this.listeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            ((IExecutionSession.IExecutionSessionListener)o).statisticsUpdate();
            ++n2;
        }
    }

    @Override
    public long getTotalTime() {
        long total = 0L;
        Executable[] executableArray = this.executables;
        int n = this.executables.length;
        int n2 = 0;
        while (n2 < n) {
            Executable executable = executableArray[n2];
            total += executable.getTime();
            ++n2;
        }
        return total;
    }

    public void dispose() {
        if (this.launch != null) {
            this.launch.setSession(null);
        }
        if (this.executable != null) {
            this.executable.dispose();
        }
        if (this.executables != null) {
            Executable[] executableArray = this.executables;
            int n = this.executables.length;
            int n2 = 0;
            while (n2 < n) {
                Executable executable = executableArray[n2];
                executable.dispose();
                ++n2;
            }
        }
        if (this.reportSession != null) {
            this.reportSession.dispose();
        }
        this.aut = null;
    }

    public void setEndTime(Date date) {
        this.endTime = date;
    }

    @Override
    public Date getEndTime() {
        return this.endTime;
    }

    public boolean isDebugging(AutLaunch aut) {
        return this.isRunning() && aut.equals(this.aut);
    }

    @Override
    public IStatus getResultStatus() {
        return this.result;
    }
}

