/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.internal.launching.reporting;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.rcptt.core.ecl.core.model.BeginReportNode;
import org.eclipse.rcptt.core.ecl.core.model.EndReportNode;
import org.eclipse.rcptt.core.ecl.core.model.Q7CoreFactory;
import org.eclipse.rcptt.ecl.core.Command;
import org.eclipse.rcptt.ecl.core.ProcessStatus;
import org.eclipse.rcptt.ecl.internal.core.ProcessStatusConverter;
import org.eclipse.rcptt.internal.core.RcpttPlugin;
import org.eclipse.rcptt.launching.AutLaunch;
import org.eclipse.rcptt.launching.IExecutable;
import org.eclipse.rcptt.launching.IExecutionSession;
import org.eclipse.rcptt.reporting.ItemKind;
import org.eclipse.rcptt.reporting.Q7Info;
import org.eclipse.rcptt.reporting.core.IQ7ReportConstants;
import org.eclipse.rcptt.reporting.core.ReportHelper;
import org.eclipse.rcptt.sherlock.core.model.sherlock.report.Node;
import org.eclipse.rcptt.sherlock.core.model.sherlock.report.Report;
import org.eclipse.rcptt.sherlock.core.model.sherlock.report.ReportFactory;
import org.eclipse.rcptt.sherlock.core.streams.SherlockReportOutputStream;

public class ReportMaker
implements IQ7ReportConstants {
    private final SherlockReportOutputStream stream;

    public static void beginReportNode(String node, Map<String, EObject> properties, AutLaunch launch) throws CoreException, InterruptedException {
        BeginReportNode reportNode = Q7CoreFactory.eINSTANCE.createBeginReportNode();
        reportNode.setName(node);
        if (properties != null) {
            Q7Info info = (Q7Info)properties.get("q7");
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)info.getId()) ? 1 : 0) != 0, (Object)"Id can't be empty");
            Preconditions.checkArgument((info.getResult() == null ? 1 : 0) != 0, (Object)"Can't create report with a preset  result");
            reportNode.getProperties().putAll(properties);
        }
        launch.execute((Command)reportNode);
    }

    public static void endReportNode(boolean takeSnaphots, AutLaunch launch, IStatus result) throws CoreException {
        ReportMaker.endReportNode(takeSnaphots, launch, ProcessStatusConverter.toProcessStatus((IStatus)result));
    }

    public static void endReportNode(boolean takeSnaphots, AutLaunch launch, ProcessStatus result) throws CoreException {
        EndReportNode reportNode = Q7CoreFactory.eINSTANCE.createEndReportNode();
        reportNode.setTakeSnaphots(takeSnaphots);
        reportNode.setResult(result);
        try {
            launch.execute((Command)reportNode);
        }
        catch (InterruptedException e) {
            RcpttPlugin.log((Throwable)e);
        }
    }

    public ReportMaker(SherlockReportOutputStream out) {
        this.stream = out;
    }

    public void make(IExecutionSession session, IProgressMonitor monitor) {
        IExecutable[] executables = session.getTestCases();
        monitor.beginTask("Prepare RCPTT report", executables.length + 50);
        IExecutable[] iExecutableArray = executables;
        int n = executables.length;
        int n2 = 0;
        while (n2 < n) {
            IExecutable iExecutable = iExecutableArray[n2];
            Report report = iExecutable.getResultReport();
            if (report == null) {
                report = ReportFactory.eINSTANCE.createReport();
                report.setRoot(this.minimalReport(iExecutable));
                this.stream.write(report);
            } else {
                this.stream.write((Report)EcoreUtil.copy((EObject)report));
            }
            monitor.worked(1);
            ++n2;
        }
        monitor.done();
    }

    private void setProperties(IExecutable iExecutable, Q7Info info) {
        switch (iExecutable.getType()) {
            case 1: {
                info.setType(ItemKind.CONTEXT);
                break;
            }
            case 3: {
                info.setType(ItemKind.VERIFICATION);
                break;
            }
            case 0: {
                info.setType(ItemKind.SCRIPT);
            }
        }
        info.setResult(ProcessStatusConverter.toProcessStatus((IStatus)iExecutable.getResultStatus()));
    }

    private Node minimalReport(IExecutable iExecutable) {
        Report report = iExecutable.getResultReport();
        if (report != null) {
            assert (ReportHelper.getInfo((Node)report.getRoot()).getId() != null);
            return (Node)EcoreUtil.copy((EObject)report.getRoot());
        }
        Node nde = ReportFactory.eINSTANCE.createNode();
        nde.setName(iExecutable.getName());
        nde.setStartTime(0L);
        nde.setEndTime(iExecutable.getTime());
        Q7Info info = ReportHelper.getInfo((Node)nde);
        this.setProperties(iExecutable, info);
        assert (info.getType() != null);
        IExecutable[] iExecutableArray = iExecutable.getChildren();
        int n = iExecutableArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExecutable iExecutable2 = iExecutableArray[n2];
            nde.getChildren().add((Object)this.minimalReport(iExecutable2));
            ++n2;
        }
        return nde;
    }
}

