/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.report.internal;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.Iterator;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.rcptt.ecl.internal.core.EMFConverterManager;
import org.eclipse.rcptt.internal.ui.Images;
import org.eclipse.rcptt.reporting.Q7Info;
import org.eclipse.rcptt.reporting.core.Q7ReportIterator;
import org.eclipse.rcptt.reporting.internal.Q7ReportingPlugin;
import org.eclipse.rcptt.sherlock.core.model.sherlock.report.Node;
import org.eclipse.rcptt.sherlock.core.model.sherlock.report.Report;
import org.eclipse.rcptt.ui.report.Q7UIReportPlugin;
import org.eclipse.rcptt.ui.report.internal.ReportInformationPage;
import org.eclipse.rcptt.ui.report.internal.ReportPage;
import org.eclipse.rcptt.util.FileUtil;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.IURIEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.IFormPage;

public class RcpttReportEditor
extends FormEditor {
    private final WritableValue reportListObservable = new WritableValue(null, Q7ReportIterator.class);
    private String initialWorkspaceLocation;

    protected void addPages() {
        try {
            this.addPage((IFormPage)new ReportInformationPage(this, (IObservableValue)this.reportListObservable, "rcptt.report.info.page", "General"));
        }
        catch (PartInitException e) {
            Q7UIReportPlugin.log(e);
        }
    }

    protected void setInput(IEditorInput input) {
        super.setInput(input);
        IPath path = Q7ReportingPlugin.getDefault().getStateLocation().append("temporary");
        path.toFile().mkdirs();
        File reportFile = path.append("report_" + System.currentTimeMillis()).toFile();
        while (reportFile.exists()) {
            reportFile = path.append("report_" + System.currentTimeMillis()).toFile();
        }
        if (input instanceof IStorageEditorInput) {
            try {
                InputStream source = ((IStorageEditorInput)input).getStorage().getContents();
                FileUtil.copy((InputStream)new BufferedInputStream(source), (OutputStream)new BufferedOutputStream(new FileOutputStream(reportFile)));
            }
            catch (Throwable e) {
                Q7UIReportPlugin.log(e);
            }
        }
        if (input instanceof IURIEditorInput) {
            URI uri = ((IURIEditorInput)input).getURI();
            try {
                InputStream stream = uri.toURL().openStream();
                FileUtil.copy((InputStream)new BufferedInputStream(stream), (OutputStream)new BufferedOutputStream(new FileOutputStream(reportFile)));
            }
            catch (Exception e) {
                Q7UIReportPlugin.log(e);
            }
        }
        if (input instanceof IFileEditorInput) {
            this.initialWorkspaceLocation = ((IFileEditorInput)input).getFile().getFullPath().removeLastSegments(1).toString();
        }
        this.closeList();
        this.reportListObservable.setValue((Object)new Q7ReportIterator(reportFile));
        this.setPartName(new Path(input.getName()).removeFileExtension().toString());
    }

    private void closeList() {
        final Q7ReportIterator reportList = (Q7ReportIterator)this.reportListObservable.getValue();
        this.reportListObservable.setValue(null);
        if (reportList != null) {
            new Job("Closing report file"){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                protected IStatus run(IProgressMonitor monitor) {
                    Q7ReportIterator q7ReportIterator = reportList;
                    synchronized (q7ReportIterator) {
                        reportList.close();
                    }
                    return Status.OK_STATUS;
                }
            };
        }
    }

    public String getInitialWorkspaceLocation() {
        return this.initialWorkspaceLocation;
    }

    public void dispose() {
        this.closeList();
        this.reportListObservable.dispose();
        super.dispose();
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void openReport(final String id, final String title) {
        final ProgressMonitorDialog dialog = new ProgressMonitorDialog(this.getSite().getShell());
        try {
            final Q7ReportIterator reportList = (Q7ReportIterator)this.reportListObservable.getValue();
            if (reportList == null) {
                return;
            }
            dialog.run(true, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    monitor.beginTask("Opening report...", -1);
                    Iterator iterator = reportList.iterator();
                    while (iterator.hasNext()) {
                        monitor.worked(1);
                        final Report next = (Report)iterator.next();
                        Node root = next.getRoot();
                        EMap properties = root.getProperties();
                        final Q7Info info = (Q7Info)properties.get((Object)"q7");
                        if (info == null || !info.getId().equals(id)) continue;
                        dialog.getShell().getDisplay().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                RcpttReportEditor.this.openReportPage(id, title, next, info);
                            }
                        });
                        return;
                    }
                    monitor.done();
                }
            });
        }
        catch (Throwable e) {
            Q7UIReportPlugin.log(e);
        }
    }

    private void openReportPage(String id, String title, Report next, Q7Info info) {
        String pageId = "report:" + id;
        IFormPage existingPage = this.findPage(pageId);
        if (existingPage != null) {
            this.setActivePage(pageId);
            return;
        }
        ReportPage page = new ReportPage(this, pageId, title, next);
        try {
            int item = this.addPage((IFormPage)page);
            if (this.getContainer() instanceof CTabFolder) {
                IStatus status;
                CTabItem tabItem = ((CTabFolder)this.getContainer()).getItem(item);
                tabItem.setShowClose(true);
                try {
                    status = (IStatus)EMFConverterManager.INSTANCE.fromEObject((EObject)info.getResult());
                }
                catch (ClassCastException e) {
                    status = new Status(4, "org.eclipse.rcptt.ui.report", "Invalid test result", (Throwable)e);
                }
                catch (CoreException e) {
                    status = e.getStatus();
                }
                if (status.isOK()) {
                    tabItem.setImage(Images.getImageDescriptor((String)"icons/launching/testok.gif").createImage());
                } else if (status.matches(4)) {
                    tabItem.setImage(Images.getImageDescriptor((String)"icons/launching/testerr.gif").createImage());
                } else {
                    tabItem.setImage(Images.getImageDescriptor((String)"icons/scenario.gif").createImage());
                }
            }
            this.setActivePage(item);
        }
        catch (PartInitException e) {
            Q7UIReportPlugin.log(e);
        }
    }
}

