/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.tesla.recording.core.swt;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewerEditor;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.rcptt.tesla.core.protocol.BasicUIElement;
import org.eclipse.rcptt.tesla.core.protocol.CompositeUIElement;
import org.eclipse.rcptt.tesla.core.protocol.ControlUIElement;
import org.eclipse.rcptt.tesla.core.protocol.ElementKind;
import org.eclipse.rcptt.tesla.core.protocol.GenericElementKind;
import org.eclipse.rcptt.tesla.core.protocol.IUIPlayer;
import org.eclipse.rcptt.tesla.core.protocol.ItemUIElement;
import org.eclipse.rcptt.tesla.core.protocol.PartUIElement;
import org.eclipse.rcptt.tesla.core.protocol.UIPlayer;
import org.eclipse.rcptt.tesla.core.protocol.UISelector;
import org.eclipse.rcptt.tesla.core.protocol.ViewerUIElement;
import org.eclipse.rcptt.tesla.core.protocol.WindowUIElement;
import org.eclipse.rcptt.tesla.core.protocol.raw.Element;
import org.eclipse.rcptt.tesla.internal.core.TeslaCore;
import org.eclipse.rcptt.tesla.internal.ui.player.FindResult;
import org.eclipse.rcptt.tesla.internal.ui.player.PlayerTextUtils;
import org.eclipse.rcptt.tesla.internal.ui.player.PlayerWrapUtils;
import org.eclipse.rcptt.tesla.internal.ui.player.SWTModelMapper;
import org.eclipse.rcptt.tesla.internal.ui.player.SWTUIElement;
import org.eclipse.rcptt.tesla.internal.ui.player.SWTUIPlayer;
import org.eclipse.rcptt.tesla.internal.ui.player.TeslaSWTAccess;
import org.eclipse.rcptt.tesla.internal.ui.player.WorkbenchUIElement;
import org.eclipse.rcptt.tesla.internal.ui.player.viewers.Viewers;
import org.eclipse.rcptt.tesla.recording.aspects.SWTEventManager;
import org.eclipse.rcptt.tesla.recording.core.TeslaRecorder;
import org.eclipse.rcptt.tesla.recording.core.swt.BasicRecordingHelper;
import org.eclipse.rcptt.tesla.recording.core.swt.EclipseFormsSupport;
import org.eclipse.rcptt.tesla.recording.core.swt.ICanvasDiagramHelper;
import org.eclipse.rcptt.tesla.recording.core.swt.IWidgetLocatorExtension;
import org.eclipse.rcptt.tesla.recording.core.swt.SWTRecordingHelper;
import org.eclipse.rcptt.tesla.swt.util.GetWindowUtil;
import org.eclipse.rcptt.tesla.swt.util.IndexUtil;
import org.eclipse.rcptt.tesla.swt.workbench.EclipseWorkbenchProvider;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.ControlEditor;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.custom.TreeEditor;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.CoolBar;
import org.eclipse.swt.widgets.CoolItem;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.PartSite;
import org.eclipse.ui.internal.PerspectiveBarContributionItem;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.internal.WorkbenchPartReference;
import org.eclipse.ui.part.WorkbenchPart;

public final class SWTWidgetLocator {
    private static final String ELEMENT_TEXT = "element_text";
    private static final String ATTR_TEXT = "text";
    private final SWTUIPlayer player;
    private TeslaRecorder recorder;
    List<IWidgetLocatorExtension> extensions = new ArrayList<IWidgetLocatorExtension>();

    public synchronized void initialize(TeslaRecorder teslaRecorder) {
        this.recorder = teslaRecorder;
    }

    protected String getWidgetID(Widget widget) {
        block4: {
            if (widget != null) break block4;
            return "";
        }
        try {
            List parents = SWTUIPlayer.collectParents((Widget)widget, (Map)EclipseWorkbenchProvider.getProvider().getWorkbenchReference(this.getPlayer()), (Widget[])new Widget[0]);
            Collections.reverse(parents);
            StringBuilder builder = new StringBuilder();
            for (Widget w : parents) {
                builder.append(this.getWidgetIdentifier(w)).append('/');
            }
            builder.append(this.getWidgetIdentifier(widget));
            return builder.toString();
        }
        catch (Throwable throwable) {
            return "";
        }
    }

    public SWTUIPlayer getPlayer() {
        return this.player;
    }

    private String getWidgetIdentifier(Widget w) {
        StringBuilder b = new StringBuilder();
        b.append(w.getClass().getSimpleName());
        if (w instanceof Control) {
            Composite parent = ((Control)w).getParent();
            if (parent != null) {
                int i = Arrays.asList(parent.getChildren()).indexOf(w);
                b.append("|").append(Integer.toString(i));
            }
        } else if (w instanceof Item) {
            Object[] text;
            if (w instanceof TreeItem && !w.isDisposed()) {
                text = Viewers.getPathByTreeItem((TreeItem)((TreeItem)w));
                b.append(':').append(Arrays.toString(text));
            } else if (w instanceof TableItem && !w.isDisposed()) {
                text = Viewers.getPathByTableItem((TableItem)((TableItem)w));
                b.append(':').append(Arrays.toString(text));
            }
        }
        String id = b.toString();
        return id;
    }

    private static CellEditor getCellEditorFromColumnEditor(ColumnViewerEditor editor) {
        return TeslaSWTAccess.getCellEditorFromColumnEditor((ColumnViewerEditor)editor);
    }

    public FindResult findElement(SWTUIElement widget, boolean unknownAllowed, boolean alwaysFindLeaf, boolean supportEclipseWorkbench) {
        WindowUIElement shellObject;
        Canvas canvas;
        FindResult result;
        if (widget == null) {
            return null;
        }
        SWTRecordingHelper.getHelper().cleanDisposed();
        for (IWidgetLocatorExtension ext : this.extensions) {
            FindResult result2 = ext.findElement(widget, unknownAllowed, alwaysFindLeaf, supportEclipseWorkbench);
            if (result2 == null) continue;
            return result2;
        }
        if (widget.unwrap() instanceof Canvas && (result = this.tryFindDiagram(canvas = (Canvas)widget.unwrap())) != null) {
            return result;
        }
        if (widget instanceof WorkbenchUIElement) {
            WorkbenchUIElement ee = (WorkbenchUIElement)widget;
            IWorkbenchPart part = ee.reference.getPart(true);
            PartUIElement element = this.findPartElement(part, alwaysFindLeaf);
            if (element != null) {
                return new FindResult(widget, element.getElement());
            }
        }
        if (widget.getKind().is(ElementKind.Window) && (shellObject = this.getShell((Shell)widget.unwrap(), alwaysFindLeaf)) != null) {
            return new FindResult(this.player.wrap((Object)widget), shellObject.getElement());
        }
        if (widget.unwrap() instanceof Control) {
            BasicRecordingHelper.ElementEntry afterEntry;
            SWTUIElement afterElement;
            Shell shell;
            Control control = (Control)widget.unwrap();
            if (this.checkSkipWorkbenchTabs(supportEclipseWorkbench, control, shell = control.getShell())) {
                return null;
            }
            SWTUIElement uiElement = this.player.wrap((Object)control);
            BasicRecordingHelper.ElementEntry element = SWTRecordingHelper.getHelper().get(uiElement);
            if ((element = this.checkTextFieldChange(uiElement, element)) != null && (afterElement = (SWTUIElement)element.getObj("after")) != null && (afterEntry = SWTRecordingHelper.getHelper().get(afterElement)) != null && (this.checkTextFieldChange(afterElement, afterEntry) == null || this.checkParentsTextFieldChange(afterElement, false))) {
                element = null;
            }
            if (element != null && this.checkParentsTextFieldChange(uiElement, false)) {
                element = null;
            }
            SWTUIElement parentElement = this.getPlayer().getParentElement(uiElement);
            FindResult parentResult = this.findElement(parentElement, unknownAllowed, alwaysFindLeaf, supportEclipseWorkbench);
            if (element != null && !alwaysFindLeaf) {
                FindResult result3 = new FindResult(uiElement, element.getElement());
                if (this.isElementTextFieldChange(uiElement, element)) {
                    element.set(ELEMENT_TEXT, PlayerTextUtils.getText((SWTUIElement)uiElement));
                    this.updateControl(result3, widget);
                }
                return result3;
            }
            GenericElementKind kind = SWTUIPlayer.getKind((Object)control);
            if (parentResult != null && parentResult.element != null) {
                if (this.checkForViewEditor(control, shell, parentElement)) {
                    return new FindResult(parentElement, parentResult.element);
                }
                if (kind.is(ElementKind.Unknown)) {
                    if (unknownAllowed) {
                        return this.findUnknownElement(control, parentElement, parentResult.element);
                    }
                    return null;
                }
                return this.findGenericElement(widget.unwrap(), control, uiElement, kind, parentElement, parentResult.element);
            }
        } else {
            if (widget.unwrap() instanceof MenuItem) {
                return this.findMenuItem(widget.unwrap(), alwaysFindLeaf, supportEclipseWorkbench);
            }
            if (widget.unwrap() instanceof ToolItem) {
                return this.findToolItem(widget.unwrap(), alwaysFindLeaf, supportEclipseWorkbench);
            }
            if (widget.unwrap() instanceof CoolItem) {
                return this.findCoolItem(widget.unwrap(), alwaysFindLeaf, supportEclipseWorkbench);
            }
            if (widget.unwrap() instanceof TreeItem || widget.unwrap() instanceof TableItem) {
                return this.findTableOrTreeItem(widget.unwrap(), alwaysFindLeaf, supportEclipseWorkbench);
            }
            if (widget.unwrap() instanceof TreeColumn) {
                return this.findTreeColumn(widget.unwrap(), alwaysFindLeaf, supportEclipseWorkbench);
            }
            if (widget.unwrap() instanceof TableColumn) {
                return this.findTableColumn(widget.unwrap(), alwaysFindLeaf, supportEclipseWorkbench);
            }
        }
        return null;
    }

    private void updateControl(FindResult result, SWTUIElement widget) {
        Control control = (Control)widget.unwrap();
        this.recorder.setControls(new org.eclipse.rcptt.tesla.core.ui.Widget[]{SWTModelMapper.map((SWTUIElement)this.player.wrap((Object)control))});
        GenericElementKind kind = SWTUIPlayer.getKind((Object)control);
        UISelector selector = new UISelector(kind, (IUIPlayer)this.recorder, BasicUIElement.class).parent(result.element);
        selector.update(result.element);
    }

    private FindResult findTableColumn(Widget widget, boolean alwaysFindLeaf, boolean supportEclipseWorkbench) {
        SWTUIElement uiElement = this.player.wrap((Object)widget);
        BasicRecordingHelper.ElementEntry element = SWTRecordingHelper.getHelper().get(uiElement);
        if (element != null && !alwaysFindLeaf) {
            return new FindResult(this.player.wrap((Object)widget), element.getElement());
        }
        TableColumn column = (TableColumn)widget;
        Table parent = column.getParent();
        FindResult tableSearch = this.findElement(this.getPlayer().wrap((Object)parent), false, false, supportEclipseWorkbench);
        ViewerUIElement tableView = new ViewerUIElement(tableSearch.element, (UIPlayer)this.recorder);
        this.recorder.setControls(new org.eclipse.rcptt.tesla.core.ui.Widget[]{SWTModelMapper.map((SWTUIElement)this.player.wrap((Object)column))});
        ControlUIElement columnElement = tableView.column(column.getText(), Integer.valueOf(this.calculateIndex(uiElement, null)));
        SWTRecordingHelper.getHelper().put(this.player.wrap((Object)widget), new BasicRecordingHelper.ElementEntry(columnElement.getElement()));
        return new FindResult(this.player.wrap((Object)column), columnElement.getElement());
    }

    private FindResult findTreeColumn(Widget widget, boolean alwaysFindLeaf, boolean supportEclipseWorkbench) {
        SWTUIElement uiElement = this.player.wrap((Object)widget);
        BasicRecordingHelper.ElementEntry element = SWTRecordingHelper.getHelper().get(uiElement);
        if (element != null && !alwaysFindLeaf) {
            return new FindResult(this.player.wrap((Object)widget), element.getElement());
        }
        TreeColumn column = (TreeColumn)widget;
        Tree parent = column.getParent();
        FindResult treeSearch = this.findElement(this.getPlayer().wrap((Object)parent), false, false, supportEclipseWorkbench);
        ViewerUIElement treeView = new ViewerUIElement(treeSearch.element, (UIPlayer)this.recorder);
        this.recorder.setControls(new org.eclipse.rcptt.tesla.core.ui.Widget[]{SWTModelMapper.map((SWTUIElement)this.player.wrap((Object)column))});
        ControlUIElement columnElement = treeView.column(column.getText(), Integer.valueOf(this.calculateIndex(uiElement, null)));
        SWTRecordingHelper.getHelper().put(this.player.wrap((Object)widget), new BasicRecordingHelper.ElementEntry(columnElement.getElement()));
        return new FindResult(this.player.wrap((Object)column), columnElement.getElement());
    }

    public boolean checkParentsTextFieldChange(SWTUIElement uiElement, boolean self) {
        List parentsList = this.getPlayer().getParentsList(uiElement);
        boolean changeRequired = false;
        if (self) {
            parentsList.add(0, uiElement);
        }
        for (SWTUIElement swtuiElement : parentsList) {
            BasicRecordingHelper.ElementEntry change;
            SWTRecordingHelper helper = SWTRecordingHelper.getHelper();
            BasicRecordingHelper.ElementEntry entry = helper.get(swtuiElement);
            if (entry == null || (change = this.checkTextFieldChange(swtuiElement, entry)) != null) continue;
            helper.remove(swtuiElement);
            changeRequired = true;
            helper.clearAllWithParent(swtuiElement);
        }
        return changeRequired;
    }

    private ItemUIElement findItemUIElement(Widget widget, boolean supportEclipseWorkbench) {
        ItemUIElement itemElement = null;
        FindResult treeSearch = this.findElement(this.findParent(widget), false, false, supportEclipseWorkbench);
        ViewerUIElement treeView = new ViewerUIElement(treeSearch.element, (UIPlayer)this.recorder);
        if (widget instanceof TableItem) {
            itemElement = treeView.item(Viewers.getPathByTableItem((TableItem)((TableItem)widget)));
        } else if (widget instanceof TreeItem) {
            itemElement = treeView.item(Viewers.getPathByTreeItem((TreeItem)((TreeItem)widget)));
        }
        return itemElement;
    }

    private SWTUIElement findParent(Widget widget) {
        SWTUIElement result = null;
        if (widget instanceof TableItem) {
            TableItem item = (TableItem)widget;
            Table parent = item.getParent();
            result = this.getPlayer().wrap((Object)parent);
        } else if (widget instanceof TreeItem) {
            TreeItem item = (TreeItem)widget;
            Tree parent = item.getParent();
            result = this.getPlayer().wrap((Object)parent);
        }
        return result;
    }

    private FindResult findTableOrTreeItem(Widget widget, boolean alwaysFindLeaf, boolean supportEclipseWorkbench) {
        BasicRecordingHelper.ElementEntry element = SWTRecordingHelper.getHelper().get(this.player.wrap((Object)widget));
        SWTUIElement uiElement = this.player.wrap((Object)widget);
        if (element != null && !alwaysFindLeaf) {
            FindResult result = new FindResult(uiElement, element.getElement());
            if (this.isElementTextFieldChange(uiElement, element)) {
                element.set(ELEMENT_TEXT, PlayerTextUtils.getText((SWTUIElement)uiElement));
            } else {
                return result;
            }
        }
        this.recorder.setControls(new org.eclipse.rcptt.tesla.core.ui.Widget[]{SWTModelMapper.map((SWTUIElement)uiElement)});
        ItemUIElement itemElement = this.findItemUIElement(widget, supportEclipseWorkbench);
        BasicRecordingHelper.ElementEntry newElement = new BasicRecordingHelper.ElementEntry(itemElement.getElement());
        SWTRecordingHelper.getHelper().put(uiElement, newElement);
        newElement.set(ELEMENT_TEXT, PlayerTextUtils.getText((SWTUIElement)uiElement));
        return new FindResult(uiElement, itemElement.getElement());
    }

    private FindResult findCoolItem(Widget widget, boolean alwaysFindLeaf, boolean supportEclipseWorkbench) {
        SWTUIElement uiElement = this.player.wrap((Object)widget);
        BasicRecordingHelper.ElementEntry element = SWTRecordingHelper.getHelper().get(uiElement);
        if ((element = this.checkTextFieldChange(uiElement, element)) != null && !alwaysFindLeaf) {
            return new FindResult(uiElement, element.getElement());
        }
        CoolItem item = (CoolItem)widget;
        CoolBar parent = item.getParent();
        SWTUIElement semanticParent = this.getPlayer().getParentElement(this.getPlayer().wrap((Object)parent));
        FindResult result = this.findElement(semanticParent, false, false, supportEclipseWorkbench);
        CompositeUIElement ee = new CompositeUIElement(result.element, (UIPlayer)this.recorder);
        String text = PlayerTextUtils.getText((SWTUIElement)this.player.wrap((Object)item));
        ControlUIElement button = null;
        this.recorder.setControls(new org.eclipse.rcptt.tesla.core.ui.Widget[]{uiElement.getModel()});
        boolean needText = false;
        int index = this.calculateIndex(uiElement, null);
        if (text != null && text.trim().length() > 0) {
            button = index == 0 ? ee.button(text) : ee.button(text, index);
            needText = true;
        } else {
            button = ee.button(index);
        }
        BasicRecordingHelper.ElementEntry entry = new BasicRecordingHelper.ElementEntry(button.getElement());
        if (needText) {
            entry.set(ATTR_TEXT, text);
        }
        SWTRecordingHelper.getHelper().put(uiElement, entry);
        return new FindResult(this.player.wrap((Object)item), entry.getElement());
    }

    private FindResult findToolItem(Widget widget, boolean alwaysFindLeaf, boolean supportEclipseWorkbench) {
        SWTUIElement uiElement = this.player.wrap((Object)widget);
        BasicRecordingHelper.ElementEntry element = SWTRecordingHelper.getHelper().get(uiElement);
        if ((element = this.checkTextFieldChange(uiElement, element)) != null && !alwaysFindLeaf) {
            return new FindResult(uiElement, element.getElement());
        }
        ToolItem item = (ToolItem)widget;
        ToolBar parent = item.getParent();
        SWTUIElement parentElement = this.getPlayer().getParentElement(this.getPlayer().wrap((Object)parent));
        FindResult result = this.findElement(parentElement, false, alwaysFindLeaf, supportEclipseWorkbench);
        if (result == null) {
            return null;
        }
        CompositeUIElement ee = new CompositeUIElement(result.element, (UIPlayer)this.recorder);
        String text = PlayerTextUtils.getText((SWTUIElement)this.player.wrap((Object)item));
        ControlUIElement button = null;
        this.recorder.setControls(new org.eclipse.rcptt.tesla.core.ui.Widget[]{uiElement.getModel()});
        boolean needText = false;
        int index = this.calculateIndex(uiElement, null);
        if (text != null && text.trim().length() > 0) {
            button = index != 0 ? ee.button(text, index) : ee.button(text);
            needText = true;
        } else {
            button = ee.button(index);
        }
        BasicRecordingHelper.ElementEntry buttonEntry = new BasicRecordingHelper.ElementEntry(button.getElement());
        if (needText) {
            buttonEntry.set(ATTR_TEXT, text);
        }
        SWTRecordingHelper.getHelper().put(uiElement, buttonEntry);
        return new FindResult(this.player.wrap((Object)item), buttonEntry.getElement());
    }

    private FindResult findMenuItem(Widget widget, boolean alwaysFindLeaf, boolean supportEclipseWorkbench) {
        WindowUIElement windowUIElement;
        MenuItem item = (MenuItem)widget;
        Shell shell = item.getParent().getShell();
        HashMap<Widget, Widget> parentsMap = new HashMap<Widget, Widget>();
        this.fillParents(parentsMap, (Widget)item);
        ArrayList<MenuItem> path = new ArrayList<MenuItem>();
        MenuItem current = item;
        while (current != null) {
            if (current instanceof MenuItem) {
                path.add(0, current);
            }
            current = (Widget)parentsMap.get(current);
        }
        ArrayList<String> selection = new ArrayList<String>();
        boolean doItemCorrection = false;
        for (Widget widget2 : path) {
            String text = this.player.wrap((Object)widget2).getText();
            Object data = widget2.getData();
            if (data != null && data instanceof ActionContributionItem) {
                ActionContributionItem contribution = (ActionContributionItem)data;
                String id = contribution.getId();
                if ("org.eclipse.debug.ui.contextualLaunch.run.submenu".equals(id)) {
                    doItemCorrection = true;
                }
                if (doItemCorrection && text.matches("\\d+ .*")) {
                    int pos = text.indexOf(32);
                    text = "\\d+ " + text.substring(pos + 1);
                }
            }
            selection.add(text);
        }
        WindowUIElement lowerParentElement = windowUIElement = this.getShell(shell, false);
        Menu upperMenu = item.getParent();
        while (upperMenu.getParentMenu() != null) {
            upperMenu = upperMenu.getParentMenu();
        }
        SWTUIElement element = this.getPlayer().wrap(SWTEventManager.getMenuSource((Widget)upperMenu));
        if (element != null && element.widget instanceof ToolBar && !upperMenu.equals(((ToolBar)element.widget).getMenu()) && SWTWidgetLocator.isParentEclipseWindow(upperMenu)) {
            element = null;
        }
        if (element != null) {
            String[][] pathSelection;
            FindResult result = this.findElement(element, false, alwaysFindLeaf, supportEclipseWorkbench);
            if (result == null) {
                return null;
            }
            lowerParentElement = new CompositeUIElement(result.element, (UIPlayer)this.recorder);
            if (element.isTree() && (pathSelection = element.getMultiPathSelection()).length > 0) {
                ViewerUIElement view = new ViewerUIElement(result.element, (UIPlayer)this.recorder);
                view.setMultiSelection(pathSelection);
            }
        }
        String[] sel = selection.toArray(new String[selection.size()]);
        this.recorder.setControls(new org.eclipse.rcptt.tesla.core.ui.Widget[]{this.player.wrap((Object)widget).getModel()});
        return new FindResult(this.player.wrap((Object)item), lowerParentElement.menu(sel).getElement());
    }

    private FindResult findGenericElement(Widget widget, Control control, SWTUIElement realElement, GenericElementKind kind, SWTUIElement lowerParent, Element parentElement) {
        int widgetIndex = -1;
        SWTUIElement realAfter = null;
        SWTUIElement[] realChildren = this.player.children.collectFor(lowerParent, null, true, this.getSearchClasses(control));
        boolean isTopLevelTabFolder = widget instanceof CTabFolder && lowerParent.isWorkbenchWindow();
        SWTUIElement[] sWTUIElementArray = realChildren;
        int n = realChildren.length;
        int n2 = 0;
        while (n2 < n) {
            block9: {
                SWTUIElement afterParent;
                SWTUIElement i = sWTUIElementArray[n2];
                String text = i.getText();
                if (i.getKind().is(kind)) {
                    ++widgetIndex;
                }
                if (i.match((Object)widget)) {
                    realElement = i;
                    break;
                }
                GenericElementKind iKind = i.getKind();
                if (iKind != null && iKind.isLabel() && text != null && this.couldBeAfterItem(text.trim()) && !isTopLevelTabFolder && (afterParent = this.player.getParentElement(i)) != null && afterParent.equals((Object)lowerParent)) {
                    block8: {
                        Widget apUnwrap = afterParent.unwrap();
                        try {
                            Control label;
                            Class<?> expandableClass = Class.forName("org.eclipse.ui.forms.widgets.ExpandableComposite");
                            if (expandableClass == null || !expandableClass.isInstance(apUnwrap) || (label = TeslaSWTAccess.getExpandableLabel((Widget)apUnwrap)) == null || !label.equals(i.unwrap())) break block8;
                            break block9;
                        }
                        catch (Throwable throwable) {}
                    }
                    realAfter = i;
                    widgetIndex = -1;
                }
            }
            ++n2;
        }
        if (widgetIndex == -1) {
            return null;
        }
        if (realElement != null && realElement.getKind() != null) {
            return this.selectRequiredElementToBeFocused(realElement, widget, kind, realAfter, parentElement, widgetIndex);
        }
        return null;
    }

    private FindResult selectRequiredElementToBeFocused(SWTUIElement realElement, Widget widget, GenericElementKind kind, SWTUIElement realAfter, Element parentElement, int widgetIndex) {
        int absIndex = this.calculateIndex(realElement, null);
        BasicRecordingHelper.ElementEntry after = null;
        if (absIndex == 0 && kind.skipFirstAfter()) {
            realAfter = null;
        }
        if (realAfter != null) {
            after = this.getLabel(realAfter, parentElement);
        }
        String text = realElement.getText();
        UISelector selector = new UISelector(kind, (IUIPlayer)this.recorder, BasicUIElement.class).parent(parentElement);
        this.recorder.setControls(new org.eclipse.rcptt.tesla.core.ui.Widget[]{realElement.getModel()});
        if (after != null) {
            selector = selector.after(after.getElement());
        }
        Set<ElementKind> indexKinds = this.genIndexKinds();
        BasicRecordingHelper.ElementEntry result = this.createElementEntry(indexKinds, (UISelector<BasicUIElement>)selector, text, kind, realElement, widgetIndex, realAfter);
        if (after != null) {
            result.set("after", realAfter);
        } else {
            result.set("after", realElement);
        }
        if (text != null) {
            result.set(ELEMENT_TEXT, text);
        }
        if (widget instanceof Text && widget == EclipseWorkbenchProvider.getProvider().getQuickAccess()) {
            result.getElement().setDescription("quick-access");
        }
        SWTRecordingHelper.getHelper().put(realElement, result);
        return new FindResult(realElement, result.getElement());
    }

    private BasicRecordingHelper.ElementEntry createElementEntry(Set<ElementKind> indexKinds, UISelector<BasicUIElement> selector, String text, GenericElementKind kind, SWTUIElement realElement, int widgetIndex, SWTUIElement realAfter) {
        BasicRecordingHelper.ElementEntry result = null;
        if (!indexKinds.contains(kind.kind) && text != null) {
            int i = this.calculateIndex(realElement, realAfter);
            result = i == -1 || i == 0 ? new BasicRecordingHelper.ElementEntry(selector.find(text).getElement()) : new BasicRecordingHelper.ElementEntry(selector.find(text, Integer.valueOf(i)).getElement());
            if (text != null) {
                result.set(ATTR_TEXT, text);
            }
        } else {
            result = widgetIndex == 0 ? new BasicRecordingHelper.ElementEntry(selector.find().getElement()) : new BasicRecordingHelper.ElementEntry(selector.find(Integer.valueOf(widgetIndex)).getElement());
        }
        return result;
    }

    private boolean couldBeAfterItem(String text) {
        if (text.length() == 0) {
            return false;
        }
        return !text.matches(".*\\(\\d*%\\).*");
    }

    private boolean isAfterBetween(SWTUIElement realElement, SWTUIElement realAfter) {
        SWTUIElement p = this.player.getParentElement(realElement);
        Widget realWidget = realElement.unwrap();
        Widget realAfterWidget = realAfter.unwrap();
        ArrayList<SWTUIElement> elements = new ArrayList<SWTUIElement>(Arrays.asList(this.player.children.collectFor(p, null, true, new Class[]{this.getSearchableClass(realWidget), this.getSearchableClass(realAfterWidget)})));
        GenericElementKind kind = realElement.getKind();
        int itemIndex = elements.indexOf(realElement);
        int afterIndex = elements.indexOf(realAfter);
        int i = afterIndex + 1;
        while (i < itemIndex) {
            SWTUIElement element = (SWTUIElement)elements.get(i);
            if (kind.is(element.getKind())) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private FindResult findUnknownElement(Control control, SWTUIElement lowerParent, Element lowerParentElement) {
        SWTUIElement realAfter = null;
        SWTUIElement[] realChildren = this.player.children.collectFor(lowerParent, null, true, new Class[0]);
        int indexOf = -1;
        int afterIndex = -1;
        boolean supportAnyLabels = true;
        Rectangle bounds = control.getBounds();
        Point controlBounds = control.toDisplay(new Point(bounds.x, bounds.y));
        bounds.x = controlBounds.x;
        bounds.y = controlBounds.y;
        int i = 0;
        while (i < realChildren.length) {
            block11: {
                SWTUIElement afterParent;
                GenericElementKind iKind;
                String text = realChildren[i].getText();
                if (realChildren[i].match((Object)control)) {
                    indexOf = i;
                    break;
                }
                if (supportAnyLabels && (iKind = realChildren[i].getKind()) != null && iKind.isLabel() && text != null && this.couldBeAfterItem(text.trim()) && (afterParent = this.player.getParentElement(realChildren[i])) != null && afterParent.equals((Object)lowerParent)) {
                    block10: {
                        Widget apUnwrap = afterParent.unwrap();
                        try {
                            Control label;
                            Class<?> expandableClass = Class.forName("org.eclipse.ui.forms.widgets.ExpandableComposite");
                            if (expandableClass == null || !expandableClass.isInstance(apUnwrap) || (label = TeslaSWTAccess.getExpandableLabel((Widget)apUnwrap)) == null || !label.equals(realChildren[i].unwrap())) break block10;
                            break block11;
                        }
                        catch (Throwable throwable) {}
                    }
                    Rectangle afterBounds = realChildren[i].getBounds();
                    if (afterBounds.y <= bounds.y + bounds.height) {
                        realAfter = realChildren[i];
                        afterIndex = i;
                    }
                }
            }
            ++i;
        }
        if (indexOf != -1) {
            BasicRecordingHelper.ElementEntry result = null;
            BasicRecordingHelper.ElementEntry after = null;
            UISelector selector = new UISelector(ElementKind.Any, (IUIPlayer)this.recorder, BasicUIElement.class).parent(lowerParentElement);
            if (realAfter != null && (after = this.getLabel(realAfter, lowerParentElement)) != null) {
                selector = selector.after(after.getElement());
            }
            SWTUIElement item = realChildren[indexOf];
            this.recorder.setControls(new org.eclipse.rcptt.tesla.core.ui.Widget[]{item.getModel()});
            int i2 = indexOf - (afterIndex + 1);
            String text = item.getText();
            if (text != null && text.trim().length() == 0) {
                text = null;
            }
            result = i2 == -1 || i2 == 0 ? new BasicRecordingHelper.ElementEntry(selector.find(text).getElement()) : new BasicRecordingHelper.ElementEntry(selector.find(text, Integer.valueOf(i2)).getElement());
            result.set(ATTR_TEXT, text);
            if (after != null) {
                result.set("after", realAfter);
            }
            SWTRecordingHelper.getHelper().put(item, result);
            return new FindResult(item, result.getElement());
        }
        return null;
    }

    private boolean checkForViewEditor(Control control, Shell shell, SWTUIElement lowerParent) {
        IWorkbenchWindow[] workbenchWindows = PlatformUI.getWorkbench().getWorkbenchWindows();
        if (lowerParent instanceof WorkbenchUIElement) {
            IWorkbenchPage lowerParentPage = ((WorkbenchUIElement)lowerParent).getReference().getPage();
            IWorkbenchWindow[] iWorkbenchWindowArray = workbenchWindows;
            int n = workbenchWindows.length;
            int n2 = 0;
            while (n2 < n) {
                WorkbenchPage page;
                IWorkbenchWindow iWorkbenchWindow = iWorkbenchWindowArray[n2];
                Shell wshell = iWorkbenchWindow.getShell();
                if (wshell == shell && (page = (WorkbenchPage)iWorkbenchWindow.getActivePage()).equals(lowerParentPage)) {
                    IEditorReference[] editors;
                    IViewReference[] views;
                    IViewReference[] iViewReferenceArray = views = page.getViewReferences();
                    int n3 = views.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IViewReference iViewPart = iViewReferenceArray[n4];
                        Control composite = ((WorkbenchPartReference)iViewPart).getPane().getControl();
                        if (control.equals(composite)) {
                            return true;
                        }
                        ++n4;
                    }
                    IEditorReference[] iEditorReferenceArray = editors = page.getEditorReferences();
                    int n5 = editors.length;
                    n3 = 0;
                    while (n3 < n5) {
                        IEditorReference iEditorPart = iEditorReferenceArray[n3];
                        Control composite = ((WorkbenchPartReference)iEditorPart).getPane().getControl();
                        if (control.equals(composite)) {
                            return true;
                        }
                        ++n3;
                    }
                }
                ++n2;
            }
        }
        return false;
    }

    private boolean checkSkipWorkbenchTabs(boolean supportEclipseWorkbench, Control control, Shell shell) {
        if (control instanceof CTabFolder) {
            IWorkbenchWindow[] workbenchWindows;
            IWorkbenchWindow[] iWorkbenchWindowArray = workbenchWindows = PlatformUI.getWorkbench().getWorkbenchWindows();
            int n = workbenchWindows.length;
            int n2 = 0;
            while (n2 < n) {
                IWorkbenchWindow iWorkbenchWindow = iWorkbenchWindowArray[n2];
                Shell wshell = iWorkbenchWindow.getShell();
                if (wshell == shell) {
                    WorkbenchPage page = (WorkbenchPage)iWorkbenchWindow.getActivePage();
                    Composite composite = page.getClientComposite();
                    if (!control.getParent().equals(composite) || supportEclipseWorkbench) break;
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    private Class[] getSearchClasses(Control control) {
        ArrayList<Class> classes = new ArrayList<Class>();
        classes.add(Label.class);
        classes.add(CLabel.class);
        classes.add(Link.class);
        try {
            EclipseFormsSupport.addLinkClass(classes);
        }
        catch (Throwable e) {
            TeslaCore.log((Throwable)e);
        }
        classes.add(this.getSearchableClass(control));
        if (control instanceof StyledText) {
            classes.add(Text.class);
        }
        if (control instanceof Text) {
            classes.add(StyledText.class);
        }
        if (control instanceof Spinner) {
            classes.add(Spinner.class);
        }
        if (control instanceof CCombo) {
            classes.add(Combo.class);
        }
        if (control instanceof Combo) {
            classes.add(CCombo.class);
        }
        if (control instanceof Button) {
            classes.add(ToolItem.class);
        }
        return classes.toArray(new Class[classes.size()]);
    }

    private Class getSearchableClass(Object cl) {
        return SWTUIPlayer.getSearchableClass((Object)cl);
    }

    private Set<ElementKind> genIndexKinds() {
        HashSet<ElementKind> indexKinds = new HashSet<ElementKind>();
        indexKinds.add(ElementKind.Text);
        indexKinds.add(ElementKind.Tree);
        indexKinds.add(ElementKind.List);
        indexKinds.add(ElementKind.Table);
        indexKinds.add(ElementKind.Combo);
        indexKinds.add(ElementKind.TabFolder);
        indexKinds.add(ElementKind.CBanner);
        indexKinds.add(ElementKind.Toolbar);
        indexKinds.add(ElementKind.CoolBar);
        indexKinds.add(ElementKind.Canvas);
        indexKinds.add(ElementKind.Browser);
        indexKinds.add(ElementKind.DateTime);
        indexKinds.add(ElementKind.Slider);
        indexKinds.add(ElementKind.TextViewer);
        return indexKinds;
    }

    public int calculateIndex(SWTUIElement semanticParent, SWTUIElement afterLabel) {
        String text = semanticParent.getText();
        Widget w = PlayerWrapUtils.unwrapWidget((SWTUIElement)semanticParent);
        SWTUIElement p = this.player.getParentElement(semanticParent);
        if (p != null) {
            ArrayList<Class> classes = new ArrayList<Class>();
            classes.add(this.getSearchableClass(w));
            if (w instanceof StyledText) {
                classes.add(Text.class);
            }
            if (w instanceof Text) {
                classes.add(StyledText.class);
            }
            if (w instanceof Spinner) {
                classes.add(Spinner.class);
            }
            if (w instanceof Button) {
                classes.add(ToolItem.class);
            }
            if (afterLabel != null) {
                classes.add(Label.class);
                classes.add(CLabel.class);
                classes.add(Link.class);
                try {
                    EclipseFormsSupport.addLinkClass(classes);
                }
                catch (Throwable e) {
                    TeslaCore.log((Throwable)e);
                }
            }
            SWTUIElement[] children = this.player.children.collectFor(p, null, true, classes.toArray(new Class[classes.size()]));
            int index = 0;
            int pos = 0;
            if (afterLabel != null) {
                Widget label = PlayerWrapUtils.unwrapWidget((SWTUIElement)afterLabel);
                int i = 0;
                while (i < children.length) {
                    if (children[i].match((Object)label)) {
                        pos = i + 1;
                        break;
                    }
                    ++i;
                }
            }
            Set<ElementKind> indexKinds = this.genIndexKinds();
            ElementKind kind = semanticParent.getKind().kind;
            int i = pos;
            while (i < children.length) {
                if (children[i].match((Object)w)) {
                    return index;
                }
                if (indexKinds.contains(kind) && children[i].getKind().is(kind)) {
                    ++index;
                } else if (text != null && text.equals(children[i].getText()) && children[i].getKind().is(kind)) {
                    ++index;
                } else if ((text == null || text.isEmpty()) && children[i].getKind().is(kind)) {
                    ++index;
                }
                ++i;
            }
        }
        return 0;
    }

    private void fillParents(Map<Widget, Widget> parentsMap, Widget e) {
        Menu m;
        MenuItem parentItem;
        if (e.isDisposed()) {
            return;
        }
        if (parentsMap.containsKey(e)) {
            return;
        }
        if (e instanceof MenuItem) {
            Menu parent;
            MenuItem menuItem = (MenuItem)e;
            parentsMap.put(e, (Widget)menuItem.getParent());
            Menu menu = menuItem.getMenu();
            if (menu != null) {
                parentsMap.put((Widget)menu, e);
                this.fillParents(parentsMap, (Widget)menu);
            }
            if ((parent = menuItem.getParent()) != null) {
                parentsMap.put((Widget)menuItem, (Widget)parent);
                this.fillParents(parentsMap, (Widget)parent);
            }
        } else if (e instanceof Menu && (parentItem = (m = (Menu)e).getParentItem()) != null) {
            this.fillParents(parentsMap, (Widget)parentItem);
        }
    }

    private BasicRecordingHelper.ElementEntry getLabel(SWTUIElement realAfter, Element parent) {
        BasicRecordingHelper.ElementEntry after = SWTRecordingHelper.getHelper().get(realAfter);
        if ((after = this.checkTextFieldChange(realAfter, after)) == null) {
            this.recorder.setControls(new org.eclipse.rcptt.tesla.core.ui.Widget[]{realAfter.getModel()});
            FindResult afterElement = this.findElement(realAfter, false, false, true);
            String realAfterText = realAfter.getText();
            after = new BasicRecordingHelper.ElementEntry(afterElement.element);
            after.set(ATTR_TEXT, realAfterText);
            SWTRecordingHelper.getHelper().put(realAfter, after);
        }
        return after;
    }

    private CompositeUIElement controlUIElement(Element window) {
        return new CompositeUIElement(window, (UIPlayer)this.recorder);
    }

    public WindowUIElement getShell(Shell shell, boolean alwaysFindLeaf) {
        if (shell == null) {
            return null;
        }
        if (!shell.isVisible()) {
            return null;
        }
        String pattern = shell.getText();
        SWTUIElement wrappedShell = this.player.wrap((Object)shell);
        BasicRecordingHelper.ElementEntry window = SWTRecordingHelper.getHelper().get(wrappedShell);
        if ((window = this.checkTextFieldChange(wrappedShell, window)) == null || alwaysFindLeaf) {
            IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
            int ind = 0;
            boolean found = false;
            IWorkbenchWindow[] iWorkbenchWindowArray = windows;
            int n = windows.length;
            int n2 = 0;
            while (n2 < n) {
                IWorkbenchWindow iWorkbenchWindow = iWorkbenchWindowArray[n2];
                if (shell.equals(iWorkbenchWindow.getShell())) {
                    int sdkIndex = pattern.indexOf("- Eclipse SDK");
                    if (sdkIndex != -1) {
                        pattern = ".*- Eclipse SDK";
                    }
                    found = true;
                    break;
                }
                ++ind;
                ++n2;
            }
            Composite parent = shell.getParent();
            pattern = pattern.trim();
            WindowUIElement win = null;
            if (found && parent == null) {
                this.recorder.setControls(new org.eclipse.rcptt.tesla.core.ui.Widget[]{wrappedShell.getModel()});
                win = ind == 0 ? this.recorder.eclipseWindow() : this.recorder.eclipseWindow(ind);
            } else {
                String methodName;
                int index;
                String className;
                WindowUIElement parentWindow = this.getShell((Shell)parent, alwaysFindLeaf);
                if (parentWindow == null) {
                    parentWindow = this.recorder;
                }
                this.recorder.setControls(new org.eclipse.rcptt.tesla.core.ui.Widget[]{wrappedShell.getModel()});
                if (pattern.length() != 0) {
                    int i = this.calculateIndex(wrappedShell, null);
                    win = i != 0 ? parentWindow.window(pattern, i) : parentWindow.window(pattern);
                }
                if (win == null && (className = GetWindowUtil.getWindowClassName((Shell)shell)) != null) {
                    SWTUIElement[] children = this.player.children.collectFor(this.getPlayer().wrap((Object)parent), null, true, new Class[]{Shell.class});
                    index = IndexUtil.calcIndexFor((Widget)shell, (SWTUIElement[])children, (IndexUtil.Criterion)GetWindowUtil.byClass((String)className));
                    win = index != 0 ? parentWindow.classedWindow(className, index) : parentWindow.classedWindow(className);
                }
                if (win == null && (methodName = GetWindowUtil.getShellCreationMethodName((Shell)shell)) != null) {
                    SWTUIElement[] children = this.player.children.collectFor(this.getPlayer().wrap((Object)parent), null, true, new Class[]{Shell.class});
                    index = IndexUtil.calcIndexFor((Widget)shell, (SWTUIElement[])children, (IndexUtil.Criterion)GetWindowUtil.byFrom((String)methodName));
                    win = index != 0 ? parentWindow.fromedWindow(methodName, index) : parentWindow.fromedWindow(methodName);
                }
                if (win == null) {
                    throw new RuntimeException("Failed to locate shell element:" + shell.toString());
                }
            }
            window = new BasicRecordingHelper.ElementEntry(win.getElement());
            if (!found || parent != null) {
                window.set(ATTR_TEXT, pattern);
            }
            window.getElement().setDescription(pattern);
            SWTRecordingHelper.getHelper().put(wrappedShell, window);
        }
        return new WindowUIElement(window.getElement(), (UIPlayer)this.recorder);
    }

    private BasicRecordingHelper.ElementEntry checkTextFieldChange(SWTUIElement uiElement, BasicRecordingHelper.ElementEntry element) {
        String pattern;
        if (element == null) {
            return null;
        }
        String text = element.get(ATTR_TEXT);
        if (text != null && (pattern = PlayerTextUtils.getText((SWTUIElement)uiElement)) != null && !pattern.equals(text)) {
            SWTRecordingHelper.getHelper().remove(uiElement);
            SWTRecordingHelper.getHelper().clearAllWithParent(uiElement);
            element = null;
        }
        return element;
    }

    private boolean isElementTextFieldChange(SWTUIElement uiElement, BasicRecordingHelper.ElementEntry element) {
        String pattern;
        String text;
        return element != null && (text = element.get(ELEMENT_TEXT)) != null && (pattern = PlayerTextUtils.getText((SWTUIElement)uiElement)) != null && !pattern.equals(text);
    }

    public PartUIElement findPartElement(IWorkbenchPart part, boolean alwaysFindLeaf) {
        String title;
        SWTUIElement wrap = this.player.wrap((Object)part);
        BasicRecordingHelper.ElementEntry result = SWTRecordingHelper.getHelper().get(wrap);
        if ((result = this.checkTextFieldChange(wrap, result)) != null && !alwaysFindLeaf) {
            return new PartUIElement(result.getElement(), (UIPlayer)this.recorder);
        }
        IWorkbenchWindow window = part.getSite().getWorkbenchWindow();
        if (part instanceof IViewPart) {
            IViewPart viewPart = (IViewPart)part;
            title = ((WorkbenchPart)viewPart).getPartName();
            WindowUIElement shellElement = this.getShell(window.getShell(), false);
            if (shellElement == null) {
                return null;
            }
            this.getRecorder().setControls(new org.eclipse.rcptt.tesla.core.ui.Widget[]{SWTModelMapper.map((SWTUIElement)wrap)});
            int ViewIdx = this.calcViewIndex(part);
            result = ViewIdx > 0 ? new BasicRecordingHelper.ElementEntry(shellElement.view(title, ViewIdx).getElement()) : new BasicRecordingHelper.ElementEntry(shellElement.view(title).getElement());
            result.set(ATTR_TEXT, title);
        }
        if (part instanceof IEditorPart) {
            IEditorPart editorPart = (IEditorPart)part;
            title = ((WorkbenchPart)editorPart).getPartName();
            FindResult element = this.findElement(this.getPlayer().wrap((Object)window.getShell()), false, false, false);
            WindowUIElement windowElement = new WindowUIElement(element.element, (UIPlayer)this.recorder);
            this.getRecorder().setControls(new org.eclipse.rcptt.tesla.core.ui.Widget[]{SWTModelMapper.map((SWTUIElement)wrap)});
            EditorLocation location = this.getEditorLocation(editorPart);
            result = new BasicRecordingHelper.ElementEntry(windowElement.editor(location.title, location.label, location.index).getElement());
            result.set(ATTR_TEXT, title);
        }
        if (result != null) {
            SWTRecordingHelper.getHelper().put(wrap, result);
            return new PartUIElement(result.getElement(), (UIPlayer)this.recorder);
        }
        return null;
    }

    private EditorLocation getEditorLocation(IEditorPart editor) {
        IEditorReference[] refs = editor.getSite().getWorkbenchWindow().getActivePage().getEditorReferences();
        String name = ((WorkbenchPart)editor).getPartName();
        String id = editor.getSite().getId();
        String label = editor.getSite().getWorkbenchWindow().getWorkbench().getEditorRegistry().findEditor(id).getLabel();
        int counter = 0;
        IEditorReference[] iEditorReferenceArray = refs;
        int n = refs.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorReference ref = iEditorReferenceArray[n2];
            if (ref.getPartName() != null && ref.getPartName().equals(name)) {
                ++counter;
            }
            ++n2;
        }
        if (counter < 2) {
            return new EditorLocation(name, null, null);
        }
        counter = 0;
        int index = 0;
        int globalIndex = 0;
        boolean typeDiversity = false;
        int i = 0;
        while (i < refs.length) {
            IEditorReference ref = refs[i];
            if (ref.getPartName() != null && ref.getPartName().equals(name)) {
                if (ref.getId() != null && ref.getId().equals(id)) {
                    if (editor == ref.getEditor(false)) {
                        index = counter;
                        globalIndex = i;
                    }
                    ++counter;
                } else {
                    typeDiversity = true;
                }
            }
            ++i;
        }
        if (counter < 2) {
            return new EditorLocation(name, label, null);
        }
        if (!typeDiversity) {
            return new EditorLocation(name, null, index == 0 ? null : Integer.valueOf(index));
        }
        return new EditorLocation(name, globalIndex == 0 ? null : label, index == 0 || globalIndex == 0 ? null : Integer.valueOf(index));
    }

    private int calcViewIndex(IWorkbenchPart part) {
        IViewReference[] views;
        String title = ((WorkbenchPart)part).getPartName();
        int currIdx = 0;
        IViewReference[] iViewReferenceArray = views = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getViewReferences();
        int n = views.length;
        int n2 = 0;
        while (n2 < n) {
            IViewReference iViewRef = iViewReferenceArray[n2];
            String label = iViewRef.getPartName();
            if (label != null && label.equals(title)) {
                if (iViewRef.getPart(false).equals(part)) {
                    return currIdx;
                }
                ++currIdx;
            }
            ++n2;
        }
        return -1;
    }

    public int getColumnFromCellEditor(Object cellEditorObj, ControlEditor editor, CellEditor cellEditor) {
        ViewerCell cell;
        int col;
        if (editor instanceof TreeEditor ? (col = ((TreeEditor)editor).getColumn()) != -1 : editor instanceof TableEditor && (col = ((TableEditor)editor).getColumn()) != -1) {
            return col;
        }
        ColumnViewerEditor cve = null;
        if (cellEditorObj instanceof ColumnViewerEditor) {
            cve = (ColumnViewerEditor)cellEditorObj;
        }
        if (cve == null) {
            cve = this.getColumnViewerEditor(cellEditor);
        }
        if (cve != null && (cell = cve.getFocusCell()) != null) {
            return cell.getColumnIndex();
        }
        return -1;
    }

    private ColumnViewerEditor getColumnViewerEditor(CellEditor cellEditor) {
        return TeslaSWTAccess.getColumnViewerEditor((CellEditor)cellEditor);
    }

    public SWTWidgetLocator(SWTUIPlayer player) {
        this.player = player;
    }

    protected CellEditor getCellEditor(Object cellEditorObj) {
        CellEditor cellEditor = null;
        if (cellEditorObj instanceof CellEditor) {
            cellEditor = (CellEditor)cellEditorObj;
        } else if (cellEditorObj instanceof ColumnViewerEditor) {
            cellEditor = SWTWidgetLocator.getCellEditorFromColumnEditor((ColumnViewerEditor)cellEditorObj);
        }
        return cellEditor;
    }

    public void cleanMenuSources() {
        SWTEventManager.cleanMenuSources();
    }

    public TeslaRecorder getRecorder() {
        return this.recorder;
    }

    public FindResult findElement(Widget widget, boolean unknownAllowed, boolean alwaysFindLeaf, boolean supportEclipseWorkbench) {
        return this.findElement(this.getPlayer().wrap((Object)widget), unknownAllowed, alwaysFindLeaf, supportEclipseWorkbench);
    }

    private FindResult tryFindDiagram(Canvas canvas) {
        List processors = this.recorder.getProcessors(ICanvasDiagramHelper.class);
        for (ICanvasDiagramHelper processor : processors) {
            Element element = processor.findDiagramElement(canvas);
            if (element == null) continue;
            return new FindResult(this.getPlayer().wrap((Object)canvas), element);
        }
        return null;
    }

    public static IWorkbenchPart findViewMenuSource(Widget widget) {
        IWorkbenchWindow[] workbenchWindows;
        IWorkbenchWindow[] iWorkbenchWindowArray = workbenchWindows = PlatformUI.getWorkbench().getWorkbenchWindows();
        int n = workbenchWindows.length;
        int n2 = 0;
        while (n2 < n) {
            IViewReference[] viewReferences;
            IWorkbenchWindow iWorkbenchWindow = iWorkbenchWindowArray[n2];
            WorkbenchPage page = (WorkbenchPage)iWorkbenchWindow.getActivePage();
            IViewReference[] iViewReferenceArray = viewReferences = page.getViewReferences();
            int n3 = viewReferences.length;
            int n4 = 0;
            while (n4 < n3) {
                Menu menu;
                PartSite site;
                IViewReference viewReference = iViewReferenceArray[n4];
                IWorkbenchPart workbenchPart = viewReference.getPart(false);
                if (workbenchPart != null && (site = (PartSite)workbenchPart.getSite()) != null && (menu = EclipseWorkbenchProvider.getProvider().getViewMenu(workbenchPart, (IWorkbenchPartReference)viewReference, false)) != null && menu.equals(widget)) {
                    return workbenchPart;
                }
                ++n4;
            }
            ++n2;
        }
        return null;
    }

    public static boolean isOpenPespectiveButton(ToolItem item) {
        return TeslaSWTAccess.getThis(PerspectiveBarContributionItem.class, (Widget)item, (int)13) != null;
    }

    public static boolean isCTabFolderListMenuItem(MenuItem menuItem) {
        CTabFolder tabFolder = SWTWidgetLocator.getCTabFolder(menuItem);
        if (tabFolder != null) {
            Menu tabFolderItemListMenu = TeslaSWTAccess.getCTabFolderItemListMenu((CTabFolder)tabFolder);
            return menuItem.getParent().equals(tabFolderItemListMenu);
        }
        return false;
    }

    public static CTabFolder getCTabFolder(MenuItem menuItem) {
        return (CTabFolder)TeslaSWTAccess.getThis(CTabFolder.class, (Widget)menuItem, (int)13);
    }

    private static boolean isParentEclipseWindow(Menu menu) {
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().equals(menu.getParent());
    }

    public void addExtension(IWidgetLocatorExtension ext) {
        this.extensions.add(ext);
    }

    private static class EditorLocation {
        public String title;
        public String label;
        public Integer index;

        public EditorLocation(String title, String label, Integer index) {
            this.title = title;
            this.label = label;
            this.index = index;
        }
    }
}

