/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.Arrays;
import org.apache.lucene.index.DocValuesUpdate;
import org.apache.lucene.index.Term;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefArray;
import org.apache.lucene.util.BytesRefIterator;
import org.apache.lucene.util.Counter;
import org.apache.lucene.util.FixedBitSet;
import org.apache.lucene.util.RamUsageEstimator;

final class FieldUpdatesBuffer {
    private static final long SELF_SHALLOW_SIZE = RamUsageEstimator.shallowSizeOfInstance(FieldUpdatesBuffer.class);
    private static final long STRING_SHALLOW_SIZE = RamUsageEstimator.shallowSizeOfInstance(String.class);
    private final Counter bytesUsed;
    private int numUpdates = 1;
    private final BytesRefArray termValues;
    private final BytesRefArray byteValues;
    private int[] docsUpTo;
    private long[] numericValues;
    private FixedBitSet hasValues;
    private long maxNumeric = Long.MIN_VALUE;
    private long minNumeric = Long.MAX_VALUE;
    private String[] fields;
    private final boolean isNumeric;

    private FieldUpdatesBuffer(Counter bytesUsed, DocValuesUpdate initialValue, int docUpTo, boolean isNumeric) {
        this.bytesUsed = bytesUsed;
        this.bytesUsed.addAndGet(SELF_SHALLOW_SIZE);
        this.termValues = new BytesRefArray(bytesUsed);
        this.termValues.append(initialValue.term.bytes);
        this.fields = new String[]{initialValue.term.field};
        bytesUsed.addAndGet(FieldUpdatesBuffer.sizeOfString(initialValue.term.field));
        this.docsUpTo = new int[]{docUpTo};
        if (!initialValue.hasValue) {
            this.hasValues = new FixedBitSet(1);
            bytesUsed.addAndGet(this.hasValues.ramBytesUsed());
        }
        this.isNumeric = isNumeric;
        this.byteValues = isNumeric ? null : new BytesRefArray(bytesUsed);
    }

    private static long sizeOfString(String string) {
        return STRING_SHALLOW_SIZE + (long)(string.length() * 2);
    }

    FieldUpdatesBuffer(Counter bytesUsed, DocValuesUpdate.NumericDocValuesUpdate initialValue, int docUpTo) {
        this(bytesUsed, initialValue, docUpTo, true);
        if (initialValue.hasValue()) {
            this.numericValues = new long[]{initialValue.getValue()};
            this.maxNumeric = this.minNumeric = initialValue.getValue();
        } else {
            this.numericValues = new long[]{0L};
        }
        bytesUsed.addAndGet(8L);
    }

    FieldUpdatesBuffer(Counter bytesUsed, DocValuesUpdate.BinaryDocValuesUpdate initialValue, int docUpTo) {
        this(bytesUsed, initialValue, docUpTo, false);
        if (initialValue.hasValue()) {
            this.byteValues.append(initialValue.getValue());
        }
    }

    long getMaxNumeric() {
        assert (this.isNumeric);
        if (this.minNumeric == Long.MAX_VALUE && this.maxNumeric == Long.MIN_VALUE) {
            return 0L;
        }
        return this.maxNumeric;
    }

    long getMinNumeric() {
        assert (this.isNumeric);
        if (this.minNumeric == Long.MAX_VALUE && this.maxNumeric == Long.MIN_VALUE) {
            return 0L;
        }
        return this.minNumeric;
    }

    void add(String field, int docUpTo, int ord, boolean hasValue) {
        Object[] array;
        if (!this.fields[0].equals(field) || this.fields.length != 1) {
            if (this.fields.length <= ord) {
                array = ArrayUtil.grow(this.fields, ord + 1);
                if (this.fields.length == 1) {
                    Arrays.fill(array, 1, ord, this.fields[0]);
                }
                this.bytesUsed.addAndGet((array.length - this.fields.length) * RamUsageEstimator.NUM_BYTES_OBJECT_REF);
                this.fields = array;
            }
            if (field != this.fields[0]) {
                this.bytesUsed.addAndGet(FieldUpdatesBuffer.sizeOfString(field));
            }
            this.fields[ord] = field;
        }
        if (this.docsUpTo[0] != docUpTo || this.docsUpTo.length != 1) {
            if (this.docsUpTo.length <= ord) {
                array = ArrayUtil.grow(this.docsUpTo, ord + 1);
                if (this.docsUpTo.length == 1) {
                    Arrays.fill((int[])array, 1, ord, this.docsUpTo[0]);
                }
                this.bytesUsed.addAndGet((array.length - this.docsUpTo.length) * 4);
                this.docsUpTo = (int[])array;
            }
            this.docsUpTo[ord] = docUpTo;
        }
        if (!hasValue || this.hasValues != null) {
            if (this.hasValues == null) {
                this.hasValues = new FixedBitSet(ord + 1);
                this.hasValues.set(0, ord);
                this.bytesUsed.addAndGet(this.hasValues.ramBytesUsed());
            } else if (this.hasValues.length() <= ord) {
                FixedBitSet fixedBitSet = FixedBitSet.ensureCapacity(this.hasValues, ArrayUtil.oversize(ord + 1, 1));
                this.bytesUsed.addAndGet(fixedBitSet.ramBytesUsed() - this.hasValues.ramBytesUsed());
                this.hasValues = fixedBitSet;
            }
            if (hasValue) {
                this.hasValues.set(ord);
            }
        }
    }

    void addUpdate(Term term, long value, int docUpTo) {
        assert (this.isNumeric);
        int ord = this.append(term);
        String field = term.field;
        this.add(field, docUpTo, ord, true);
        this.minNumeric = Math.min(this.minNumeric, value);
        this.maxNumeric = Math.max(this.maxNumeric, value);
        if (this.numericValues[0] != value || this.numericValues.length != 1) {
            if (this.numericValues.length <= ord) {
                long[] array = ArrayUtil.grow(this.numericValues, ord + 1);
                if (this.numericValues.length == 1) {
                    Arrays.fill(array, 1, ord, this.numericValues[0]);
                }
                this.bytesUsed.addAndGet((array.length - this.numericValues.length) * 8);
                this.numericValues = array;
            }
            this.numericValues[ord] = value;
        }
    }

    void addNoValue(Term term, int docUpTo) {
        int ord = this.append(term);
        this.add(term.field, docUpTo, ord, false);
    }

    void addUpdate(Term term, BytesRef value, int docUpTo) {
        assert (!this.isNumeric);
        int ord = this.append(term);
        this.byteValues.append(value);
        this.add(term.field, docUpTo, ord, true);
    }

    private int append(Term term) {
        this.termValues.append(term.bytes);
        return this.numUpdates++;
    }

    BufferedUpdateIterator iterator() {
        return new BufferedUpdateIterator();
    }

    boolean isNumeric() {
        assert (this.isNumeric || this.byteValues != null);
        return this.isNumeric;
    }

    boolean hasSingleValue() {
        return this.isNumeric && this.numericValues.length == 1;
    }

    long getNumericValue(int idx) {
        if (this.hasValues != null && !this.hasValues.get(idx)) {
            return 0L;
        }
        return this.numericValues[FieldUpdatesBuffer.getArrayIndex(this.numericValues.length, idx)];
    }

    private static int getArrayIndex(int arrayLength, int index) {
        assert (arrayLength == 1 || arrayLength > index) : "illegal array index length: " + arrayLength + " index: " + index;
        return Math.min(arrayLength - 1, index);
    }

    static class BufferedUpdate {
        int docUpTo;
        long numericValue;
        BytesRef binaryValue;
        boolean hasValue;
        String termField;
        BytesRef termValue;

        private BufferedUpdate() {
        }

        public int hashCode() {
            throw new UnsupportedOperationException("this struct should not be use in map or other data-stuctures that use hashCode / equals");
        }

        public boolean equals(Object obj) {
            throw new UnsupportedOperationException("this struct should not be use in map or other data-stuctures that use hashCode / equals");
        }
    }

    class BufferedUpdateIterator {
        private final BytesRefIterator termValuesIterator;
        private final BytesRefIterator byteValuesIterator;
        private final BufferedUpdate bufferedUpdate = new BufferedUpdate();
        private final Bits updatesWithValue;
        private int index = 0;

        BufferedUpdateIterator() {
            this.termValuesIterator = FieldUpdatesBuffer.this.termValues.iterator();
            this.byteValuesIterator = FieldUpdatesBuffer.this.isNumeric ? null : FieldUpdatesBuffer.this.byteValues.iterator();
            this.updatesWithValue = FieldUpdatesBuffer.this.hasValues == null ? new Bits.MatchAllBits(FieldUpdatesBuffer.this.numUpdates) : FieldUpdatesBuffer.this.hasValues;
        }

        BufferedUpdate next() throws IOException {
            BytesRef next = this.termValuesIterator.next();
            if (next != null) {
                int idx = this.index++;
                this.bufferedUpdate.termValue = next;
                this.bufferedUpdate.hasValue = this.updatesWithValue.get(idx);
                this.bufferedUpdate.termField = FieldUpdatesBuffer.this.fields[FieldUpdatesBuffer.getArrayIndex(FieldUpdatesBuffer.this.fields.length, idx)];
                this.bufferedUpdate.docUpTo = FieldUpdatesBuffer.this.docsUpTo[FieldUpdatesBuffer.getArrayIndex(FieldUpdatesBuffer.this.docsUpTo.length, idx)];
                if (this.bufferedUpdate.hasValue) {
                    if (FieldUpdatesBuffer.this.isNumeric) {
                        this.bufferedUpdate.numericValue = FieldUpdatesBuffer.this.numericValues[FieldUpdatesBuffer.getArrayIndex(FieldUpdatesBuffer.this.numericValues.length, idx)];
                        this.bufferedUpdate.binaryValue = null;
                    } else {
                        this.bufferedUpdate.binaryValue = this.byteValuesIterator.next();
                    }
                } else {
                    this.bufferedUpdate.binaryValue = null;
                    this.bufferedUpdate.numericValue = 0L;
                }
                return this.bufferedUpdate;
            }
            return null;
        }
    }
}

