/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.wizards.preferences;

import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.wizards.preferences.PreferencesMessages;
import org.eclipse.ui.internal.wizards.preferences.WizardPreferencesExportPage1;

public class PreferencesExportWizard
extends Wizard
implements IExportWizard {
    private static final String EVENT_TOPIC_BASE = "org/eclipse/ui/internal/wizards/preferences/export/";
    public static final String EVENT_EXPORT_BEGIN = "org/eclipse/ui/internal/wizards/preferences/export/begin";
    public static final String EVENT_EXPORT_END = "org/eclipse/ui/internal/wizards/preferences/export/end";
    private WizardPreferencesExportPage1 mainPage;
    private IEventBroker eventBroker;

    public PreferencesExportWizard() {
        IDialogSettings workbenchSettings = WorkbenchPlugin.getDefault().getDialogSettings();
        IDialogSettings section = workbenchSettings.getSection("PreferencesExportWizard");
        if (section == null) {
            section = workbenchSettings.addNewSection("PreferencesExportWizard");
        }
        this.setDialogSettings(section);
    }

    public void addPages() {
        super.addPages();
        this.mainPage = new WizardPreferencesExportPage1();
        this.addPage((IWizardPage)this.mainPage);
    }

    @Override
    public void init(IWorkbench workbench, IStructuredSelection currentSelection) {
        this.eventBroker = (IEventBroker)workbench.getService(IEventBroker.class);
        this.setWindowTitle(PreferencesMessages.PreferencesExportWizard_export);
        this.setDefaultPageImageDescriptor(WorkbenchImages.getImageDescriptor("IMG_WIZBAN_EXPORT_PREF_WIZ"));
        this.setNeedsProgressMonitor(true);
    }

    public boolean performFinish() {
        this.sendEvent(EVENT_EXPORT_BEGIN);
        boolean success = this.mainPage.finish();
        this.sendEvent(EVENT_EXPORT_END);
        return success;
    }

    private void sendEvent(String topic) {
        if (this.eventBroker != null) {
            this.eventBroker.send(topic, null);
        }
    }
}

