/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.TreeMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.osgi.service.resolver.BaseDescription;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.BundleSpecification;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.osgi.service.resolver.HostSpecification;
import org.eclipse.osgi.service.resolver.ImportPackageSpecification;
import org.eclipse.osgi.service.resolver.StateHelper;
import org.eclipse.pde.core.IClasspathContributor;
import org.eclipse.pde.core.build.IBuild;
import org.eclipse.pde.core.build.IBuildEntry;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.ClasspathUtilCore;
import org.eclipse.pde.internal.core.PDEClasspathContainer;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.PDECoreMessages;
import org.eclipse.pde.internal.core.TargetPlatformHelper;
import org.eclipse.pde.internal.core.ibundle.IBundlePluginModelBase;

public class RequiredPluginsClasspathContainer
extends PDEClasspathContainer
implements IClasspathContainer {
    private static final Collection<String> JUNIT5_RUNTIME_PLUGINS = new HashSet<String>(Arrays.asList("org.junit", "org.junit.jupiter.api", "org.junit.jupiter.engine", "org.junit.platform.commons", "org.junit.platform.engine", "org.hamcrest.core", "org.opentest4j"));
    private final IPluginModelBase fModel;
    private IBuild fBuild;
    private IClasspathEntry[] fEntries;
    private boolean addImportedPackages;
    private static List<IClasspathContributor> fClasspathContributors = null;

    public RequiredPluginsClasspathContainer(IPluginModelBase model) {
        this(model, null);
    }

    public RequiredPluginsClasspathContainer(IPluginModelBase model, IBuild build) {
        this.fModel = model;
        this.fBuild = build;
    }

    public int getKind() {
        return 1;
    }

    public IPath getPath() {
        return PDECore.REQUIRED_PLUGINS_CONTAINER_PATH;
    }

    public String getDescription() {
        return PDECoreMessages.RequiredPluginsClasspathContainer_description;
    }

    public IClasspathEntry[] getClasspathEntries() {
        if (this.fModel == null) {
            if (PDECore.DEBUG_CLASSPATH) {
                System.out.println("********Returned an empty container");
            }
            return new IClasspathEntry[0];
        }
        if (this.fEntries == null) {
            this.fEntries = this.computePluginEntries();
        }
        if (PDECore.DEBUG_CLASSPATH) {
            System.out.println("Dependencies for plugin '" + this.fModel.getPluginBase().getId() + "':");
            IClasspathEntry[] iClasspathEntryArray = this.fEntries;
            int n = this.fEntries.length;
            int n2 = 0;
            while (n2 < n) {
                IClasspathEntry entry = iClasspathEntryArray[n2];
                System.out.println("\t" + entry);
                ++n2;
            }
        }
        return this.fEntries;
    }

    private IClasspathEntry[] computePluginEntries() {
        ArrayList<IClasspathEntry> entries = new ArrayList<IClasspathEntry>();
        try {
            int n;
            int n2;
            BundleDescription[] bundleDescriptionArray;
            BundleDescription desc = this.fModel.getBundleDescription();
            if (desc == null) {
                return new IClasspathEntry[0];
            }
            Map<BundleDescription, ArrayList<PDEClasspathContainer.Rule>> map = this.retrieveVisiblePackagesFromState(desc);
            for (IClasspathContributor cc : RequiredPluginsClasspathContainer.getClasspathContributors()) {
                List<IClasspathEntry> classpathEntries = cc.getInitialEntries(desc);
                if (classpathEntries == null || classpathEntries.isEmpty()) continue;
                entries.addAll(classpathEntries);
            }
            HashSet<BundleDescription> added = new HashSet<BundleDescription>();
            added.add(desc);
            HostSpecification host = desc.getHost();
            if (host != null) {
                this.addHostPlugin(host, added, map, entries);
            } else if ("true".equals(System.getProperty("pde.allowCycles"))) {
                BundleDescription[] fragments;
                bundleDescriptionArray = fragments = desc.getFragments();
                n2 = fragments.length;
                n = 0;
                while (n < n2) {
                    BundleDescription fragment = bundleDescriptionArray[n];
                    if (fragment.isResolved()) {
                        this.addPlugin(fragment, false, map, entries);
                    }
                    ++n;
                }
            }
            BundleSpecification[] required = desc.getRequiredBundles();
            bundleDescriptionArray = required;
            n2 = required.length;
            n = 0;
            while (n < n2) {
                BundleDescription element = bundleDescriptionArray[n];
                this.addDependency((BundleDescription)element.getSupplier(), added, map, entries);
                ++n;
            }
            if (this.fBuild == null) {
                this.fBuild = ClasspathUtilCore.getBuild(this.fModel);
            }
            if (this.fBuild != null) {
                this.addSecondaryDependencies(desc, added, entries);
            }
            TreeMap<String, BundleDescription> sortedMap = new TreeMap<String, BundleDescription>();
            for (BundleDescription bundle : map.keySet()) {
                sortedMap.put(bundle.toString(), bundle);
            }
            for (BundleDescription bundle : sortedMap.values()) {
                IPluginModelBase model = PluginRegistry.findModel(bundle);
                if (model == null || !model.isEnabled()) continue;
                this.addDependencyViaImportPackage(model.getBundleDescription(), added, map, entries);
            }
            if (this.fBuild != null) {
                this.addExtraClasspathEntries(added, entries);
            }
            this.addJunit5RuntimeDependencies(added, entries);
        }
        catch (CoreException coreException) {}
        return entries.toArray(new IClasspathEntry[entries.size()]);
    }

    private static synchronized List<IClasspathContributor> getClasspathContributors() {
        if (fClasspathContributors == null) {
            IConfigurationElement[] elements;
            fClasspathContributors = new ArrayList<IClasspathContributor>();
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            IConfigurationElement[] iConfigurationElementArray = elements = registry.getConfigurationElementsFor("org.eclipse.pde.core.pluginClasspathContributors");
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement element = iConfigurationElementArray[n2];
                try {
                    fClasspathContributors.add((IClasspathContributor)element.createExecutableExtension("class"));
                }
                catch (CoreException e) {
                    PDECore.log(e.getStatus());
                }
                ++n2;
            }
        }
        return fClasspathContributors;
    }

    private Map<BundleDescription, ArrayList<PDEClasspathContainer.Rule>> retrieveVisiblePackagesFromState(BundleDescription desc) {
        HashMap<BundleDescription, ArrayList<PDEClasspathContainer.Rule>> visiblePackages = new HashMap<BundleDescription, ArrayList<PDEClasspathContainer.Rule>>();
        StateHelper helper = Platform.getPlatformAdmin().getStateHelper();
        this.addVisiblePackagesFromState(helper, desc, visiblePackages);
        if (desc.getHost() != null) {
            this.addVisiblePackagesFromState(helper, (BundleDescription)desc.getHost().getSupplier(), visiblePackages);
        }
        return visiblePackages;
    }

    private void addVisiblePackagesFromState(StateHelper helper, BundleDescription desc, Map<BundleDescription, ArrayList<PDEClasspathContainer.Rule>> visiblePackages) {
        ExportPackageDescription[] exports;
        if (desc == null) {
            return;
        }
        ExportPackageDescription[] exportPackageDescriptionArray = exports = helper.getVisiblePackages(desc);
        int n = exports.length;
        int n2 = 0;
        while (n2 < n) {
            ExportPackageDescription export = exportPackageDescriptionArray[n2];
            BundleDescription exporter = export.getExporter();
            if (exporter != null) {
                PDEClasspathContainer.Rule rule;
                ArrayList<PDEClasspathContainer.Rule> list = visiblePackages.get(exporter);
                if (list == null) {
                    list = new ArrayList();
                    visiblePackages.put(exporter, list);
                }
                if (!list.contains(rule = this.getRule(helper, desc, export))) {
                    list.add(rule);
                }
            }
            ++n2;
        }
    }

    private PDEClasspathContainer.Rule getRule(StateHelper helper, BundleDescription desc, ExportPackageDescription export) {
        PDEClasspathContainer.Rule rule = new PDEClasspathContainer.Rule(this);
        rule.discouraged = helper.getAccessCode(desc, export) == 2;
        String name = export.getName();
        rule.path = name.equals(".") ? new Path("*") : new Path(String.valueOf(name.replaceAll("\\.", "/")) + "/*");
        return rule;
    }

    protected void addDependencyViaImportPackage(BundleDescription desc, HashSet<BundleDescription> added, Map<BundleDescription, ArrayList<PDEClasspathContainer.Rule>> map, ArrayList<IClasspathEntry> entries) throws CoreException {
        if (desc == null || !added.add(desc)) {
            return;
        }
        this.addPlugin(desc, true, map, entries);
        if (this.hasExtensibleAPI(desc) && desc.getContainingState() != null) {
            BundleDescription[] fragments;
            BundleDescription[] bundleDescriptionArray = fragments = desc.getFragments();
            int n = fragments.length;
            int n2 = 0;
            while (n2 < n) {
                BundleDescription fragment = bundleDescriptionArray[n2];
                if (fragment.isResolved()) {
                    this.addDependencyViaImportPackage(fragment, added, map, entries);
                }
                ++n2;
            }
        }
    }

    private void addDependency(BundleDescription desc, HashSet<BundleDescription> added, Map<BundleDescription, ArrayList<PDEClasspathContainer.Rule>> map, ArrayList<IClasspathEntry> entries) throws CoreException {
        this.addDependency(desc, added, map, entries, true);
    }

    private void addDependency(BundleDescription desc, HashSet<BundleDescription> added, Map<BundleDescription, ArrayList<PDEClasspathContainer.Rule>> map, ArrayList<IClasspathEntry> entries, boolean useInclusion) throws CoreException {
        BundleSpecification[] required;
        BundleDescription[] fragments;
        if (desc == null || !added.add(desc)) {
            return;
        }
        BundleDescription[] bundleDescriptionArray = fragments = this.hasExtensibleAPI(desc) ? desc.getFragments() : new BundleDescription[]{};
        int n = fragments.length;
        int n2 = 0;
        while (n2 < n) {
            BundleDescription fragment = bundleDescriptionArray[n2];
            if (fragment.isResolved() && ClasspathUtilCore.isPatchFragment(fragment)) {
                this.addDependency(fragment, added, map, entries, useInclusion);
            }
            ++n2;
        }
        this.addPlugin(desc, useInclusion, map, entries);
        int i = 0;
        while (i < fragments.length) {
            if (fragments[i].isResolved() && !ClasspathUtilCore.isPatchFragment(fragments[i])) {
                this.addDependency(fragments[i], added, map, entries, useInclusion);
            }
            ++i;
        }
        BundleSpecification[] bundleSpecificationArray = required = desc.getRequiredBundles();
        int n3 = required.length;
        n = 0;
        while (n < n3) {
            BundleSpecification element = bundleSpecificationArray[n];
            if (element.isExported()) {
                this.addDependency((BundleDescription)element.getSupplier(), added, map, entries, useInclusion);
            }
            ++n;
        }
        if (this.addImportedPackages) {
            ImportPackageSpecification[] imports;
            ImportPackageSpecification[] importPackageSpecificationArray = imports = desc.getImportPackages();
            int n4 = imports.length;
            n3 = 0;
            while (n3 < n4) {
                ImportPackageSpecification importSpec = importPackageSpecificationArray[n3];
                BaseDescription supplier = importSpec.getSupplier();
                if (supplier instanceof ExportPackageDescription) {
                    this.addDependencyViaImportPackage(((ExportPackageDescription)supplier).getExporter(), added, map, entries);
                }
                ++n3;
            }
        }
    }

    private boolean addPlugin(BundleDescription desc, boolean useInclusions, Map<BundleDescription, ArrayList<PDEClasspathContainer.Rule>> map, ArrayList<IClasspathEntry> entries) throws CoreException {
        IPluginModelBase model = PluginRegistry.findModel(desc);
        if (model == null || !model.isEnabled()) {
            return false;
        }
        IResource resource = model.getUnderlyingResource();
        PDEClasspathContainer.Rule[] rules = useInclusions ? this.getInclusions(map, model) : null;
        BundleDescription hostBundle = this.fModel.getBundleDescription();
        if (desc == null) {
            return false;
        }
        for (IClasspathContributor cc : RequiredPluginsClasspathContainer.getClasspathContributors()) {
            List<IClasspathEntry> classpathEntries = cc.getEntriesForDependency(hostBundle, desc);
            if (classpathEntries == null || classpathEntries.isEmpty()) continue;
            entries.addAll(classpathEntries);
        }
        if (resource != null) {
            this.addProjectEntry(resource.getProject(), rules, entries);
        } else {
            RequiredPluginsClasspathContainer.addExternalPlugin(model, rules, entries);
        }
        return true;
    }

    private PDEClasspathContainer.Rule[] getInclusions(Map<BundleDescription, ArrayList<PDEClasspathContainer.Rule>> map, IPluginModelBase model) {
        BundleDescription desc = model.getBundleDescription();
        if (desc == null || "false".equals(System.getProperty("pde.restriction")) || !(this.fModel instanceof IBundlePluginModelBase) || TargetPlatformHelper.getTargetVersion() < 3.1) {
            return null;
        }
        PDEClasspathContainer.Rule[] rules = desc.getHost() != null ? this.getInclusions(map, (BundleDescription)desc.getHost().getSupplier()) : this.getInclusions(map, desc);
        return rules.length == 0 && !ClasspathUtilCore.hasBundleStructure(model) ? null : rules;
    }

    private PDEClasspathContainer.Rule[] getInclusions(Map<BundleDescription, ArrayList<PDEClasspathContainer.Rule>> map, BundleDescription desc) {
        ArrayList<PDEClasspathContainer.Rule> list = map.get(desc);
        return list != null ? list.toArray(new PDEClasspathContainer.Rule[list.size()]) : new PDEClasspathContainer.Rule[]{};
    }

    private void addHostPlugin(HostSpecification hostSpec, HashSet<BundleDescription> added, Map<BundleDescription, ArrayList<PDEClasspathContainer.Rule>> map, ArrayList<IClasspathEntry> entries) throws CoreException {
        BundleDescription host;
        BaseDescription desc = hostSpec.getSupplier();
        if (desc instanceof BundleDescription && added.add(host = (BundleDescription)desc) && this.addPlugin(host, false, map, entries)) {
            ImportPackageSpecification[] imports;
            BundleSpecification[] required;
            BundleSpecification[] bundleSpecificationArray = required = host.getRequiredBundles();
            int n = required.length;
            int n2 = 0;
            while (n2 < n) {
                BundleSpecification bundleSpec = bundleSpecificationArray[n2];
                this.addDependency((BundleDescription)bundleSpec.getSupplier(), added, map, entries);
                ++n2;
            }
            ImportPackageSpecification[] importPackageSpecificationArray = imports = host.getImportPackages();
            int n3 = imports.length;
            n = 0;
            while (n < n3) {
                ImportPackageSpecification importSpec = importPackageSpecificationArray[n];
                BaseDescription supplier = importSpec.getSupplier();
                if (supplier instanceof ExportPackageDescription) {
                    this.addDependencyViaImportPackage(((ExportPackageDescription)supplier).getExporter(), added, map, entries);
                }
                ++n;
            }
        }
    }

    private boolean hasExtensibleAPI(BundleDescription desc) {
        IPluginModelBase model = PluginRegistry.findModel(desc);
        return model != null ? ClasspathUtilCore.hasExtensibleAPI(model) : false;
    }

    protected void addExtraClasspathEntries(HashSet<BundleDescription> added, ArrayList<IClasspathEntry> entries) {
        IBuildEntry[] buildEntries;
        IBuildEntry[] iBuildEntryArray = buildEntries = this.fBuild.getBuildEntries();
        int n = buildEntries.length;
        int n2 = 0;
        while (n2 < n) {
            IBuildEntry entry = iBuildEntryArray[n2];
            String name = entry.getName();
            if (name.equals("jars.extra.classpath") || name.startsWith("extra.")) {
                this.addExtraClasspathEntries(added, entries, entry.getTokens());
            }
            ++n2;
        }
    }

    protected void addExtraClasspathEntries(HashSet<BundleDescription> added, ArrayList<IClasspathEntry> entries, String[] tokens) {
        String[] stringArray = tokens;
        int n = tokens.length;
        int n2 = 0;
        while (n2 < n) {
            block13: {
                IPath path;
                block11: {
                    block12: {
                        IFile resource;
                        String token = stringArray[n2];
                        path = Path.fromPortableString((String)token);
                        if (path.isAbsolute()) break block11;
                        File file = new File(this.fModel.getInstallLocation(), path.toString());
                        if (!file.exists() || (resource = PDECore.getWorkspace().getRoot().getFileForLocation((IPath)new Path(file.getAbsolutePath()))) == null || !resource.getProject().equals((Object)this.fModel.getUnderlyingResource().getProject())) break block12;
                        this.addExtraLibrary(resource.getFullPath(), null, entries);
                        break block13;
                    }
                    if (path.segmentCount() < 3 || !"..".equals(path.segment(0))) break block13;
                    path = path.removeFirstSegments(1);
                    path = Path.fromPortableString((String)"platform:/plugin/").append(path);
                }
                if (!path.toPortableString().startsWith("platform:")) {
                    this.addExtraLibrary(path, null, entries);
                } else {
                    String pluginID;
                    IPluginModelBase model;
                    int count;
                    int n3 = count = path.getDevice() == null ? 4 : 3;
                    if (path.segmentCount() >= count && (model = PluginRegistry.findModel(pluginID = path.segment(count - 2))) != null && model.isEnabled()) {
                        path = path.setDevice(null);
                        path = path.removeFirstSegments(count - 1);
                        IResource underlyingResource = model.getUnderlyingResource();
                        if (underlyingResource == null) {
                            IPath result = PDECore.getDefault().getModelManager().getExternalModelManager().getNestedLibrary(model, path.toString());
                            if (result != null) {
                                this.addExtraLibrary(result, model, entries);
                            }
                        } else {
                            IProject project = underlyingResource.getProject();
                            IFile file = project.getFile(path);
                            if (file.exists()) {
                                this.addExtraLibrary(file.getFullPath(), model, entries);
                            }
                        }
                    }
                }
            }
            ++n2;
        }
    }

    private void addJunit5RuntimeDependencies(HashSet<BundleDescription> added, ArrayList<IClasspathEntry> entries) throws CoreException {
        if (!RequiredPluginsClasspathContainer.containsJunit5Dependency(added)) {
            return;
        }
        if (JUNIT5_RUNTIME_PLUGINS.contains(this.fModel.getPluginBase().getId())) {
            return;
        }
        for (String pluginId : JUNIT5_RUNTIME_PLUGINS) {
            BundleDescription desc;
            IPluginModelBase model = PluginRegistry.findModel(pluginId);
            if (model == null || !model.isEnabled() || added.contains(desc = model.getBundleDescription())) continue;
            Map<BundleDescription, ArrayList<PDEClasspathContainer.Rule>> rules = Collections.singletonMap(desc, new ArrayList());
            this.addPlugin(desc, true, rules, entries);
        }
    }

    private static boolean containsJunit5Dependency(Collection<BundleDescription> dependencies) {
        return dependencies.stream().anyMatch(desc -> "org.junit.jupiter.api".equals(desc.getName()));
    }

    private void addSecondaryDependencies(BundleDescription desc, HashSet<BundleDescription> added, ArrayList<IClasspathEntry> entries) {
        try {
            IBuildEntry entry = this.fBuild.getEntry("additional.bundles");
            if (entry != null) {
                String[] tokens;
                String[] stringArray = tokens = entry.getTokens();
                int n = tokens.length;
                int n2 = 0;
                while (n2 < n) {
                    BundleDescription bundleDesc;
                    String pluginId = stringArray[n2];
                    IPluginModelBase model = PluginRegistry.findModel(pluginId);
                    if (model != null && !added.contains(bundleDesc = model.getBundleDescription())) {
                        HashMap<BundleDescription, ArrayList<PDEClasspathContainer.Rule>> rules = new HashMap<BundleDescription, ArrayList<PDEClasspathContainer.Rule>>();
                        this.findExportedPackages(bundleDesc, desc, rules);
                        this.addDependency(bundleDesc, added, rules, entries, true);
                    }
                    ++n2;
                }
            }
        }
        catch (CoreException coreException) {
            return;
        }
    }

    protected final void findExportedPackages(BundleDescription desc, BundleDescription projectDesc, Map<BundleDescription, ArrayList<PDEClasspathContainer.Rule>> map) {
        if (desc != null) {
            Stack<Object> stack = new Stack<Object>();
            stack.add(desc);
            while (!stack.isEmpty()) {
                BundleSpecification[] requiredBundles;
                BundleDescription bdesc = (BundleDescription)stack.pop();
                ExportPackageDescription[] expkgs = bdesc.getExportPackages();
                ArrayList<PDEClasspathContainer.Rule> rules = new ArrayList<PDEClasspathContainer.Rule>();
                ExportPackageDescription[] exportPackageDescriptionArray = expkgs;
                int n = expkgs.length;
                int n2 = 0;
                while (n2 < n) {
                    ExportPackageDescription expkg = exportPackageDescriptionArray[n2];
                    PDEClasspathContainer.Rule rule = new PDEClasspathContainer.Rule(this);
                    rule.discouraged = this.restrictPackage(projectDesc, expkg);
                    rule.path = new Path(String.valueOf(expkg.getName().replaceAll("\\.", "/")) + "/*");
                    rules.add(rule);
                    ++n2;
                }
                map.put(bdesc, rules);
                BundleSpecification[] bundleSpecificationArray = requiredBundles = bdesc.getRequiredBundles();
                int n3 = requiredBundles.length;
                n = 0;
                while (n < n3) {
                    BaseDescription bd;
                    BundleSpecification requiredBundle = bundleSpecificationArray[n];
                    if (requiredBundle.isExported() && (bd = requiredBundle.getSupplier()) != null && bd instanceof BundleDescription) {
                        stack.add(bd);
                    }
                    ++n;
                }
            }
        }
    }

    private boolean restrictPackage(BundleDescription desc, ExportPackageDescription pkg) {
        String[] friends = (String[])pkg.getDirective("x-friends");
        if (friends != null) {
            String symbolicName = desc.getSymbolicName();
            String[] stringArray = friends;
            int n = friends.length;
            int n2 = 0;
            while (n2 < n) {
                String friend = stringArray[n2];
                if (symbolicName.equals(friend)) {
                    return false;
                }
                ++n2;
            }
            return true;
        }
        return (Boolean)pkg.getDirective("x-internal");
    }

    private void addExtraLibrary(IPath path, IPluginModelBase model, ArrayList<IClasspathEntry> entries) {
        if (path.segmentCount() > 1) {
            IPath srcPath = null;
            if (model != null) {
                IPath shortPath = path.removeFirstSegments(path.matchingFirstSegments((IPath)new Path(model.getInstallLocation())));
                srcPath = ClasspathUtilCore.getSourceAnnotation(model, shortPath.toString());
            } else {
                String filename = ClasspathUtilCore.getSourceZipName(path.lastSegment());
                IPath candidate = path.removeLastSegments(1).append(filename);
                if (PDECore.getWorkspace().getRoot().getFile(candidate).exists()) {
                    srcPath = candidate;
                }
            }
            IClasspathEntry clsEntry = JavaCore.newLibraryEntry((IPath)path, (IPath)srcPath, null);
            if (!entries.contains(clsEntry)) {
                entries.add(clsEntry);
            }
        }
    }

    public List<IProject> getAllProjectDependencies() {
        ArrayList<IProject> projects = new ArrayList<IProject>();
        IWorkspaceRoot root = PDECore.getWorkspace().getRoot();
        try {
            IClasspathEntry[] entries;
            this.addImportedPackages = true;
            IClasspathEntry[] iClasspathEntryArray = entries = this.computePluginEntries();
            int n = entries.length;
            int n2 = 0;
            while (n2 < n) {
                IProject project;
                IClasspathEntry cpe = iClasspathEntryArray[n2];
                if (cpe.getEntryKind() == 2 && (project = root.getProject(cpe.getPath().lastSegment())).exists()) {
                    projects.add(project);
                }
                ++n2;
            }
        }
        finally {
            this.addImportedPackages = false;
        }
        return projects;
    }
}

