/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text.source;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IPaintPositionManager;
import org.eclipse.jface.text.IPainter;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.jface.text.source.ICharacterPairMatcher;
import org.eclipse.jface.text.source.ICharacterPairMatcherExtension;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

public final class MatchingCharacterPainter
implements IPainter,
PaintListener {
    private boolean fIsActive = false;
    private ISourceViewer fSourceViewer;
    private StyledText fTextWidget;
    private Color fColor;
    private IPaintPositionManager fPaintPositionManager;
    private ICharacterPairMatcher fMatcher;
    private Position fPairPosition = new Position(0, 0);
    private int fAnchor;
    private boolean fHighlightEnclosingPeerCharacters;
    private boolean fHighlightCharacterAtCaretLocation;
    private boolean fCharacterPresentAtCaretLocation;
    private IRegion fPreviousSelection;
    private int fPreviousLengthOfDocument;
    private TextListener fTextListener;

    public MatchingCharacterPainter(ISourceViewer sourceViewer, ICharacterPairMatcher matcher) {
        this.fSourceViewer = sourceViewer;
        this.fMatcher = matcher;
        this.fTextWidget = sourceViewer.getTextWidget();
    }

    public void setHighlightCharacterAtCaretLocation(boolean highlightCharacterAtCaretLocation) {
        this.handleDrawRequest(null);
        this.fHighlightCharacterAtCaretLocation = highlightCharacterAtCaretLocation;
    }

    public void setHighlightEnclosingPeerCharacters(boolean highlightEnclosingPeerCharcters) {
        this.fHighlightEnclosingPeerCharacters = highlightEnclosingPeerCharcters;
        this.installUninstallTextListener(highlightEnclosingPeerCharcters);
    }

    public void setColor(Color color) {
        this.fColor = color;
    }

    @Override
    public void dispose() {
        if (this.fMatcher != null) {
            if (this.fMatcher instanceof ICharacterPairMatcherExtension && this.fTextListener != null) {
                this.installUninstallTextListener(false);
            }
            this.fMatcher.clear();
            this.fMatcher = null;
        }
        this.fColor = null;
        this.fTextWidget = null;
    }

    @Override
    public void deactivate(boolean redraw) {
        if (this.fIsActive) {
            this.fIsActive = false;
            this.fTextWidget.removePaintListener((PaintListener)this);
            if (this.fPaintPositionManager != null) {
                this.fPaintPositionManager.unmanagePosition(this.fPairPosition);
            }
            if (redraw) {
                this.handleDrawRequest(null);
            }
        }
        this.fPreviousSelection = null;
    }

    public void paintControl(PaintEvent event) {
        if (this.fTextWidget != null) {
            this.handleDrawRequest(event.gc);
        }
    }

    private void handleDrawRequest(GC gc) {
        if (this.fPairPosition.isDeleted) {
            return;
        }
        int offset = this.fPairPosition.getOffset();
        int length = this.fPairPosition.getLength();
        if (length < 1) {
            return;
        }
        if (this.fSourceViewer instanceof ITextViewerExtension5) {
            ITextViewerExtension5 extension = (ITextViewerExtension5)((Object)this.fSourceViewer);
            IRegion widgetRange = extension.modelRange2WidgetRange((IRegion)new Region(offset, length));
            if (widgetRange == null) {
                return;
            }
            try {
                IDocument doc = this.fSourceViewer.getDocument();
                int startLine = doc.getLineOfOffset(offset);
                int endLine = doc.getLineOfOffset(offset + length);
                if (extension.modelLine2WidgetLine(startLine) == -1 || extension.modelLine2WidgetLine(endLine) == -1) {
                    return;
                }
            }
            catch (BadLocationException badLocationException) {
                return;
            }
            offset = widgetRange.getOffset();
            length = widgetRange.getLength();
        } else {
            IRegion region = this.fSourceViewer.getVisibleRegion();
            if (region.getOffset() > offset || region.getOffset() + region.getLength() < offset + length) {
                return;
            }
            offset -= region.getOffset();
        }
        if (this.fHighlightCharacterAtCaretLocation || this.fHighlightEnclosingPeerCharacters && !this.fCharacterPresentAtCaretLocation) {
            this.draw(gc, offset);
            this.draw(gc, offset + length - 1);
        } else if (this.fAnchor == 0) {
            this.draw(gc, offset);
        } else {
            this.draw(gc, offset + length - 1);
        }
    }

    private void draw(GC gc, int offset) {
        int length = 1;
        if (gc != null) {
            gc.setForeground(this.fColor);
            Rectangle bounds = this.fTextWidget.getTextBounds(offset, offset + length - 1);
            int height = this.fTextWidget.getCaret().getSize().y;
            gc.drawRectangle(bounds.x, bounds.y + bounds.height - height, bounds.width - 1, height - 1);
        } else {
            this.fTextWidget.redrawRange(offset, length, true);
        }
    }

    private static final IRegion getSignedSelection(ISourceViewer sourceViewer) {
        Point viewerSelection = sourceViewer.getSelectedRange();
        StyledText text = sourceViewer.getTextWidget();
        Point selection = text.getSelectionRange();
        if (text.getCaretOffset() == selection.x) {
            viewerSelection.x += viewerSelection.y;
            viewerSelection.y = -viewerSelection.y;
        }
        return new Region(viewerSelection.x, viewerSelection.y);
    }

    @Override
    public void paint(int reason) {
        boolean characterPresentAtCaretLocation;
        IRegion pair;
        IDocument document = this.fSourceViewer.getDocument();
        if (document == null) {
            this.deactivate(false);
            return;
        }
        IRegion selection = MatchingCharacterPainter.getSignedSelection(this.fSourceViewer);
        if (this.fMatcher instanceof ICharacterPairMatcherExtension) {
            ICharacterPairMatcherExtension matcher = (ICharacterPairMatcherExtension)((Object)this.fMatcher);
            pair = matcher.match(document, selection.getOffset(), selection.getLength());
            boolean bl = characterPresentAtCaretLocation = pair != null;
            if (pair == null && this.fHighlightEnclosingPeerCharacters) {
                int length = document.getLength();
                boolean lengthChanged = length != this.fPreviousLengthOfDocument;
                this.fPreviousLengthOfDocument = length;
                if (reason != 16 && this.fSourceViewer.getDocument() == document && !lengthChanged && (selection.equals(this.fPreviousSelection) || this.fPreviousSelection == null)) {
                    return;
                }
                if (reason == 1) {
                    this.fPreviousSelection = selection;
                    return;
                }
                if (reason != 16 && !lengthChanged && this.fPreviousSelection != null && reason != 8 && !matcher.isRecomputationOfEnclosingPairRequired(document, selection, this.fPreviousSelection)) {
                    if (this.fCharacterPresentAtCaretLocation && !this.fHighlightCharacterAtCaretLocation) {
                        this.fCharacterPresentAtCaretLocation = false;
                        this.handleDrawRequest(null);
                    }
                    this.fPreviousSelection = selection;
                    return;
                }
                pair = matcher.findEnclosingPeerCharacters(document, selection.getOffset(), selection.getLength());
            }
        } else {
            if (Math.abs(selection.getLength()) > 0) {
                this.deactivate(true);
                return;
            }
            pair = this.fMatcher.match(document, selection.getOffset());
            characterPresentAtCaretLocation = pair != null;
        }
        this.fPreviousSelection = selection;
        if (pair == null) {
            this.deactivate(true);
            return;
        }
        if (this.fIsActive) {
            if (16 == reason) {
                this.handleDrawRequest(null);
            } else if (pair.getOffset() != this.fPairPosition.getOffset() || pair.getLength() != this.fPairPosition.getLength() || this.fMatcher.getAnchor() != this.fAnchor || characterPresentAtCaretLocation != this.fCharacterPresentAtCaretLocation) {
                this.handleDrawRequest(null);
                this.fPairPosition.isDeleted = false;
                this.fPairPosition.offset = pair.getOffset();
                this.fPairPosition.length = pair.getLength();
                this.fAnchor = this.fMatcher.getAnchor();
                this.fCharacterPresentAtCaretLocation = characterPresentAtCaretLocation;
                this.handleDrawRequest(null);
            }
        } else {
            this.fIsActive = true;
            this.fPairPosition.isDeleted = false;
            this.fPairPosition.offset = pair.getOffset();
            this.fPairPosition.length = pair.getLength();
            this.fAnchor = this.fMatcher.getAnchor();
            this.fCharacterPresentAtCaretLocation = characterPresentAtCaretLocation;
            this.fTextWidget.addPaintListener((PaintListener)this);
            this.fPaintPositionManager.managePosition(this.fPairPosition);
            this.handleDrawRequest(null);
        }
    }

    @Override
    public void setPositionManager(IPaintPositionManager manager) {
        this.fPaintPositionManager = manager;
    }

    private void installUninstallTextListener(boolean install) {
        if (!(this.fMatcher instanceof ICharacterPairMatcherExtension)) {
            return;
        }
        if (install) {
            this.fTextListener = new TextListener();
            this.fSourceViewer.addTextListener(this.fTextListener);
        } else if (this.fTextListener != null) {
            this.fSourceViewer.removeTextListener(this.fTextListener);
            this.fTextListener = null;
        }
    }

    private class TextListener
    implements ITextListener {
        private TextListener() {
        }

        @Override
        public void textChanged(TextEvent event) {
            if (!MatchingCharacterPainter.this.fHighlightEnclosingPeerCharacters || !(MatchingCharacterPainter.this.fMatcher instanceof ICharacterPairMatcherExtension)) {
                return;
            }
            if (!event.getViewerRedrawState()) {
                return;
            }
            String text = event.getText();
            String replacedText = event.getReplacedText();
            ICharacterPairMatcherExtension matcher = (ICharacterPairMatcherExtension)((Object)MatchingCharacterPainter.this.fMatcher);
            if (this.searchForCharacters(text, matcher) || this.searchForCharacters(replacedText, matcher)) {
                MatchingCharacterPainter.this.paint(8);
            }
        }

        private boolean searchForCharacters(String text, ICharacterPairMatcherExtension matcher) {
            if (text == null) {
                return false;
            }
            int i = 0;
            while (i < text.length()) {
                if (matcher.isMatchedChar(text.charAt(i))) {
                    return true;
                }
                ++i;
            }
            return false;
        }
    }
}

