/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Predicate;
import org.eclipse.jdt.core.CompletionContext;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.manipulation.SharedASTProviderCore;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.template.java.SignatureUtil;
import org.eclipse.jdt.internal.ui.text.ChainElement;

public final class TypeBindingAnalyzer {
    private static final Predicate<IVariableBinding> NON_STATIC_FIELDS_ONLY_FILTER = new Predicate<IVariableBinding>(){

        @Override
        public boolean test(IVariableBinding t) {
            return !Modifier.isStatic((int)t.getModifiers());
        }
    };
    private static final Predicate<IMethodBinding> RELEVANT_NON_STATIC_METHODS_ONLY_FILTER = new Predicate<IMethodBinding>(){

        @Override
        public boolean test(IMethodBinding m) {
            return !Modifier.isStatic((int)m.getModifiers()) && !TypeBindingAnalyzer.isVoid(m) && !m.isConstructor();
        }
    };
    private static final Predicate<IVariableBinding> STATIC_FIELDS_ONLY_FILTER = new Predicate<IVariableBinding>(){

        @Override
        public boolean test(IVariableBinding t) {
            return Modifier.isStatic((int)t.getModifiers());
        }
    };
    private static final Predicate<IMethodBinding> STATIC_NON_VOID_NON_PRIMITIVE_METHODS_ONLY_FILTER = new Predicate<IMethodBinding>(){

        @Override
        public boolean test(IMethodBinding m) {
            return Modifier.isStatic((int)m.getModifiers()) && !TypeBindingAnalyzer.isVoid(m) && !m.isConstructor();
        }
    };

    private TypeBindingAnalyzer() {
    }

    private static boolean isVoid(IMethodBinding m) {
        return TypeBindingAnalyzer.hasPrimitiveReturnType(m) && Bindings.isVoidType(m.getReturnType());
    }

    private static boolean hasPrimitiveReturnType(IMethodBinding m) {
        return m.getReturnType().isPrimitive();
    }

    public static Collection<IBinding> findVisibleInstanceFieldsAndRelevantInstanceMethods(ITypeBinding type, ITypeBinding receiverType) {
        return TypeBindingAnalyzer.findFieldsAndMethods(type, receiverType, NON_STATIC_FIELDS_ONLY_FILTER, RELEVANT_NON_STATIC_METHODS_ONLY_FILTER);
    }

    public static Collection<IBinding> findAllPublicStaticFieldsAndNonVoidNonPrimitiveStaticMethods(ITypeBinding type, ITypeBinding receiverType) {
        return TypeBindingAnalyzer.findFieldsAndMethods(type, receiverType, STATIC_FIELDS_ONLY_FILTER, STATIC_NON_VOID_NON_PRIMITIVE_METHODS_ONLY_FILTER);
    }

    private static Collection<IBinding> findFieldsAndMethods(ITypeBinding type, ITypeBinding receiverType, Predicate<IVariableBinding> fieldFilter, Predicate<IMethodBinding> methodFilter) {
        LinkedHashMap<String, IMethodBinding> tmp = new LinkedHashMap<String, IMethodBinding>();
        for (ITypeBinding cur : TypeBindingAnalyzer.findAllSupertypesIncludingArgument(type)) {
            String key;
            IMethodBinding[] iMethodBindingArray = cur.getDeclaredMethods();
            int n = iMethodBindingArray.length;
            int n2 = 0;
            while (n2 < n) {
                IMethodBinding method = iMethodBindingArray[n2];
                if (methodFilter.test(method) && TypeBindingAnalyzer.methodCanBeSeenBy(method, receiverType) && !tmp.containsKey(key = TypeBindingAnalyzer.createMethodKey(method))) {
                    tmp.put(key, method);
                }
                ++n2;
            }
            iMethodBindingArray = cur.getDeclaredFields();
            n = iMethodBindingArray.length;
            n2 = 0;
            while (n2 < n) {
                IMethodBinding field = iMethodBindingArray[n2];
                if (fieldFilter.test((IVariableBinding)field) && TypeBindingAnalyzer.fieldCanBeSeenBy((IVariableBinding)field, receiverType) && !tmp.containsKey(key = TypeBindingAnalyzer.createFieldKey((IVariableBinding)field))) {
                    tmp.put(key, field);
                }
                ++n2;
            }
        }
        return tmp.values();
    }

    private static List<ITypeBinding> findAllSupertypesIncludingArgument(ITypeBinding type) {
        ITypeBinding base = TypeBindingAnalyzer.removeArrayWrapper(type);
        if (base.isPrimitive() || Bindings.isVoidType(type)) {
            return Collections.emptyList();
        }
        LinkedList<ITypeBinding> supertypes = new LinkedList<ITypeBinding>();
        LinkedList<ITypeBinding> queue = new LinkedList<ITypeBinding>();
        queue.add(base);
        while (!queue.isEmpty()) {
            ITypeBinding superType = (ITypeBinding)queue.poll();
            if (superType == null || supertypes.contains(superType)) continue;
            supertypes.add(superType);
            queue.add(superType.getSuperclass());
            ITypeBinding[] iTypeBindingArray = superType.getInterfaces();
            int n = iTypeBindingArray.length;
            int n2 = 0;
            while (n2 < n) {
                ITypeBinding interfc = iTypeBindingArray[n2];
                queue.add(interfc);
                ++n2;
            }
        }
        return supertypes;
    }

    private static String createFieldKey(IVariableBinding field) {
        StringBuilder ret = new StringBuilder(field.getName());
        try {
            String typeSignature = ((IField)field.getJavaElement()).getTypeSignature();
            return ret.append(typeSignature).toString();
        }
        catch (JavaModelException javaModelException) {
            return ret.toString();
        }
    }

    private static String createMethodKey(IMethodBinding method) {
        if (method.getJavaElement() instanceof IMethod) {
            StringBuilder ret = new StringBuilder().append(method.getName());
            try {
                IMethod m = (IMethod)method.getJavaElement();
                String signature = String.valueOf(m.getSignature());
                int index = signature.lastIndexOf(")");
                String signatureWithoutReturnType = index == -1 ? signature : signature.substring(0, index);
                return ret.append(signatureWithoutReturnType).toString();
            }
            catch (JavaModelException javaModelException) {
                return ret.toString();
            }
        }
        return null;
    }

    public static boolean isAssignable(ChainElement edge, ITypeBinding expectedType, int expectedDimension) {
        if (expectedDimension <= edge.getReturnTypeDimension()) {
            ITypeBinding base = TypeBindingAnalyzer.removeArrayWrapper(edge.getReturnType());
            if (base.isAssignmentCompatible(expectedType)) {
                return true;
            }
            LinkedList<ITypeBinding> supertypes = new LinkedList<ITypeBinding>();
            supertypes.add(base);
            String expectedSignature = expectedType.getBinaryName();
            while (!supertypes.isEmpty()) {
                ITypeBinding type = (ITypeBinding)supertypes.poll();
                String typeSignature = type.getBinaryName();
                if (typeSignature.equals(expectedSignature)) {
                    return true;
                }
                ITypeBinding superclass = type.getSuperclass();
                if (superclass != null) {
                    supertypes.add(superclass);
                }
                ITypeBinding[] iTypeBindingArray = type.getInterfaces();
                int n = iTypeBindingArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ITypeBinding intf = iTypeBindingArray[n2];
                    supertypes.add(intf);
                    ++n2;
                }
            }
        }
        return false;
    }

    public static ITypeBinding removeArrayWrapper(ITypeBinding type) {
        if (type.getComponentType() != null) {
            ITypeBinding base = type;
            while (base.getComponentType() != null) {
                base = base.getComponentType();
            }
            return base;
        }
        return type;
    }

    public static List<ITypeBinding> resolveBindingsForExpectedTypes(IJavaProject proj, ICompilationUnit cu, CompletionContext ctx) {
        LinkedList<ITypeBinding> bindings = new LinkedList<ITypeBinding>();
        IType expectedTypeSig = TypeBindingAnalyzer.getExpectedType(proj, ctx);
        if (expectedTypeSig == null) {
            AST ast;
            CompilationUnit cuNode = SharedASTProviderCore.getAST((ITypeRoot)cu, SharedASTProviderCore.WAIT_NO, null);
            if (cuNode != null) {
                ast = cuNode.getAST();
            } else {
                ASTParser parser = TypeBindingAnalyzer.createParser(cu, false);
                ast = parser.createAST(null).getAST();
            }
            ITypeBinding binding = ast.resolveWellKnownType(TypeBindingAnalyzer.getExpectedFullyQualifiedTypeName(ctx));
            int dim = TypeBindingAnalyzer.getArrayDimension(ctx.getExpectedTypesSignatures());
            if (dim > 0) {
                binding = binding.createArrayType(dim);
            }
            bindings.add(binding);
        } else {
            IBinding[] res = TypeBindingAnalyzer.resolveBindingsForElements(cu, new IJavaElement[]{expectedTypeSig}, true);
            if (res.length == 1 && res[0] instanceof ITypeBinding) {
                bindings.add((ITypeBinding)res[0]);
            }
        }
        return bindings;
    }

    public static IType getExpectedType(IJavaProject proj, CompletionContext ctx) {
        IType expected = null;
        String fqExpectedType = TypeBindingAnalyzer.getExpectedFullyQualifiedTypeName(ctx);
        if (fqExpectedType != null) {
            try {
                expected = proj.findType(fqExpectedType);
            }
            catch (JavaModelException javaModelException) {}
        }
        return expected;
    }

    public static String getExpectedFullyQualifiedTypeName(CompletionContext ctx) {
        String fqExpectedType = null;
        char[][] expectedTypes = ctx.getExpectedTypesSignatures();
        if (expectedTypes != null && expectedTypes.length > 0) {
            fqExpectedType = SignatureUtil.stripSignatureToFQN(new String(expectedTypes[0]));
        }
        return fqExpectedType;
    }

    private static int getArrayDimension(char[][] expectedTypesSignatures) {
        if (expectedTypesSignatures != null && expectedTypesSignatures.length > 0) {
            return Signature.getArrayCount((String)new String(expectedTypesSignatures[0]));
        }
        return 0;
    }

    public static ITypeBinding getTypeBindingFrom(IType type) {
        IBinding[] res = TypeBindingAnalyzer.resolveBindingsForElements(type.getCompilationUnit(), new IJavaElement[]{type}, true);
        if (res.length == 1 && res[0] instanceof ITypeBinding) {
            return (ITypeBinding)res[0];
        }
        return null;
    }

    private static boolean methodCanBeSeenBy(IMethodBinding mb, ITypeBinding invocationType) {
        if (Modifier.isPublic((int)mb.getModifiers())) {
            return true;
        }
        if (Bindings.equals((IBinding)invocationType, (IBinding)mb.getDeclaringClass())) {
            return true;
        }
        String invocationPackage = invocationType.getPackage().getName();
        String methodPackage = mb.getDeclaringClass().getPackage().getName();
        if (Modifier.isProtected((int)mb.getModifiers()) && invocationPackage.equals(methodPackage)) {
            return false;
        }
        if (Modifier.isPrivate((int)mb.getModifiers())) {
            ITypeBinding mTypeRoot = mb.getDeclaringClass();
            while (invocationType.getDeclaringClass() != null) {
                mTypeRoot = mTypeRoot.getDeclaringClass();
            }
            ITypeBinding invTypeRoot = invocationType;
            while (invTypeRoot.getDeclaringClass() != null) {
                invTypeRoot = invTypeRoot.getDeclaringClass();
            }
            return Bindings.equals((IBinding)invTypeRoot, (IBinding)mTypeRoot);
        }
        return invocationPackage.equals(methodPackage);
    }

    private static boolean fieldCanBeSeenBy(IVariableBinding fb, ITypeBinding invocationType) {
        if (Modifier.isPublic((int)fb.getModifiers())) {
            return true;
        }
        if (Bindings.equals((IBinding)invocationType, (IBinding)fb.getDeclaringClass())) {
            return true;
        }
        String invocationpackage = invocationType.getPackage().getName();
        String fieldPackage = fb.getDeclaringClass().getPackage().getName();
        if (Modifier.isProtected((int)fb.getModifiers())) {
            if (Bindings.equals((IBinding)invocationType, (IBinding)fb.getDeclaringClass())) {
                return true;
            }
            if (invocationpackage.equals(fieldPackage)) {
                return true;
            }
            ITypeBinding currType = invocationType.getSuperclass();
            while (currType != null) {
                if (Bindings.equals((IBinding)currType, (IBinding)fb.getDeclaringClass())) {
                    return true;
                }
                currType = currType.getSuperclass();
            }
        }
        if (Modifier.isPrivate((int)fb.getModifiers())) {
            ITypeBinding fTypeRoot = fb.getDeclaringClass();
            while (invocationType.getDeclaringClass() != null) {
                fTypeRoot = fTypeRoot.getDeclaringClass();
            }
            ITypeBinding invTypeRoot = invocationType;
            while (invTypeRoot.getDeclaringClass() != null) {
                invTypeRoot = invTypeRoot.getDeclaringClass();
            }
            if (Bindings.equalDeclarations((IBinding)fTypeRoot, (IBinding)invTypeRoot)) {
                return true;
            }
        }
        if (!invocationpackage.equals(fieldPackage)) {
            return false;
        }
        return false;
    }

    public static IBinding[] resolveBindingsForElements(ICompilationUnit cu, IJavaElement[] elements, boolean ignoreMethodBodies) {
        ASTParser parser = TypeBindingAnalyzer.createParser(cu, ignoreMethodBodies);
        return parser.createBindings(elements, null);
    }

    private static ASTParser createParser(ICompilationUnit cu, boolean ignoreMethodBodies) {
        ASTParser parser = ASTParser.newParser((int)12);
        parser.setKind(8);
        parser.setProject(cu.getJavaProject());
        parser.setSource(cu);
        if (ignoreMethodBodies) {
            parser.setIgnoreMethodBodies(true);
        } else {
            parser.setResolveBindings(true);
            parser.setBindingsRecovery(true);
            parser.setStatementsRecovery(true);
        }
        return parser;
    }
}

