/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.externaltools.internal.launchConfigurations;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.externaltools.internal.launchConfigurations.ExternalToolsCoreUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ListSelectionDialog;
import org.eclipse.ui.externaltools.internal.launchConfigurations.ExternalToolsLaunchConfigurationMessages;
import org.eclipse.ui.externaltools.internal.model.ExternalToolsImages;
import org.eclipse.ui.externaltools.internal.model.ExternalToolsPlugin;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class ExternalToolsBuildTab
extends AbstractLaunchConfigurationTab {
    private Button fBuildButton;
    private Group fGroup;
    private Button fProjectButton;
    private Button fSpecificProjectsButton;
    private Button fWorkspaceButton;
    private Button fSelectButton;
    private Button fReferencedProjects;
    private List<IProject> fProjects = new ArrayList<IProject>();

    public ExternalToolsBuildTab() {
        this.setHelpContextId("org.eclipse.ui.externaltools.build_tab_context");
    }

    public void createControl(Composite parent) {
        Composite mainComposite = new Composite(parent, 0);
        this.setControl((Control)mainComposite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), this.getHelpContextId());
        GridLayout layout = new GridLayout();
        GridData gd = new GridData(768);
        mainComposite.setLayout((Layout)layout);
        mainComposite.setLayoutData((Object)gd);
        mainComposite.setFont(parent.getFont());
        this.fBuildButton = this.createCheckButton(mainComposite, ExternalToolsLaunchConfigurationMessages.ExternalToolsBuildTab_1);
        this.fBuildButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExternalToolsBuildTab.this.updateEnabledState();
                ExternalToolsBuildTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.fGroup = new Group(mainComposite, 0);
        this.fGroup.setFont(mainComposite.getFont());
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = false;
        this.fGroup.setLayout((Layout)layout);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.fGroup.setLayoutData((Object)gd);
        SelectionAdapter adapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (((Button)e.getSource()).getSelection()) {
                    ExternalToolsBuildTab.this.updateEnabledState();
                    ExternalToolsBuildTab.this.updateLaunchConfigurationDialog();
                }
            }
        };
        this.fWorkspaceButton = this.createRadioButton((Composite)this.fGroup, ExternalToolsLaunchConfigurationMessages.ExternalToolsBuildTab_2);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.fWorkspaceButton.setLayoutData((Object)gd);
        this.fWorkspaceButton.addSelectionListener((SelectionListener)adapter);
        this.fProjectButton = this.createRadioButton((Composite)this.fGroup, ExternalToolsLaunchConfigurationMessages.ExternalToolsBuildTab_3);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.fProjectButton.setLayoutData((Object)gd);
        this.fProjectButton.addSelectionListener((SelectionListener)adapter);
        this.fSpecificProjectsButton = this.createRadioButton((Composite)this.fGroup, ExternalToolsLaunchConfigurationMessages.ExternalToolsBuildTab_4);
        gd = new GridData(768);
        gd.horizontalSpan = 1;
        this.fSpecificProjectsButton.setLayoutData((Object)gd);
        this.fSpecificProjectsButton.addSelectionListener((SelectionListener)adapter);
        this.fSelectButton = this.createPushButton((Composite)this.fGroup, ExternalToolsLaunchConfigurationMessages.ExternalToolsBuildTab_5, null);
        gd = (GridData)this.fSelectButton.getLayoutData();
        gd.horizontalAlignment = 128;
        this.fSelectButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExternalToolsBuildTab.this.selectResources();
            }
        });
        this.createVerticalSpacer(mainComposite, 1);
        this.fReferencedProjects = this.createCheckButton(mainComposite, ExternalToolsLaunchConfigurationMessages.ExternalToolsBuildTab_6);
    }

    private void selectResources() {
        ListSelectionDialog dialog = new ListSelectionDialog(this.getShell(), (Object)ResourcesPlugin.getWorkspace(), (IStructuredContentProvider)new ProjectsContentProvider(), (ILabelProvider)new WorkbenchLabelProvider(), ExternalToolsLaunchConfigurationMessages.ExternalToolsBuildTab_7);
        dialog.setInitialElementSelections(this.fProjects);
        if (dialog.open() == 1) {
            return;
        }
        Object[] res = dialog.getResult();
        this.fProjects = new ArrayList<IProject>(res.length);
        int i = 0;
        while (i < res.length) {
            this.fProjects.add((IProject)res[i]);
            ++i;
        }
        this.updateLaunchConfigurationDialog();
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        this.updateScope(configuration);
        this.updateReferencedProjects(configuration);
        this.updateEnabledState();
    }

    private void updateReferencedProjects(ILaunchConfiguration configuration) {
        boolean ref = false;
        try {
            ref = configuration.getAttribute("org.eclipse.ui.externaltools.ATTR_INCLUDE_REFERENCED_PROJECTS", true);
        }
        catch (CoreException e) {
            ExternalToolsPlugin.getDefault().log("Exception reading launch configuration", e);
        }
        this.fReferencedProjects.setSelection(ref);
    }

    private void updateScope(ILaunchConfiguration configuration) {
        String scope = null;
        try {
            scope = configuration.getAttribute("org.eclipse.ui.externaltools.ATTR_LAUNCH_CONFIGURATION_BUILD_SCOPE", null);
        }
        catch (CoreException ce) {
            ExternalToolsPlugin.getDefault().log("Exception reading launch configuration", ce);
        }
        this.fBuildButton.setSelection(scope != null);
        this.fWorkspaceButton.setSelection(false);
        this.fProjectButton.setSelection(false);
        this.fSpecificProjectsButton.setSelection(false);
        this.fProjects.clear();
        if (scope == null) {
            this.fBuildButton.setSelection(true);
            this.fWorkspaceButton.setSelection(true);
        } else if (scope.equals("${none}")) {
            this.fBuildButton.setSelection(false);
        } else if (scope.equals("${project}")) {
            this.fProjectButton.setSelection(true);
        } else if (scope.startsWith("${projects:")) {
            this.fSpecificProjectsButton.setSelection(true);
            IProject[] projects = ExternalToolsBuildTab.getBuildProjects(configuration, "org.eclipse.ui.externaltools.ATTR_LAUNCH_CONFIGURATION_BUILD_SCOPE");
            this.fProjects = new ArrayList<IProject>(projects.length);
            Collections.addAll(this.fProjects, projects);
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        String scope = this.generateScopeMemento();
        configuration.setAttribute("org.eclipse.ui.externaltools.ATTR_LAUNCH_CONFIGURATION_BUILD_SCOPE", scope);
        if (this.fReferencedProjects.getSelection()) {
            configuration.setAttribute("org.eclipse.ui.externaltools.ATTR_INCLUDE_REFERENCED_PROJECTS", null);
        } else {
            configuration.setAttribute("org.eclipse.ui.externaltools.ATTR_INCLUDE_REFERENCED_PROJECTS", false);
        }
    }

    private String generateScopeMemento() {
        if (this.fBuildButton.getSelection()) {
            if (this.fWorkspaceButton.getSelection()) {
                return null;
            }
            if (this.fProjectButton.getSelection()) {
                return "${project}";
            }
            if (this.fSpecificProjectsButton.getSelection()) {
                return ExternalToolsBuildTab.getBuildScopeAttribute(this.fProjects);
            }
            return null;
        }
        return "${none}";
    }

    public String getName() {
        return ExternalToolsLaunchConfigurationMessages.ExternalToolsBuildTab_8;
    }

    private void updateEnabledState() {
        boolean enabled = this.fBuildButton.getSelection();
        this.fGroup.setEnabled(enabled);
        this.fWorkspaceButton.setEnabled(enabled);
        this.fProjectButton.setEnabled(enabled);
        this.fSpecificProjectsButton.setEnabled(enabled);
        this.fSelectButton.setEnabled(enabled && this.fSpecificProjectsButton.getSelection());
        if (!enabled) {
            super.setErrorMessage(null);
        }
        if (enabled && !this.fWorkspaceButton.getSelection() && !this.fProjectButton.getSelection() && !this.fSpecificProjectsButton.getSelection()) {
            this.fWorkspaceButton.setSelection(true);
        }
        this.fReferencedProjects.setEnabled(this.fBuildButton.getSelection() && (this.fProjectButton.getSelection() || this.fSpecificProjectsButton.getSelection()));
    }

    public Image getImage() {
        return ExternalToolsImages.getImage("org.eclipse.ui.externaltools.IMG_TAB_BUILD");
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        this.setErrorMessage(null);
        this.setMessage(null);
        if (this.fBuildButton.getSelection() && this.fSpecificProjectsButton.getSelection() && this.fProjects.isEmpty()) {
            this.setErrorMessage(ExternalToolsLaunchConfigurationMessages.ExternalToolsBuildTab_9);
            return false;
        }
        return true;
    }

    public static IProject[] getBuildProjects(ILaunchConfiguration configuration, String buildScopeId) {
        return ExternalToolsCoreUtil.getBuildProjects((ILaunchConfiguration)configuration, (String)buildScopeId);
    }

    public static boolean isIncludeReferencedProjects(ILaunchConfiguration configuration, String includeReferencedProjectsId) throws CoreException {
        return ExternalToolsCoreUtil.isIncludeReferencedProjects((ILaunchConfiguration)configuration, (String)includeReferencedProjectsId);
    }

    public static String getBuildScopeAttribute(List<IProject> projects) {
        StringBuilder buf = new StringBuilder();
        buf.append("${projects:");
        Iterator<IProject> iterator = projects.iterator();
        while (iterator.hasNext()) {
            IProject project = iterator.next();
            buf.append(project.getName());
            if (!iterator.hasNext()) continue;
            buf.append(",");
        }
        buf.append("}");
        return buf.toString();
    }

    public void activated(ILaunchConfigurationWorkingCopy workingCopy) {
    }

    public void deactivated(ILaunchConfigurationWorkingCopy workingCopy) {
    }

    class ProjectsContentProvider
    implements IStructuredContentProvider {
        ProjectsContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return ((IWorkspace)inputElement).getRoot().getProjects();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

