/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.navigator.resources;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.common.CommandException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IAggregateWorkingSet;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.ISaveablesSource;
import org.eclipse.ui.ISecondarySaveableSource;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.Saveable;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.internal.DefaultSaveable;
import org.eclipse.ui.internal.navigator.filters.UserFilter;
import org.eclipse.ui.internal.navigator.framelist.Frame;
import org.eclipse.ui.internal.navigator.framelist.FrameList;
import org.eclipse.ui.internal.navigator.framelist.TreeFrame;
import org.eclipse.ui.internal.navigator.resources.ResourceToItemsMapper;
import org.eclipse.ui.internal.navigator.resources.plugin.WorkbenchNavigatorMessages;
import org.eclipse.ui.internal.navigator.resources.plugin.WorkbenchNavigatorPlugin;
import org.eclipse.ui.internal.views.helpers.EmptyWorkspaceHelper;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.navigator.CommonNavigator;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.ui.navigator.ICommonViewerMapper;

public final class ProjectExplorer
extends CommonNavigator
implements ISecondarySaveableSource {
    public static final String VIEW_ID = "org.eclipse.ui.navigator.ProjectExplorer";
    public static final int WORKING_SETS = 0;
    public static final int PROJECTS = 1;
    private static final String MEMENTO_REGEXP_FILTER_ELEMENT = "regexpFilter";
    private static final String MEMENTO_REGEXP_FILTER_REGEXP_ATTRIBUTE = "regexp";
    private static final String MEMENTO_REGEXP_FILTER_ENABLED_ATTRIBUTE = "enabled";
    private int rootMode;
    private String workingSetLabel;
    private List<UserFilter> userFilters;
    private EmptyWorkspaceHelper emptyWorkspaceHelper;

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        this.userFilters = new ArrayList<UserFilter>();
        if (memento != null) {
            IMemento[] filters;
            IMemento[] iMementoArray = filters = memento.getChildren(MEMENTO_REGEXP_FILTER_ELEMENT);
            int n = filters.length;
            int n2 = 0;
            while (n2 < n) {
                IMemento filterMemento = iMementoArray[n2];
                String regexp = filterMemento.getString(MEMENTO_REGEXP_FILTER_REGEXP_ATTRIBUTE);
                Boolean enabled = filterMemento.getBoolean(MEMENTO_REGEXP_FILTER_ENABLED_ATTRIBUTE);
                this.userFilters.add(new UserFilter(regexp, enabled.booleanValue()));
                ++n2;
            }
        }
    }

    public void saveState(IMemento aMemento) {
        Object data = this.getCommonViewer().getData("resourceRegexpFilters");
        if (data instanceof Collection) {
            Collection dataAsFilters = (Collection)data;
            for (Object object : dataAsFilters) {
                if (!(object instanceof UserFilter)) continue;
                UserFilter filter = (UserFilter)object;
                IMemento memento = aMemento.createChild(MEMENTO_REGEXP_FILTER_ELEMENT);
                memento.putString(MEMENTO_REGEXP_FILTER_REGEXP_ATTRIBUTE, filter.getRegexp());
                memento.putBoolean(MEMENTO_REGEXP_FILTER_ENABLED_ATTRIBUTE, filter.isEnabled());
            }
        }
        super.saveState(aMemento);
    }

    public void createPartControl(Composite aParent) {
        this.emptyWorkspaceHelper = new EmptyWorkspaceHelper();
        Composite displayAreas = this.emptyWorkspaceHelper.getComposite(aParent);
        super.createPartControl(displayAreas);
        this.getCommonViewer().setMapper((ICommonViewerMapper)new ResourceToItemsMapper(this.getCommonViewer()));
        this.getCommonViewer().setData("resourceRegexpFilters", this.userFilters);
        if (this.userFilters.stream().anyMatch(UserFilter::isEnabled)) {
            this.getCommonViewer().refresh();
        }
    }

    public void updateTitle() {
        super.updateTitle();
        Object input = this.getCommonViewer().getInput();
        if (input == null || input instanceof IAggregateWorkingSet) {
            this.setContentDescription("");
            return;
        }
        if (!(input instanceof IResource)) {
            String label = ((ILabelProvider)this.getCommonViewer().getLabelProvider()).getText(input);
            if (label != null) {
                this.setContentDescription(label);
                return;
            }
            IWorkbenchAdapter wbadapter = (IWorkbenchAdapter)Adapters.adapt((Object)input, IWorkbenchAdapter.class);
            if (wbadapter != null) {
                this.setContentDescription(wbadapter.getLabel(input));
                return;
            }
            this.setContentDescription(input.toString());
            return;
        }
        IResource res = (IResource)input;
        this.setContentDescription(res.getName());
    }

    public String getFrameToolTipText(Object element) {
        IPath path;
        String result = !(element instanceof IResource) ? (element instanceof IAggregateWorkingSet ? WorkbenchNavigatorMessages.ProjectExplorerPart_workingSetModel : (element instanceof IWorkingSet ? ((IWorkingSet)element).getLabel() : super.getFrameToolTipText(element))) : ((path = ((IResource)element).getFullPath()).isRoot() ? WorkbenchNavigatorMessages.ProjectExplorerPart_workspace : path.makeRelative().toString());
        if (this.rootMode == 1) {
            if (this.workingSetLabel == null) {
                return result;
            }
            if (result.length() == 0) {
                return NLS.bind((String)WorkbenchNavigatorMessages.ProjectExplorer_toolTip, (Object[])new String[]{this.workingSetLabel});
            }
            return NLS.bind((String)WorkbenchNavigatorMessages.ProjectExplorer_toolTip2, (Object[])new String[]{result, this.workingSetLabel});
        }
        if (element != null && !(element instanceof IWorkingSet) && this.getCommonViewer() != null) {
            FrameList frameList = this.getCommonViewer().getFrameList();
            if (frameList == null) {
                return result;
            }
            int index = frameList.getCurrentIndex();
            IWorkingSet ws = null;
            while (index >= 0) {
                Object input;
                Frame frame = frameList.getFrame(index);
                if (frame instanceof TreeFrame && (input = ((TreeFrame)frame).getInput()) instanceof IWorkingSet && !(input instanceof IAggregateWorkingSet)) {
                    ws = (IWorkingSet)input;
                    break;
                }
                --index;
            }
            if (ws != null) {
                return NLS.bind((String)WorkbenchNavigatorMessages.ProjectExplorer_toolTip3, (Object[])new String[]{ws.getLabel(), result});
            }
            return result;
        }
        return result;
    }

    public void setRootMode(int mode) {
        this.rootMode = mode;
    }

    public int getRootMode() {
        return this.rootMode;
    }

    public void setWorkingSetLabel(String label) {
        this.workingSetLabel = label;
    }

    public String getWorkingSetLabel() {
        return this.workingSetLabel;
    }

    protected void handleDoubleClick(DoubleClickEvent anEvent) {
        IStructuredSelection selection;
        Object element;
        ICommandService commandService = (ICommandService)this.getViewSite().getService(ICommandService.class);
        Command openProjectCommand = commandService.getCommand("org.eclipse.ui.project.openProject");
        if (openProjectCommand != null && openProjectCommand.isHandled() && openProjectCommand.isEnabled() && (element = (selection = (IStructuredSelection)anEvent.getSelection()).getFirstElement()) instanceof IProject && !((IProject)element).isOpen()) {
            try {
                openProjectCommand.executeWithChecks(new ExecutionEvent());
            }
            catch (CommandException ex) {
                IStatus status = WorkbenchNavigatorPlugin.createErrorStatus("'Open Project' failed", ex);
                WorkbenchNavigatorPlugin.getDefault().getLog().log(status);
            }
            return;
        }
        super.handleDoubleClick(anEvent);
    }

    protected CommonViewer createCommonViewer(Composite aParent) {
        CommonViewer viewer = super.createCommonViewer(aParent);
        this.emptyWorkspaceHelper.setNonEmptyControl(viewer.getControl());
        return viewer;
    }

    public Saveable[] getSaveables() {
        if (!this.hasSaveablesProvider()) {
            Saveable[] saveableArray;
            IEditorPart saveablePart = this.getActiveEditor();
            if (saveablePart != null) {
                if (saveablePart instanceof ISaveablesSource) {
                    saveableArray = ((ISaveablesSource)saveablePart).getSaveables();
                } else {
                    Saveable[] saveableArray2 = new Saveable[1];
                    saveableArray = saveableArray2;
                    saveableArray2[0] = new DefaultSaveable((IWorkbenchPart)saveablePart);
                }
            } else {
                saveableArray = new Saveable[]{};
            }
            return saveableArray;
        }
        return super.getSaveables();
    }

    public Saveable[] getActiveSaveables() {
        if (!this.hasSaveablesProvider()) {
            Saveable[] saveableArray;
            IEditorPart saveablePart = this.getActiveEditor();
            if (saveablePart != null) {
                if (saveablePart instanceof ISaveablesSource) {
                    saveableArray = ((ISaveablesSource)saveablePart).getActiveSaveables();
                } else {
                    Saveable[] saveableArray2 = new Saveable[1];
                    saveableArray = saveableArray2;
                    saveableArray2[0] = new DefaultSaveable((IWorkbenchPart)saveablePart);
                }
            } else {
                saveableArray = new Saveable[]{};
            }
            return saveableArray;
        }
        return super.getActiveSaveables();
    }

    private IEditorPart getActiveEditor() {
        IWorkbenchPage page = this.getSite().getPage();
        return page != null ? page.getActiveEditor() : null;
    }

    public boolean isDirtyStateSupported() {
        return this.hasSaveablesProvider();
    }
}

