/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.filesystem;

import java.io.File;
import java.net.URI;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.dynamichelpers.ExtensionTracker;
import org.eclipse.core.runtime.dynamichelpers.IExtensionChangeHandler;
import org.eclipse.core.runtime.dynamichelpers.IExtensionTracker;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.fileSystem.FileSystemContributor;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.ide.dialogs.IDEResourceInfoUtils;
import org.eclipse.ui.internal.ide.filesystem.FileSystemConfiguration;
import org.eclipse.ui.internal.ide.filesystem.FileSystemMessages;

public class FileSystemSupportRegistry
implements IExtensionChangeHandler {
    private static final String FILESYSTEM_SUPPORT = "filesystemSupport";
    protected static final String ATT_CLASS = "class";
    private static final String LABEL = "label";
    private static final String SCHEME = "scheme";
    private static FileSystemSupportRegistry singleton;
    private Collection registeredContributions = new HashSet(0);
    FileSystemConfiguration defaultConfiguration = new FileSystemConfiguration(FileSystemMessages.DefaultFileSystem_name, new FileSystemContributor(){

        @Override
        public URI browseFileSystem(String initialPath, Shell shell) {
            String selectedDirectory;
            IFileInfo info;
            DirectoryDialog dialog = new DirectoryDialog(shell, 0x10000000);
            dialog.setMessage(IDEWorkbenchMessages.ProjectLocationSelectionDialog_directoryLabel);
            if (!initialPath.equals("") && (info = IDEResourceInfoUtils.getFileInfo(initialPath)) != null && info.exists()) {
                dialog.setFilterPath(initialPath);
            }
            if ((selectedDirectory = dialog.open()) == null) {
                return null;
            }
            return new File(selectedDirectory).toURI();
        }
    }, null);
    private FileSystemConfiguration[] allConfigurations;

    public static FileSystemSupportRegistry getInstance() {
        if (singleton == null) {
            singleton = new FileSystemSupportRegistry();
        }
        return singleton;
    }

    public FileSystemSupportRegistry() {
        IExtensionTracker tracker = PlatformUI.getWorkbench().getExtensionTracker();
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.ui.ide", FILESYSTEM_SUPPORT);
        if (point == null) {
            return;
        }
        IExtension[] iExtensionArray = point.getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            this.processExtension(tracker, extension);
            ++n2;
        }
        tracker.registerHandler((IExtensionChangeHandler)this, ExtensionTracker.createExtensionPointFilter((IExtensionPoint)point));
    }

    public void addExtension(IExtensionTracker tracker, IExtension extension) {
        this.processExtension(tracker, extension);
        this.allConfigurations = null;
    }

    public void removeExtension(IExtension extension, Object[] objects) {
        Object[] objectArray = objects;
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            this.registeredContributions.remove(object);
            ++n2;
        }
        this.allConfigurations = null;
    }

    private void processExtension(IExtensionTracker tracker, IExtension extension) {
        IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement configElement = iConfigurationElementArray[n2];
            FileSystemConfiguration contribution = this.newConfiguration(configElement);
            this.registeredContributions.add(contribution);
            tracker.registerObject(extension, (Object)contribution, 0);
            ++n2;
        }
    }

    private FileSystemConfiguration newConfiguration(final IConfigurationElement element) {
        final FileSystemContributor[] contributors = new FileSystemContributor[1];
        final CoreException[] exceptions = new CoreException[1];
        SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

            public void run() {
                try {
                    contributors[0] = (FileSystemContributor)IDEWorkbenchPlugin.createExtension(element, FileSystemSupportRegistry.ATT_CLASS);
                }
                catch (CoreException exception) {
                    exceptions[0] = exception;
                }
            }

            public void handleException(Throwable e) {
            }
        });
        if (exceptions[0] != null) {
            return null;
        }
        String name = element.getAttribute(LABEL);
        String fileSystem = element.getAttribute(SCHEME);
        return new FileSystemConfiguration(name, contributors[0], fileSystem);
    }

    public FileSystemConfiguration[] getConfigurations() {
        if (this.allConfigurations == null) {
            this.allConfigurations = new FileSystemConfiguration[this.registeredContributions.size() + 1];
            this.allConfigurations[0] = this.defaultConfiguration;
            Iterator iterator = this.registeredContributions.iterator();
            int index = 0;
            while (iterator.hasNext()) {
                this.allConfigurations[++index] = (FileSystemConfiguration)iterator.next();
            }
        }
        return this.allConfigurations;
    }

    public FileSystemConfiguration getDefaultConfiguration() {
        return this.defaultConfiguration;
    }

    public boolean hasOneFileSystem() {
        return this.registeredContributions.isEmpty();
    }
}

