/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.registry;

import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Hashtable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;

public abstract class IDERegistryReader {
    protected static final String TAG_DESCRIPTION = "description";
    protected static Hashtable<String, IExtension[]> extensionPoints = new Hashtable();
    private static final Comparator<IExtension> comparer = (i1, i2) -> {
        String s1 = i1.getContributor().getName();
        String s2 = i2.getContributor().getName();
        return s1.compareToIgnoreCase(s2);
    };

    protected IDERegistryReader() {
    }

    protected String getDescription(IConfigurationElement config) {
        IConfigurationElement[] children = config.getChildren(TAG_DESCRIPTION);
        if (children.length >= 1) {
            return children[0].getValue();
        }
        return "";
    }

    protected void logError(IConfigurationElement element, String text) {
        IExtension extension = element.getDeclaringExtension();
        String pluginId = extension.getContributor().getName();
        StringBuilder buf = new StringBuilder();
        buf.append("Plugin " + pluginId + ", extension " + extension.getExtensionPointUniqueIdentifier());
        buf.append("\n" + text);
        IDEWorkbenchPlugin.log(buf.toString());
    }

    protected void logMissingAttribute(IConfigurationElement element, String attributeName) {
        this.logError(element, "Required attribute '" + attributeName + "' not defined");
    }

    protected void logMissingElement(IConfigurationElement element, String elementName) {
        this.logError(element, "Required sub element '" + elementName + "' not defined");
    }

    protected void logUnknownElement(IConfigurationElement element) {
        this.logError(element, "Unknown extension tag found: " + element.getName());
    }

    protected IExtension[] orderExtensions(IExtension[] extensions) {
        IExtension[] sortedExtension = new IExtension[extensions.length];
        System.arraycopy(extensions, 0, sortedExtension, 0, extensions.length);
        Collections.sort(Arrays.asList(sortedExtension), comparer);
        return sortedExtension;
    }

    protected abstract boolean readElement(IConfigurationElement var1);

    protected void readElementChildren(IConfigurationElement element) {
        this.readElements(element.getChildren());
    }

    protected void readElements(IConfigurationElement[] elements) {
        IConfigurationElement[] iConfigurationElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if (!this.readElement(element)) {
                this.logUnknownElement(element);
            }
            ++n2;
        }
    }

    protected void readExtension(IExtension extension) {
        this.readElements(extension.getConfigurationElements());
    }

    protected void readRegistry(IExtensionRegistry registry, String pluginId, String extensionPoint) {
        String pointId = String.valueOf(pluginId) + "-" + extensionPoint;
        IExtension[] extensions = extensionPoints.get(pointId);
        if (extensions == null) {
            IExtensionPoint point = registry.getExtensionPoint(pluginId, extensionPoint);
            if (point == null) {
                return;
            }
            extensions = point.getExtensions();
            extensions = this.orderExtensions(extensions);
            extensionPoints.put(pointId, extensions);
        }
        IExtension[] iExtensionArray = extensions;
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            this.readExtension(extension);
            ++n2;
        }
    }
}

