/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.repository;

import java.io.IOException;
import java.text.MessageFormat;
import org.eclipse.core.commands.IStateListener;
import org.eclipse.core.commands.State;
import org.eclipse.egit.core.RepositoryUtil;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.CommonUtils;
import org.eclipse.egit.ui.internal.GitLabels;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.decorators.GitDecorator;
import org.eclipse.egit.ui.internal.repository.tree.AdditionalRefNode;
import org.eclipse.egit.ui.internal.repository.tree.RefNode;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryTreeNode;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryTreeNodeType;
import org.eclipse.egit.ui.internal.repository.tree.StashedCommitNode;
import org.eclipse.egit.ui.internal.repository.tree.TagNode;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.BranchTrackingStatus;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryState;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.submodule.SubmoduleWalk;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.services.IServiceLocator;

public class RepositoryTreeNodeDecorator
extends GitDecorator
implements IStateListener {
    private final State verboseBranchModeState;
    private boolean verboseBranchMode = false;

    public RepositoryTreeNodeDecorator() {
        ICommandService srv = CommonUtils.getService((IServiceLocator)PlatformUI.getWorkbench(), ICommandService.class);
        this.verboseBranchModeState = srv.getCommand("org.eclipse.egit.ui.RepositoriesToggleBranchCommit").getState("org.eclipse.ui.commands.toggleState");
        this.verboseBranchModeState.addListener((IStateListener)this);
        try {
            this.verboseBranchMode = (Boolean)this.verboseBranchModeState.getValue();
        }
        catch (Exception e) {
            Activator.logError(e.getMessage(), e);
        }
    }

    @Override
    public void dispose() {
        this.verboseBranchModeState.removeListener((IStateListener)this);
        super.dispose();
    }

    public void handleStateChange(State state, Object oldValue) {
        try {
            boolean newValue = (Boolean)state.getValue();
            if (newValue != this.verboseBranchMode) {
                this.verboseBranchMode = newValue;
                this.postLabelEvent();
            }
        }
        catch (Exception e) {
            Activator.logError(e.getMessage(), e);
        }
    }

    public void decorate(Object element, IDecoration decoration) {
        RepositoryTreeNode node = (RepositoryTreeNode)element;
        Repository repository = node.getRepository();
        if (repository != null) {
            try {
                this.decorateText(node, repository, decoration);
            }
            catch (IOException e) {
                Activator.logError(MessageFormat.format(UIText.GitLabelProvider_UnableToRetrieveLabel, element.toString()), e);
            }
        }
    }

    private void decorateText(RepositoryTreeNode<?> node, @NonNull Repository repository, IDecoration decoration) throws IOException {
        boolean decorated = false;
        switch (node.getType()) {
            case REPO: {
                decorated = this.decorateRepository(node, repository, decoration);
                break;
            }
            case ADDITIONALREF: {
                decorated = this.decorateAdditionalRef((AdditionalRefNode)node, decoration);
                break;
            }
            case REF: {
                decorated = this.decorateRef((RefNode)node, decoration);
                break;
            }
            case TAG: {
                decorated = this.decorateTag((TagNode)node, decoration);
                break;
            }
            case STASHED_COMMIT: {
                decorated = this.decorateStash((StashedCommitNode)node, decoration);
                break;
            }
            case SUBMODULES: {
                decorated = this.decorateSubmodules(repository, decoration);
                break;
            }
            default: {
                return;
            }
        }
        if (!decorated) {
            decoration.addSuffix(" ");
        }
    }

    private boolean decorateAdditionalRef(AdditionalRefNode node, IDecoration decoration) {
        Ref ref = (Ref)node.getObject();
        StringBuilder suffix = new StringBuilder();
        if (ref.isSymbolic()) {
            suffix.append(" [").append(ref.getLeaf().getName()).append(']');
        }
        ObjectId refId = ref.getObjectId();
        suffix.append(' ');
        RevCommit commit = this.getLatestCommit(node);
        if (commit != null) {
            suffix.append(this.abbreviate((ObjectId)commit)).append(' ').append(commit.getShortMessage());
        } else if (!ref.isSymbolic() || refId != null) {
            suffix.append(this.abbreviate(refId));
        } else {
            suffix.append(UIText.RepositoriesViewLabelProvider_UnbornBranchText);
        }
        decoration.addSuffix(suffix.toString());
        return true;
    }

    private boolean decorateRef(RefNode node, IDecoration decoration) {
        RevCommit latest;
        if (this.verboseBranchMode && (latest = this.getLatestCommit(node)) != null) {
            decoration.addSuffix(" " + this.abbreviate((ObjectId)latest) + ' ' + latest.getShortMessage());
            return true;
        }
        return false;
    }

    private boolean decorateRepository(RepositoryTreeNode<?> node, @NonNull Repository repository, IDecoration decoration) throws IOException {
        boolean isSubModule;
        boolean bl = isSubModule = node.getParent() != null && node.getParent().getType() == RepositoryTreeNodeType.SUBMODULES;
        if (RepositoryUtil.hasChanges((Repository)repository)) {
            decoration.addPrefix("> ");
        }
        StringBuilder suffix = new StringBuilder();
        if (isSubModule) {
            Ref head = repository.exactRef("HEAD");
            if (head == null) {
                return false;
            }
            suffix.append(" [");
            if (head.isSymbolic()) {
                suffix.append(Repository.shortenRefName((String)head.getLeaf().getName()));
            } else if (head.getObjectId() != null) {
                suffix.append(this.abbreviate(head.getObjectId()));
            }
            suffix.append(']');
            if (this.verboseBranchMode && head.getObjectId() != null) {
                try {
                    Throwable throwable = null;
                    Object var8_12 = null;
                    try (RevWalk walk = new RevWalk(repository);){
                        RevCommit commit = walk.parseCommit((AnyObjectId)head.getObjectId());
                        suffix.append(' ').append(commit.getShortMessage());
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException iOException) {}
            }
        } else {
            RepositoryState repositoryState;
            String branch = Activator.getDefault().getRepositoryUtil().getShortBranch(repository);
            if (branch == null) {
                return false;
            }
            suffix.append(" [");
            suffix.append(branch);
            BranchTrackingStatus trackingStatus = BranchTrackingStatus.of((Repository)repository, (String)branch);
            if (trackingStatus != null && (trackingStatus.getAheadCount() != 0 || trackingStatus.getBehindCount() != 0)) {
                String formattedTrackingStatus = GitLabels.formatBranchTrackingStatus(trackingStatus);
                suffix.append(' ').append(formattedTrackingStatus);
            }
            if ((repositoryState = repository.getRepositoryState()) != RepositoryState.SAFE) {
                suffix.append(" - ").append(repositoryState.getDescription());
            }
            suffix.append(']');
        }
        decoration.addSuffix(suffix.toString());
        return true;
    }

    private boolean decorateStash(StashedCommitNode node, IDecoration decoration) {
        RevCommit commit = (RevCommit)node.getObject();
        decoration.addSuffix(" [" + this.abbreviate((ObjectId)commit) + "] " + commit.getShortMessage());
        return true;
    }

    private boolean decorateSubmodules(@NonNull Repository repository, IDecoration decoration) throws IOException {
        if (this.haveSubmoduleChanges(repository)) {
            decoration.addPrefix("> ");
            return true;
        }
        return false;
    }

    private boolean decorateTag(TagNode node, IDecoration decoration) {
        if (this.verboseBranchMode && node.getCommitId() != null && node.getCommitId().length() > 0) {
            decoration.addSuffix(" " + node.getCommitId().substring(0, 7) + ' ' + node.getCommitShortMessage());
            return true;
        }
        return false;
    }

    private RevCommit getLatestCommit(RepositoryTreeNode node) {
        Ref ref = (Ref)node.getObject();
        ObjectId id = ref.isSymbolic() ? ref.getLeaf().getObjectId() : ref.getObjectId();
        if (id == null) {
            return null;
        }
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (RevWalk walk = new RevWalk(node.getRepository());){
                walk.setRetainBody(true);
                return walk.parseCommit((AnyObjectId)id);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException ignored) {
            return null;
        }
    }

    private String abbreviate(ObjectId id) {
        if (id != null) {
            return id.abbreviate(7).name();
        }
        return ObjectId.zeroId().abbreviate(7).name();
    }

    private boolean haveSubmoduleChanges(@NonNull Repository repository) throws IOException {
        boolean hasChanges = false;
        Throwable throwable = null;
        Object var4_5 = null;
        try (SubmoduleWalk walk = SubmoduleWalk.forIndex((Repository)repository);){
            while (!hasChanges && walk.next()) {
                Repository submodule = walk.getRepository();
                if (submodule == null) continue;
                Repository cached = org.eclipse.egit.core.Activator.getDefault().getRepositoryCache().lookupRepository(submodule.getDirectory().getAbsoluteFile());
                hasChanges = cached != null && RepositoryUtil.hasChanges((Repository)cached);
                submodule.close();
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return hasChanges;
    }

    @Override
    protected String getName() {
        return UIText.RepositoryTreeNodeDecorator_name;
    }
}

