/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.tesla.ui.describers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.rcptt.tesla.core.protocol.raw.Element;
import org.eclipse.rcptt.tesla.internal.core.AbstractTeslaClient;
import org.eclipse.rcptt.tesla.ui.describers.IDescriberExtension;
import org.eclipse.rcptt.tesla.ui.describers.IWidgetDescriber;
import org.eclipse.rcptt.tesla.ui.describers.WidgetDescriber;
import org.eclipse.swt.widgets.Widget;

public class DescriberManager {
    private List<Entry> extensions = null;
    private static DescriberManager descManager = null;

    private DescriberManager() {
    }

    private synchronized void initialize() {
        IConfigurationElement[] elements;
        if (this.extensions != null) {
            return;
        }
        this.extensions = new ArrayList<Entry>();
        IConfigurationElement[] iConfigurationElementArray = elements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.rcptt.tesla.swt.describerExtensions");
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement cfg = iConfigurationElementArray[n2];
            try {
                IDescriberExtension provider = (IDescriberExtension)cfg.createExecutableExtension("class");
                int priority = 0;
                try {
                    String attribute = cfg.getAttribute("priority");
                    priority = Integer.valueOf(attribute);
                }
                catch (NumberFormatException numberFormatException) {}
                Entry e = new Entry();
                e.ext = provider;
                e.priority = priority;
                this.extensions.add(e);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            ++n2;
        }
        Collections.sort(this.extensions, new Comparator<Entry>(){

            @Override
            public int compare(Entry o1, Entry o2) {
                return Integer.valueOf(o1.priority).compareTo(o2.priority);
            }
        });
    }

    IDescriberExtension[] getExtensions() {
        this.initialize();
        IDescriberExtension[] ar = new IDescriberExtension[this.extensions.size()];
        int i = 0;
        while (i < ar.length) {
            ar[i] = this.extensions.get((int)i).ext;
            ++i;
        }
        return ar;
    }

    public static IWidgetDescriber getDescriber(Widget widget, int x, int y) {
        DescriberManager.init();
        IDescriberExtension[] extensions = descManager.getExtensions();
        IWidgetDescriber current = new WidgetDescriber(widget);
        IDescriberExtension[] iDescriberExtensionArray = extensions;
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IDescriberExtension ext = iDescriberExtensionArray[n2];
            current = ext.getDescriber(widget, current, x, y);
            ++n2;
        }
        return current;
    }

    public static IWidgetDescriber getDescriber(Element element, AbstractTeslaClient client) {
        IDescriberExtension[] extensions;
        DescriberManager.init();
        IDescriberExtension[] iDescriberExtensionArray = extensions = descManager.getExtensions();
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IDescriberExtension ext = iDescriberExtensionArray[n2];
            IWidgetDescriber descr = ext.getDescriber(element, client);
            if (descr != null) {
                return descr;
            }
            ++n2;
        }
        return null;
    }

    private static synchronized void init() {
        if (descManager == null) {
            descManager = new DescriberManager();
        }
    }

    private static class Entry {
        IDescriberExtension ext;
        int priority = 0;

        private Entry() {
        }
    }
}

