/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.cheatsheets.composite.explorer;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.internal.cheatsheets.composite.explorer.ResetTaskAction;
import org.eclipse.ui.internal.cheatsheets.composite.explorer.RestartAllAction;
import org.eclipse.ui.internal.cheatsheets.composite.explorer.SkipAction;
import org.eclipse.ui.internal.cheatsheets.composite.explorer.StartAction;
import org.eclipse.ui.internal.cheatsheets.composite.model.TaskStateUtilities;
import org.eclipse.ui.internal.provisional.cheatsheets.ICompositeCheatSheetTask;
import org.eclipse.ui.internal.provisional.cheatsheets.TaskExplorer;

public class TreeExplorerMenu {
    private TaskExplorer explorer;

    public TreeExplorerMenu(TaskExplorer explorer) {
        this.explorer = explorer;
        MenuManager menuMgr = new MenuManager(null);
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(manager -> this.fillContextMenu(manager));
        Menu menu = menuMgr.createContextMenu(explorer.getControl());
        explorer.getControl().setMenu(menu);
    }

    protected void fillContextMenu(IMenuManager manager) {
        Action restartAction;
        IStructuredSelection structuredSelection;
        ISelection selection = this.explorer.getSelectionProvider().getSelection();
        ICompositeCheatSheetTask selectedTask = null;
        if (selection instanceof IStructuredSelection && (structuredSelection = (IStructuredSelection)selection).size() == 1) {
            selectedTask = (ICompositeCheatSheetTask)structuredSelection.getFirstElement();
        }
        if (selectedTask == null) {
            return;
        }
        StartAction startAction = new StartAction(selectedTask);
        startAction.setEnabled(TaskStateUtilities.isStartEnabled(selectedTask));
        manager.add((IAction)startAction);
        SkipAction skipAction = new SkipAction(selectedTask);
        skipAction.setEnabled(TaskStateUtilities.isSkipEnabled(selectedTask));
        manager.add((IAction)skipAction);
        if (selectedTask.getParent() == null) {
            restartAction = new RestartAllAction(selectedTask.getCompositeCheatSheet());
        } else {
            restartAction = new ResetTaskAction(selectedTask);
            restartAction.setEnabled(selectedTask.getState() != 0);
        }
        manager.add((IAction)restartAction);
    }
}

