/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.components;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.egit.core.RepositoryCache;
import org.eclipse.egit.core.RepositoryUtil;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.CommonUtils;
import org.eclipse.egit.ui.internal.UIIcons;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.annotations.Nullable;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.actions.ActionFactory;

public final class RepositoryMenuUtil {
    private RepositoryMenuUtil() {
    }

    public static void fillRepositories(@NonNull IMenuManager menuManager, boolean includeBare, @Nullable File currentRepoDir, @NonNull Consumer<Repository> action) {
        for (IAction item : RepositoryMenuUtil.getRepositoryActions(includeBare, currentRepoDir, action)) {
            menuManager.add(item);
        }
    }

    public static Collection<IAction> getRepositoryActions(boolean includeBare, @Nullable File currentRepoDir, @NonNull Consumer<Repository> action) {
        RepositoryUtil util = org.eclipse.egit.core.Activator.getDefault().getRepositoryUtil();
        final RepositoryCache cache = org.eclipse.egit.core.Activator.getDefault().getRepositoryCache();
        Set repositories = util.getRepositories();
        HashMap<String, HashSet<File>> repos = new HashMap<String, HashSet<File>>();
        for (String repo : repositories) {
            File gitDir = new File(repo);
            String name = null;
            try {
                Repository r = cache.lookupRepository(gitDir);
                if (!includeBare && r.isBare()) continue;
                name = util.getRepositoryName(r);
            }
            catch (IOException e) {
                continue;
            }
            HashSet<File> files = (HashSet<File>)repos.get(name);
            if (files == null) {
                files = new HashSet<File>();
                files.add(gitDir);
                repos.put(name, files);
                continue;
            }
            files.add(gitDir);
        }
        String[] repoNames = repos.keySet().toArray(new String[0]);
        Arrays.sort(repoNames, CommonUtils.STRING_ASCENDING_COMPARATOR);
        ArrayList<IAction> result = new ArrayList<IAction>();
        String[] stringArray = repoNames;
        int n = repoNames.length;
        int n2 = 0;
        while (n2 < n) {
            String repoName = stringArray[n2];
            Set files = (Set)repos.get(repoName);
            Object[] gitDirs = files.toArray(new File[0]);
            Arrays.sort(gitDirs);
            Object[] objectArray = gitDirs;
            int n3 = gitDirs.length;
            int n4 = 0;
            while (n4 < n3) {
                Object f = objectArray[n4];
                Action menuItem = new Action(repoName, 8, (File)f, action){
                    private final /* synthetic */ File val$f;
                    private final /* synthetic */ Consumer val$action;
                    {
                        this.val$f = file;
                        this.val$action = consumer;
                        super($anonymous0, $anonymous1);
                    }

                    public void run() {
                        try {
                            Repository r = cache.lookupRepository(this.val$f);
                            this.val$action.accept(r);
                        }
                        catch (IOException e) {
                            Activator.showError(e.getLocalizedMessage(), e);
                        }
                    }
                };
                menuItem.setToolTipText(((File)f).getPath());
                if (((File)f).equals(currentRepoDir)) {
                    menuItem.setChecked(true);
                }
                result.add((IAction)menuItem);
                ++n4;
            }
            ++n2;
        }
        return result;
    }

    public static class RepositoryToolbarAction
    extends Action
    implements ActionFactory.IWorkbenchAction,
    IMenuCreator {
        private final RepositoryUtil util = org.eclipse.egit.core.Activator.getDefault().getRepositoryUtil();
        private final IEclipsePreferences preferences = this.util.getPreferences();
        private final IEclipsePreferences.IPreferenceChangeListener listener;
        @NonNull
        private final Consumer<Repository> action;
        @NonNull
        private final Supplier<Repository> currentRepo;
        private final boolean includeBare;
        private Menu menu;
        private boolean showMenu;

        public RepositoryToolbarAction(boolean includeBare, @NonNull Supplier<Repository> currentRepo, @NonNull Consumer<Repository> action) {
            this(UIText.RepositoryToolbarAction_label, UIIcons.REPOSITORY, UIText.RepositoryToolbarAction_tooltip, includeBare, currentRepo, action);
        }

        public RepositoryToolbarAction(String text, @Nullable ImageDescriptor image, @Nullable String tooltip, boolean includeBare, @NonNull Supplier<Repository> currentRepo, @NonNull Consumer<Repository> action) {
            super(text, 4);
            this.setImageDescriptor(image);
            this.setToolTipText(tooltip == null ? text : tooltip);
            this.includeBare = includeBare;
            this.currentRepo = currentRepo;
            this.action = action;
            this.listener = event -> {
                if ("GitRepositoriesView.GitDirectories.relative".equals(event.getKey())) {
                    this.setEnabled(!this.util.getRepositories().isEmpty());
                }
            };
            this.setEnabled(!this.util.getRepositories().isEmpty());
            this.preferences.addPreferenceChangeListener(this.listener);
        }

        public void run() {
            this.showMenu = true;
        }

        public void runWithEvent(Event event) {
            if (!this.isEnabled()) {
                return;
            }
            this.showMenu = false;
            this.run();
            Widget widget = event.widget;
            if (this.showMenu && widget instanceof ToolItem) {
                ToolItem item = (ToolItem)widget;
                Rectangle bounds = item.getBounds();
                event.detail = 4;
                event.x = bounds.x;
                event.y = bounds.y + bounds.height;
                item.notifyListeners(13, event);
            }
        }

        public IMenuCreator getMenuCreator() {
            return this;
        }

        public Menu getMenu(Control parent) {
            if (this.menu != null) {
                this.menu.dispose();
                this.menu = null;
            }
            if (this.isEnabled()) {
                Repository current = this.currentRepo.get();
                File gitDir = current == null ? null : current.getDirectory();
                Collection<IAction> actions = RepositoryMenuUtil.getRepositoryActions(this.includeBare, gitDir, this.action);
                this.menu = new Menu(parent);
                for (IAction a : actions) {
                    ActionContributionItem item = new ActionContributionItem(a);
                    item.fill(this.menu, -1);
                }
            }
            return this.menu;
        }

        public Menu getMenu(Menu parent) {
            return null;
        }

        public void dispose() {
            if (this.menu != null) {
                this.menu.dispose();
                this.menu = null;
            }
            this.preferences.removePreferenceChangeListener(this.listener);
        }
    }
}

