/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.security.ui.storage;

import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.equinox.internal.security.storage.friends.InternalExchangeUtils;
import org.eclipse.equinox.internal.security.storage.friends.PasswordProviderDescription;
import org.eclipse.equinox.internal.security.storage.friends.ReEncrypter;
import org.eclipse.equinox.internal.security.ui.nls.SecUIMessages;
import org.eclipse.equinox.internal.security.ui.storage.ChangePasswordWizardDialog;
import org.eclipse.equinox.internal.security.ui.storage.PasswordRecoveryDialog;
import org.eclipse.equinox.internal.security.ui.storage.StorageUtils;
import org.eclipse.equinox.security.storage.ISecurePreferences;
import org.eclipse.equinox.security.storage.SecurePreferencesFactory;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.LayoutConstants;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.osgi.service.prefs.BackingStoreException;

public class TabPassword {
    private static final String PREFERENCES_PLUGIN = "org.eclipse.equinox.security";
    private static final String PASSWORD_RECOVERY_NODE = "/org.eclipse.equinox.secure.storage/recovery/";
    protected Table providerTable;
    protected Button buttonClearPassword;
    protected Button buttonChangePassword;
    protected Button buttonRecoverPassword;
    protected Text detailsText;
    protected boolean providerModified = false;

    public TabPassword(TabFolder folder, int index, final Shell shell) {
        TabItem tab = new TabItem(folder, 0, index);
        tab.setText(SecUIMessages.tabPassword);
        Composite page = new Composite((Composite)folder, 0);
        page.setLayoutData((Object)new GridData(4, 4, true, false));
        tab.setControl((Control)page);
        Group passwordGroup = new Group(page, 0);
        passwordGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        passwordGroup.setLayout((Layout)new GridLayout(2, false));
        passwordGroup.setText(SecUIMessages.passwordCacheGroup);
        this.buttonClearPassword = new Button((Composite)passwordGroup, 8);
        this.buttonClearPassword.setText(SecUIMessages.logoutButton);
        this.buttonClearPassword.setLayoutData((Object)new GridData(4, 2, false, false));
        this.buttonClearPassword.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InternalExchangeUtils.passwordProvidersReset();
                TabPassword.this.enableLogout();
            }
        });
        this.setButtonSize(this.buttonClearPassword);
        Label passwordNote = new Label((Composite)passwordGroup, 64);
        GridData labelData = new GridData(4, 0x1000000, true, false);
        labelData.widthHint = 340;
        passwordNote.setLayoutData((Object)labelData);
        passwordNote.setText(SecUIMessages.passwordCacheNote);
        Group providersGroup = new Group(page, 0);
        providersGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        providersGroup.setLayout((Layout)new GridLayout());
        providersGroup.setText(SecUIMessages.providerGroup);
        Label providersNote = new Label((Composite)providersGroup, 64);
        GridData gridData = new GridData(4, 0x1000000, true, false);
        gridData.widthHint = 500;
        providersNote.setLayoutData((Object)gridData);
        providersNote.setText(SecUIMessages.providerDescription);
        Composite providersComp = new Composite((Composite)providersGroup, 0);
        providersComp.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        providersComp.setLayout((Layout)gridLayout);
        this.providerTable = new Table(providersComp, 67620);
        GridData tableData = new GridData(4, 4, true, true);
        this.providerTable.setLayoutData((Object)tableData);
        this.providerTable.setLinesVisible(true);
        this.providerTable.setHeaderVisible(true);
        this.fillProviderTable();
        this.providerTable.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                if ((e.detail & 0x20) != 0) {
                    TabPassword.this.providerModified = true;
                }
                TabPassword.this.enableButtons();
                TabPassword.this.updateDescription();
            }
        });
        GridDataFactory.defaultsFor((Control)this.providerTable).span(1, 2).applyTo((Control)this.providerTable);
        this.buttonChangePassword = new Button(providersComp, 8);
        this.buttonChangePassword.setText(SecUIMessages.changePasswordButton);
        this.buttonChangePassword.setLayoutData((Object)new GridData(1, 1, false, false));
        this.buttonChangePassword.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                PasswordProviderDescription selectedModule = TabPassword.this.getSelectedModule();
                if (selectedModule == null) {
                    return;
                }
                String moduleID = TabPassword.this.getSelectedModuleID();
                ISecurePreferences rootNode = SecurePreferencesFactory.getDefault();
                if (selectedModule.hasHint("AutomaticPasswordGeneration")) {
                    TabPassword.this.changePassword(rootNode, moduleID, selectedModule.getName(), shell);
                } else {
                    ChangePasswordWizardDialog dialog = new ChangePasswordWizardDialog(shell, rootNode, moduleID);
                    dialog.open();
                }
                TabPassword.this.enableLogout();
            }
        });
        this.setButtonSize(this.buttonChangePassword);
        this.buttonRecoverPassword = new Button(providersComp, 8);
        this.buttonRecoverPassword.setText(SecUIMessages.recoverPasswordButton);
        this.buttonRecoverPassword.setLayoutData((Object)new GridData(1, 1, false, false));
        this.buttonRecoverPassword.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                String moduleID = TabPassword.this.getSelectedModuleID();
                ISecurePreferences rootNode = SecurePreferencesFactory.getDefault();
                String[] questions = InternalExchangeUtils.getPasswordRecoveryQuestions((ISecurePreferences)rootNode, (String)moduleID);
                if (questions.length == 0) {
                    return;
                }
                PasswordRecoveryDialog dialog = new PasswordRecoveryDialog(questions, shell, moduleID);
                dialog.open();
                TabPassword.this.enableLogout();
            }
        });
        this.setButtonSize(this.buttonRecoverPassword);
        this.enableButtons();
        Label descriptionLabel = new Label(providersComp, 0);
        descriptionLabel.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 2, 1));
        descriptionLabel.setText(SecUIMessages.providerDetails);
        this.detailsText = new Text(providersComp, 18506);
        this.detailsText.setBackground(this.detailsText.getDisplay().getSystemColor(25));
        gridData = new GridData(4, 4, false, false, 1, 1);
        gridData.widthHint = 300;
        gridData.heightHint = 65;
        this.detailsText.setLayoutData((Object)gridData);
        this.updateDescription();
        GridLayoutFactory.fillDefaults().margins(LayoutConstants.getSpacing()).generateLayout(page);
    }

    private void fillProviderTable() {
        TableColumn idColumn = new TableColumn(this.providerTable, 16384);
        idColumn.setText(SecUIMessages.idColumn);
        TableColumn priorityColumn = new TableColumn(this.providerTable, 0x1000000);
        priorityColumn.setText(SecUIMessages.priorityColumn);
        List availableModules = InternalExchangeUtils.passwordProvidersFind();
        HashSet<String> disabledModules = this.getDisabledModules();
        for (PasswordProviderDescription module : availableModules) {
            TableItem item = new TableItem(this.providerTable, 0);
            item.setText(new String[]{module.getName(), Integer.toString(module.getPriority())});
            item.setData((Object)module);
            if (disabledModules == null) {
                item.setChecked(true);
                continue;
            }
            item.setChecked(!disabledModules.contains(module.getId()));
        }
        TableLayout layout = new TableLayout();
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(5));
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(1));
        this.providerTable.setLayout((Layout)layout);
        if (this.providerTable.getItemCount() > 0) {
            this.providerTable.select(0);
        }
    }

    protected PasswordProviderDescription getSelectedModule() {
        if (this.providerTable == null) {
            return null;
        }
        TableItem[] items = this.providerTable.getSelection();
        if (items.length == 0) {
            return null;
        }
        return (PasswordProviderDescription)items[0].getData();
    }

    protected String getSelectedModuleID() {
        PasswordProviderDescription selectedModule = this.getSelectedModule();
        if (selectedModule == null) {
            return null;
        }
        return selectedModule.getId();
    }

    protected void enableButtons() {
        String moduleID = this.getSelectedModuleID();
        if (moduleID == null) {
            this.buttonChangePassword.setEnabled(false);
            this.buttonRecoverPassword.setEnabled(false);
        } else {
            this.buttonChangePassword.setEnabled(true);
            ISecurePreferences rootNode = SecurePreferencesFactory.getDefault();
            String path = PASSWORD_RECOVERY_NODE + moduleID;
            boolean recoveryAvailable = rootNode.nodeExists(path);
            this.buttonRecoverPassword.setEnabled(recoveryAvailable);
        }
        this.enableLogout();
    }

    protected HashSet<String> getDisabledModules() {
        IScopeContext[] scopes = new IScopeContext[]{ConfigurationScope.INSTANCE, DefaultScope.INSTANCE};
        IPreferencesService preferencesService = Platform.getPreferencesService();
        String defaultPreferenceValue = "";
        String tmp = preferencesService.getString(PREFERENCES_PLUGIN, "org.eclipse.equinox.security.preferences.disabledProviders", defaultPreferenceValue, scopes);
        HashSet<String> disabledModules = TabPassword.splitModuleIds(tmp);
        return disabledModules;
    }

    public void performDefaults() {
        TableItem[] items;
        if (this.providerTable == null) {
            return;
        }
        HashSet<String> defaultDisabledModules = this.getDefaultDisabledModules();
        TableItem[] tableItemArray = items = this.providerTable.getItems();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            boolean enabled;
            TableItem item = tableItemArray[n2];
            String moduleId = this.getModuleId(item);
            boolean bl = enabled = defaultDisabledModules == null || moduleId == null || !defaultDisabledModules.contains(moduleId);
            if (item.getChecked() != enabled) {
                item.setChecked(enabled);
                this.providerModified = true;
            }
            ++n2;
        }
    }

    public void performOk() {
        TableItem[] items;
        if (!this.providerModified) {
            return;
        }
        StringBuffer tmp = new StringBuffer();
        boolean first = true;
        TableItem[] tableItemArray = items = this.providerTable.getItems();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            if (!item.getChecked()) {
                if (!first) {
                    tmp.append(',');
                } else {
                    first = false;
                }
                tmp.append(((PasswordProviderDescription)item.getData()).getId());
            }
            ++n2;
        }
        IEclipsePreferences node = ConfigurationScope.INSTANCE.getNode(PREFERENCES_PLUGIN);
        node.put("org.eclipse.equinox.security.preferences.disabledProviders", tmp.toString());
        try {
            node.flush();
        }
        catch (BackingStoreException backingStoreException) {}
        InternalExchangeUtils.passwordProvidersReset();
    }

    public void onActivated() {
        this.enableLogout();
    }

    protected void enableLogout() {
        this.buttonClearPassword.setEnabled(InternalExchangeUtils.isLoggedIn());
    }

    protected void setButtonSize(Button button) {
        GridDataFactory.defaultsFor((Control)button).align(4, 1).grab(false, false).applyTo((Control)button);
    }

    protected boolean changePassword(ISecurePreferences node, String moduleID, String name, Shell shell) {
        MessageBox messageBox;
        ReEncrypter reEncrypter = new ReEncrypter(node, moduleID);
        if (!reEncrypter.decrypt()) {
            messageBox = new MessageBox(shell, 200);
            messageBox.setText(SecUIMessages.changePasswordWizardTitle);
            messageBox.setMessage(SecUIMessages.wizardDecodeWarning);
            if (messageBox.open() == 64) {
                return false;
            }
        }
        if (!reEncrypter.switchToNewPassword()) {
            messageBox = new MessageBox(shell, 33);
            messageBox.setText(SecUIMessages.changePasswordWizardTitle);
            messageBox.setMessage(SecUIMessages.wizardSwitchError);
            messageBox.open();
            return false;
        }
        reEncrypter.encrypt();
        String msg = NLS.bind((String)SecUIMessages.passwordChangeDone, (Object)name);
        MessageDialog.openInformation((Shell)StorageUtils.getShell(), (String)SecUIMessages.generalDialogTitle, (String)msg);
        return true;
    }

    protected void updateDescription() {
        PasswordProviderDescription selectedModule = this.getSelectedModule();
        if (selectedModule != null && this.detailsText != null) {
            this.detailsText.setText(selectedModule.getDescription());
        }
    }

    private HashSet<String> getDefaultDisabledModules() {
        String defaultPreferenceValue = "";
        IEclipsePreferences pluginNode = DefaultScope.INSTANCE.getNode(PREFERENCES_PLUGIN);
        String tmp = pluginNode.get("org.eclipse.equinox.security.preferences.disabledProviders", defaultPreferenceValue);
        HashSet<String> defaultDisabledModules = TabPassword.splitModuleIds(tmp);
        return defaultDisabledModules;
    }

    private String getModuleId(TableItem item) {
        String moduleId = null;
        Object itemData = item.getData();
        if (itemData instanceof PasswordProviderDescription) {
            PasswordProviderDescription module = (PasswordProviderDescription)itemData;
            moduleId = module.getId();
        }
        return moduleId;
    }

    private static HashSet<String> splitModuleIds(String joinedModuleIds) {
        String[] disabledProviders;
        if (joinedModuleIds == null || joinedModuleIds.isEmpty()) {
            return null;
        }
        HashSet<String> modules = new HashSet<String>();
        String[] stringArray = disabledProviders = joinedModuleIds.split(",");
        int n = disabledProviders.length;
        int n2 = 0;
        while (n2 < n) {
            String disabledProvider = stringArray[n2];
            modules.add(disabledProvider);
            ++n2;
        }
        return modules;
    }
}

